/*
 * Decompiled with CFR 0.152.
 */
package com.allianz.cn.pc.services.sms.jobs;

import com.allianz.cn.pc.services.sms.SMSContent;
import com.allianz.cn.pc.services.sms.SMSFactory;
import com.allianz.cn.pc.services.sms.SMSService;
import com.allianz.cn.pc.services.sms.beans.SmsInfo4Job;
import com.allianz.cn.pc.utils.DataSourceClient;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.InterruptableJob;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;

@DisallowConcurrentExecution
public class SmsJob
implements InterruptableJob {
    private static Logger logger = Logger.getLogger(SmsJob.class);
    private boolean isInterrupt = false;

    public void execute(JobExecutionContext jobExecutionContext) {
        JobDataMap dataMap = jobExecutionContext.getJobDetail().getJobDataMap();
        int perAmount = dataMap.getInt("PRE_PROCESS_AMOUNT");
        logger.debug((Object)"start to send sms!");
        List<SmsInfo4Job> unSendsmsList = this.retrieveNeedSendSmsRecord(perAmount);
        logger.debug((Object)("total " + unSendsmsList.size() + " need to send!"));
        for (SmsInfo4Job unSendSMS : unSendsmsList) {
            try {
                SMSService smsService = SMSFactory.getSMSInstance(unSendSMS.getAppName());
                if (!SMSFactory.isAllowSendSms() || !this.closeSmsRecord(unSendSMS.getId())) continue;
                smsService.sendSMS(unSendSMS.getSendMobile(), unSendSMS.getContent());
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        logger.debug((Object)"end to send sms!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SmsInfo4Job> retrieveNeedSendSmsRecord(int perAmount) {
        DataSource smsDS = DataSourceClient.getInstanceByName((String)"jdbc/interfaceGWDS").getDataSource();
        Connection conn = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        ArrayList<SmsInfo4Job> result = new ArrayList<SmsInfo4Job>();
        try {
            conn = smsDS.getConnection();
            prepStmt = conn.prepareStatement("select * from prl_smsgw_schedule_send where status=? and rownum <= ? and (SCHEULE_SENDTIME <= sysdate or SCHEULE_SENDTIME is null)");
            prepStmt.setString(1, SMSContent.SendStatus.unSend.value);
            prepStmt.setInt(2, perAmount);
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                SmsInfo4Job jobEntity = new SmsInfo4Job();
                jobEntity.setId(rs.getInt("id"));
                jobEntity.setContent(rs.getString("content"));
                jobEntity.setSendMobile(rs.getString("SEND_MOBILE"));
                jobEntity.setAppName(rs.getString("APP_NAME"));
                jobEntity.setRemark(rs.getString("remark"));
                result.add(jobEntity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (prepStmt != null) {
                    prepStmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean closeSmsRecord(long id) {
        DataSource smsDS = DataSourceClient.getInstanceByName((String)"jdbc/interfaceGWDS").getDataSource();
        Connection conn = null;
        PreparedStatement prepStmt = null;
        boolean result = false;
        try {
            conn = smsDS.getConnection();
            prepStmt = conn.prepareStatement("update prl_smsgw_schedule_send set status=? where id=? and status=?");
            prepStmt.setString(1, SMSContent.SendStatus.sended.value);
            prepStmt.setLong(2, id);
            prepStmt.setString(3, SMSContent.SendStatus.unSend.value);
            int updateRecordAmt = prepStmt.executeUpdate();
            if (updateRecordAmt == 1) {
                result = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (prepStmt != null) {
                    prepStmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    public void interrupt() {
        this.isInterrupt = true;
    }
}

