/*
 * Decompiled with CFR 0.152.
 */
package com.allianz.cn.pc.services.sms.yimei;

import cn.emay.sdk.client.api.Client;
import com.allianz.cn.pc.services.sms.AbstractSMSService;
import com.allianz.cn.pc.services.sms.SMSContent;
import com.allianz.cn.pc.services.sms.beans.SmsInfo;
import com.allianz.cn.pc.utils.Beans;
import java.util.Map;
import org.apache.log4j.Logger;

public class YiMeiSMSServiceImpl
extends AbstractSMSService {
    private String softwareSerialNo;
    private String key;
    private String password;
    private static YiMeiSMSServiceImpl smsService = null;
    private static Client client = null;
    private static Logger logger = Logger.getLogger(YiMeiSMSServiceImpl.class);
    private static final String SMS_PREFIX_KEY = "yimei";

    @Override
    protected String getProviderPrefix() {
        return SMS_PREFIX_KEY;
    }

    private YiMeiSMSServiceImpl(Map<String, Object> configMap) {
        super(configMap);
        if (this.softwareSerialNo == null) {
            this.softwareSerialNo = (String)configMap.get("yimei.sms.softwareserialno");
            this.key = (String)configMap.get("yimei.sms.key");
            this.password = (String)configMap.get("yimei.sms.password");
            try {
                client = new Client(this.softwareSerialNo, this.key);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static synchronized YiMeiSMSServiceImpl getInstance(Map<String, Object> configMap, boolean reInitFlag) {
        if (smsService != null && !reInitFlag) {
            return smsService;
        }
        smsService = new YiMeiSMSServiceImpl(configMap);
        return smsService;
    }

    @Override
    public int sendSMSToMuti(String[] mobileNos, String content) {
        int status = 0;
        String newContent = this.currentSMSPrefix + content;
        try {
            status = client.sendSMS(mobileNos, newContent, SendLevel.level03.value);
            for (String mobileNo : mobileNos) {
                SmsInfo smsInfo = new SmsInfo();
                smsInfo.setSendMobile(mobileNo);
                smsInfo.setContent(newContent);
                smsInfo.setProvider(SMSContent.Provider.yimei.value);
                smsInfo.setAppName(this.currentAppName);
                smsInfo.setStatus(SMSContent.SendStatus.sended.value);
                this.addSmsRecord(smsInfo);
                logger.debug((Object)("sms send " + mobileNo + " content is " + content + ", result:" + status));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }

    @Override
    public int sendSMS(String mobileNo, String content) {
        String newMobileNo;
        int result = 0;
        String string = newMobileNo = Beans.isEmpty((Object)mobileNo) ? "" : mobileNo.trim();
        if (!Beans.isEmpty((Object)newMobileNo) && newMobileNo.length() == 11) {
            result = this.sendSMSToMuti(new String[]{newMobileNo}, content);
        } else {
            String newContent = this.currentSMSPrefix + content;
            SmsInfo smsInfo = new SmsInfo();
            smsInfo.setSendMobile(newMobileNo);
            smsInfo.setContent(newContent);
            smsInfo.setProvider(SMSContent.Provider.yimei.value);
            smsInfo.setAppName(this.currentAppName);
            smsInfo.setStatus(SMSContent.SendStatus.sended.value);
            this.addSmsRecord(smsInfo);
            logger.debug((Object)("sms send " + mobileNo + " content is " + content + ", result: no need send!"));
        }
        return result;
    }

    public String retrieveBalanceAmt() {
        try {
            String a = client.getBalance();
            return a;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static enum SendLevel {
        level01(1),
        level02(2),
        level03(3),
        level04(4),
        level05(5);

        public final int value;

        private SendLevel(int value) {
            this.value = value;
        }
    }
}

