/*
 * Decompiled with CFR 0.152.
 */
package com.allianz.cn.pc.action;

import com.allianz.cn.pc.Consts;
import com.allianz.cn.pc.services.sms.SMSFactory;
import com.allianz.cn.pc.services.sms.SMSService;
import com.allianz.cn.pc.services.smsmailgw.services.Config;
import com.allianz.cn.pc.utils.Beans;
import com.allianz.cn.pc.utils.XmlUtil;
import com.allianz.cn.pc.xmlbean.sms.SmsRequest;
import com.allianz.cn.pc.xmlbean.sms.SmsResponse;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;

public class SmsAction {
    static Logger logger = Logger.getLogger(SmsAction.class);

    public SmsResponse doProcess(Document doc) throws Exception {
        SmsResponse smsResponse = new SmsResponse();
        SmsRequest smsReq = this.generalRequest(doc);
        String origin = smsReq.getOrigin();
        String mobile = smsReq.getMobileNo();
        String model = smsReq.getModel();
        String value = smsReq.getValue();
        logger.info((Object)("sms sending params--origin=" + origin + ",mobile=" + mobile + ",model=" + model + ",value=" + value));
        String result = this.vaidateSmsRequest(smsReq);
        if (Beans.isNotEmpty((Object)result)) {
            smsResponse.setResult(Consts.ErrorType.failure.value);
            smsResponse.setMessage(result);
            return smsResponse;
        }
        String modelContent = "";
        model = (String)Config.getInstance().getSmsModelMap().get(model);
        if (Beans.isNotEmpty((Object)model)) {
            modelContent = model;
            if (Beans.isNotEmpty((Object)value)) {
                String[] values;
                for (String s : values = value.split("%%")) {
                    modelContent = modelContent.replaceFirst("%s", s);
                }
            }
        } else {
            modelContent = value;
        }
        String[] mobiles = mobile.split("#");
        logger.info((Object)("sms sending,size-" + mobiles.length + ",content-" + modelContent));
        String processResult = "success";
        Integer sendResult = null;
        Integer failSize = 0;
        for (String nb : mobiles) {
            sendResult = this.sendSMS(origin, nb, modelContent);
            logger.info((Object)("sms sended to " + nb + ",result--" + sendResult));
            if (0 == sendResult) continue;
            failSize = failSize + 1;
            processResult = "failure";
        }
        if ("success".equals(processResult)) {
            smsResponse.setResult(Consts.ErrorType.success.value);
            smsResponse.setMessage(Consts.errorMessageMap.get(Consts.ErrorType.success.value));
        } else {
            logger.info((Object)("sms sended error size: " + failSize));
            smsResponse.setResult(Consts.ErrorType.failure.value);
            if (mobiles.length == failSize) {
                smsResponse.setMessage(Consts.ErrorMessage.sendingError.value);
            } else if (0 < failSize) {
                smsResponse.setMessage(Consts.ErrorMessage.sendingWarning.value);
            } else {
                smsResponse.setMessage(Consts.errorMessageMap.get(Consts.ErrorType.failure.value));
            }
        }
        return smsResponse;
    }

    private SmsRequest generalRequest(Document doc) {
        SmsRequest enquiryRequest = new SmsRequest();
        Element root = doc.getRootElement();
        enquiryRequest = (SmsRequest)XmlUtil.fromXml(SmsRequest.class, (String)root.asXML());
        return enquiryRequest;
    }

    public Integer sendSMS(String appName, String mobile, String content) {
        Integer returnvalue = null;
        SMSService smsService = SMSFactory.getSMSInstance(appName);
        returnvalue = smsService.sendSMS(mobile, content);
        logger.info((Object)("\u77ed\u4fe1\u7f51\u5173\u8fd4\u56de\u503c\uff1a" + returnvalue));
        return returnvalue;
    }

    private String vaidateSmsRequest(SmsRequest smsReq) {
        String returnvalue = null;
        if (Beans.isEmpty((Object)smsReq.getOrigin())) {
            returnvalue = "origin is null";
        }
        if (Beans.isEmpty((Object)smsReq.getMobileNo())) {
            returnvalue = "mobileNo is null";
        }
        if (Beans.isEmpty((Object)smsReq.getModel()) && Beans.isEmpty((Object)smsReq.getValue())) {
            returnvalue = "model & value are null";
        }
        return returnvalue;
    }
}

