/*
 * Decompiled with CFR 0.152.
 */
package com.allianz.cn.pc.services.sms;

import com.allianz.cn.pc.services.sms.SMSService;
import com.allianz.cn.pc.utils.DataSourceClient;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;

public abstract class AbstractSMSService
implements SMSService {
    protected String softwareSerialNo = null;
    protected String key = null;
    protected String prefixWord = "";

    protected AbstractSMSService() {
        Map<String, String> configMap = AbstractSMSService.retrieveSMSConfigInfo();
        this.softwareSerialNo = configMap.get(this.getProviderInfo() + ".sms.softwareserialno");
        this.key = configMap.get(this.getProviderInfo() + ".sms.key");
        this.prefixWord = configMap.get(this.getProviderInfo() + ".sms.prefix") != null ? configMap.get(this.getProviderInfo() + ".sms.prefix") : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Map<String, String> retrieveSMSConfigInfo() {
        DataSource smsDS = DataSourceClient.getInstanceByName((String)"jdbc/interfaceGWDS").getDataSource();
        Connection conn = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            conn = smsDS.getConnection();
            prepStmt = conn.prepareStatement("select * from prpl_app_parameter where app_name='SMSMAILGT' ");
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                result.put(rs.getString("key"), rs.getString("value"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (prepStmt != null) {
                    prepStmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    public String getSoftwareSerialNo() {
        return this.softwareSerialNo;
    }

    public String getKey() {
        return this.key;
    }

    public String getPrefixWord() {
        return this.prefixWord;
    }
}

