/*
 * Decompiled with CFR 0.152.
 */
package com.allianz.cn.pc.services.sms;

import com.allianz.cn.pc.services.sms.SMSProxyService;
import com.allianz.cn.pc.services.sms.SMSService;
import com.allianz.cn.pc.services.sms.yimei.YiMeiSMS3332ServiceImpl;
import com.allianz.cn.pc.services.sms.yimei.YiMeiSMSServiceImpl;
import com.allianz.cn.pc.services.smsmailgw.Constants;
import com.allianz.cn.pc.utils.Beans;
import com.allianz.cn.pc.utils.DataSourceClient;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class SMSFactory {
    private static Map<String, Object> mutiProjectConfigMap = new HashMap<String, Object>();
    private static final String default_app_name = "defaultApp";
    private static final String REFRESH_INTERVAL_TIME = "refresh.interval.time";
    private static final String LAST_REFRESH_TIME = "last.refresh.time";
    public static final String SMS_PROVIDER_KEY_NAME = "sms.provider";
    public static final String SMS_PROVIDER_YIMEI = "yimei";
    public static final String SMS_PROVIDER_YIMEI2 = "yimei2";
    public static final String CURRENT_APP_NAME = "currentAppName";
    public static final String CURRENT_SEND_TABLE_NAME = "sms.send.tablename";
    public static final String SMS_FLAG = "sms.sendflag";
    public static final String SMS_SERVICE = "sms.service";
    private static Logger logger = Logger.getLogger(SMSFactory.class);

    public static SMSService getSMSInstance() {
        logger.debug((Object)"start to getInstance");
        return SMSFactory.getSMSInstance(null);
    }

    public static synchronized SMSService getSMSInstance(String projectName) {
        HashMap projectConfigMap;
        String appName = projectName;
        if (Beans.isEmpty((Object)appName)) {
            appName = default_app_name;
        }
        if (mutiProjectConfigMap.size() == 0 || SMSFactory.isNeedRefresh() || mutiProjectConfigMap.get(appName) == null) {
            logger.debug((Object)"start to init");
            logger.debug((Object)"Start to refresh SMS config");
            if (mutiProjectConfigMap.size() == 0) {
                mutiProjectConfigMap.put(LAST_REFRESH_TIME, new Date());
            }
            SMSFactory.initConfigValue(appName);
            logger.debug((Object)"End refresh SMS config");
        }
        if ((projectConfigMap = (HashMap)mutiProjectConfigMap.get(appName)) == null) {
            projectConfigMap = (HashMap)mutiProjectConfigMap.get(default_app_name);
        }
        return (SMSService)projectConfigMap.get(SMS_SERVICE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initConfigValue(String appName) {
        DataSource smsDS = DataSourceClient.getInstanceByName((String)"jdbc/interfaceGWDS").getDataSource();
        Connection conn = null;
        PreparedStatement prepStmt = null;
        Statement prepStmt2 = null;
        ResultSet rs = null;
        ResultSet rs2 = null;
        HashMap<String, Object> projectConfigMap = new HashMap<String, Object>();
        projectConfigMap.put(CURRENT_APP_NAME, appName);
        mutiProjectConfigMap.put(appName, projectConfigMap);
        try {
            String smsProviderName;
            conn = smsDS.getConnection();
            prepStmt = conn.prepareStatement("select * from prpl_app_parameter where app_name=? and status='1' ");
            prepStmt.setString(1, "SMSMAILGT");
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                projectConfigMap.put(rs.getString("KEY"), rs.getString("VALUE"));
                if (!REFRESH_INTERVAL_TIME.equalsIgnoreCase(rs.getString("key")) || rs.getString("value") == null || rs.getString("value").trim().equals("")) continue;
                mutiProjectConfigMap.put(REFRESH_INTERVAL_TIME, rs.getString("value"));
            }
            if (!Beans.isEmpty((Object)appName) || !default_app_name.equalsIgnoreCase(appName)) {
                prepStmt2 = conn.prepareStatement("select * from prpl_app_parameter where app_name=? and status='1' and lower(key) like 'sms%' ");
                prepStmt2.setString(1, appName);
                rs2 = prepStmt2.executeQuery();
                while (rs2.next()) {
                    if (Beans.isEmpty((Object)rs2.getString("value"))) continue;
                    projectConfigMap.put(rs2.getString("key"), rs2.getString("value"));
                    logger.debug((Object)(appName + " config is " + rs2.getString("key") + "," + rs2.getString("value")));
                }
            }
            SMSProxyService proxyService = new SMSProxyService();
            proxyService.setAppName(appName);
            proxyService.setCurrentSendTableName((String)projectConfigMap.get(CURRENT_SEND_TABLE_NAME));
            String smsFlag = (String)projectConfigMap.get(SMS_FLAG);
            if (smsFlag != null && smsFlag.trim().equals("0")) {
                proxyService.setIsAllowSendSMS(false);
            }
            if (SMS_PROVIDER_YIMEI.equalsIgnoreCase(smsProviderName = (String)projectConfigMap.get(SMS_PROVIDER_KEY_NAME))) {
                proxyService.setSmsService(YiMeiSMSServiceImpl.getInstance());
            }
            if (SMS_PROVIDER_YIMEI2.equalsIgnoreCase(smsProviderName)) {
                proxyService.setSmsService(YiMeiSMS3332ServiceImpl.getInstance());
            } else {
                proxyService.setSmsService(YiMeiSMSServiceImpl.getInstance());
            }
            projectConfigMap.put(SMS_SERVICE, proxyService);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (rs2 != null) {
                    rs2.close();
                }
                if (prepStmt != null) {
                    prepStmt.close();
                }
                if (prepStmt2 != null) {
                    prepStmt2.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }

    private static boolean isNeedRefresh() {
        boolean result = false;
        if (mutiProjectConfigMap.get(REFRESH_INTERVAL_TIME) != null) {
            if (mutiProjectConfigMap.get(LAST_REFRESH_TIME) == null) {
                mutiProjectConfigMap.put(LAST_REFRESH_TIME, new Date());
            } else {
                int intervalTime = Integer.valueOf(mutiProjectConfigMap.get(REFRESH_INTERVAL_TIME).toString());
                Calendar cal = Calendar.getInstance();
                cal.setTime((Date)mutiProjectConfigMap.get(LAST_REFRESH_TIME));
                cal.add(12, intervalTime);
                Date currentDate = new Date();
                if (currentDate.compareTo(cal.getTime()) > 0) {
                    logger.debug((Object)("update last refresh time to " + currentDate + ",intervalTime is " + intervalTime));
                    mutiProjectConfigMap.put(LAST_REFRESH_TIME, currentDate);
                    return true;
                }
            }
        }
        return result;
    }

    public static boolean isAllowSendSms(String appName) {
        HashMap configMap = (HashMap)mutiProjectConfigMap.get(appName);
        if (configMap != null) {
            String sendMsgFlg = (String)configMap.get(SMS_FLAG);
            return Beans.isEmpty((Object)sendMsgFlg) || !Constants.SMSSendSwitch.Off.value.equals(sendMsgFlg);
        }
        return false;
    }
}

