/*
 * Decompiled with CFR 0.152.
 */
package com.allianz.cn.pc.services.sms;

import com.allianz.cn.pc.services.sms.SMSContent;
import com.allianz.cn.pc.services.sms.SMSService;
import com.allianz.cn.pc.services.sms.beans.SmsInfo;
import com.allianz.cn.pc.services.sms.beans.SmsReceive;
import com.allianz.cn.pc.utils.DataSourceClient;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class SMSProxyService
implements SMSService {
    private String appName;
    private String currentSendTableName;
    private SMSService smsService;
    private static Logger logger = Logger.getLogger(SMSProxyService.class);
    private boolean isAllowSendSMS = true;

    @Override
    public int sendSMSToMuti(String[] oldMobileNos, String content) {
        int status = 0;
        if (oldMobileNos == null || oldMobileNos.length == 0) {
            return 0;
        }
        if (!this.isAllowSendSMS) {
            logger.info((Object)"sms.flag of the app is 0,not allowed send sms!");
            return -2;
        }
        ArrayList<String> validMobileArry = new ArrayList<String>();
        for (String mobileNo : oldMobileNos) {
            if (!this.isValidPhoneNumber(mobileNo)) continue;
            validMobileArry.add(mobileNo.trim());
        }
        if (validMobileArry.size() == 0) {
            return 0;
        }
        String[] mobileNos = validMobileArry.toArray(new String[validMobileArry.size()]);
        try {
            status = this.smsService.sendSMSToMuti(mobileNos, content);
            for (String mobileNo : mobileNos) {
                SmsInfo smsInfo = new SmsInfo();
                smsInfo.setSendMobile(mobileNo);
                smsInfo.setContent(content);
                smsInfo.setProvider(this.smsService.getProviderInfo());
                smsInfo.setAppName(this.appName);
                smsInfo.setStatus(SMSContent.SendStatus.sended.value);
                smsInfo.setReturnStatus("" + status);
                this.addSmsRecord(smsInfo);
                logger.debug((Object)("sms send " + mobileNo + " content is " + content + ", result:" + status));
            }
        }
        catch (Exception e) {
            status = -1;
            logger.error((Object)"send sms error!", (Throwable)e);
            e.printStackTrace();
        }
        return status;
    }

    @Override
    public int sendSMS(String mobileNo, String content) {
        if (this.isValidPhoneNumber(mobileNo)) {
            return this.sendSMSToMuti(new String[]{mobileNo.trim()}, content);
        }
        return 0;
    }

    @Override
    public List<SmsReceive> receiveSMS() {
        return Collections.emptyList();
    }

    private boolean isValidPhoneNumber(String mobileNo) {
        return mobileNo != null && !mobileNo.trim().equals("") && mobileNo.trim().length() == 11;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSmsRecord(SmsInfo smsInfo) {
        DataSource smsDS = DataSourceClient.getInstanceByName((String)"jdbc/interfaceGWDS").getDataSource();
        Connection conn = null;
        Statement prepStmt = null;
        try {
            conn = smsDS.getConnection();
            prepStmt = conn.prepareStatement("insert into " + this.currentSendTableName + "(ID,CONTENT,SEND_MOBILE,PROVIDER,APP_NAME,STATUS,value1,value2,remark,flag,SENDTIME,returnstatus) " + "values(prl_smsgw_send_seq.nextval,?,?,?,?,?,?,?,?,?,?,?)");
            prepStmt.setString(1, smsInfo.getContent());
            prepStmt.setString(2, smsInfo.getSendMobile());
            prepStmt.setString(3, smsInfo.getProvider());
            prepStmt.setString(4, smsInfo.getAppName());
            prepStmt.setString(5, smsInfo.getStatus());
            prepStmt.setString(6, smsInfo.getValue1());
            prepStmt.setString(7, smsInfo.getValue2());
            prepStmt.setString(8, smsInfo.getRemark());
            prepStmt.setString(9, smsInfo.getFlag());
            if (SMSContent.SendStatus.sended.value.equals(smsInfo.getStatus())) {
                prepStmt.setTimestamp(10, new Timestamp(System.currentTimeMillis()));
            } else {
                prepStmt.setTimestamp(10, null);
            }
            prepStmt.setString(11, smsInfo.getReturnStatus());
            prepStmt.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (prepStmt != null) {
                    prepStmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public String getProviderInfo() {
        return null;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setCurrentSendTableName(String currentSendTableName) {
        this.currentSendTableName = currentSendTableName;
    }

    public String getCurrentSendTableName() {
        return this.currentSendTableName;
    }

    public void setSmsService(SMSService smsService) {
        this.smsService = smsService;
    }

    public SMSService getSmsService() {
        return this.smsService;
    }

    public static void setLogger(Logger logger) {
        SMSProxyService.logger = logger;
    }

    public static Logger getLogger() {
        return logger;
    }

    public void setIsAllowSendSMS(boolean isAllowSendSMS) {
        this.isAllowSendSMS = isAllowSendSMS;
    }

    public boolean isIsAllowSendSMS() {
        return this.isAllowSendSMS;
    }
}

