/*
 * Decompiled with CFR 0.152.
 */
package com.allianz.cn.pc.services.sms.jobs;

import com.allianz.cn.pc.services.sms.beans.SmsReceive;
import com.allianz.cn.pc.services.sms.beans.SmsResearch;
import com.allianz.cn.pc.services.sms.utils.SmsResearchExcelCreater;
import com.allianz.cn.pc.services.smsmailgw.Constants;
import com.allianz.cn.pc.services.smsmailgw.mail.MailManager;
import com.allianz.cn.pc.utils.Beans;
import com.allianz.cn.pc.utils.DataSourceClient;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.InterruptableJob;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;

@DisallowConcurrentExecution
public class SmsMYDResearchReceiveJob
implements InterruptableJob {
    private static Logger logger = Logger.getLogger(SmsMYDResearchReceiveJob.class);
    private boolean isInterrupt = false;
    private static final String BUSINESS_TYPE = "MYD";

    public void execute(JobExecutionContext jobExecutionContext) {
        logger.debug((Object)"start to export sms research!");
        try {
            JobDataMap dataMap = jobExecutionContext.getJobDetail().getJobDataMap();
            Integer lastdays = dataMap.getInt("PRE_PROCESS_AMOUNT");
            String time = dataMap.getString("JOB_CONTENT_GROUP");
            String email = dataMap.getString("JOB_CONTENT");
            String serviceProvider = dataMap.getString("SERVICE_PROVIDER");
            List<SmsReceive> smsList = this.getNewReceiveSms();
            logger.debug((Object)("get received sms of today from prl_smsgw_sms_receive, size is " + smsList.size()));
            int updateNum = 0;
            for (SmsReceive sms : smsList) {
                updateNum += this.updateSmsResearch(sms).intValue();
            }
            if (updateNum <= 0) {
                logger.debug((Object)"no new feedback sms!");
                return;
            }
            logger.debug((Object)(updateNum + " new feedback sms!"));
            byte[] filebyte = null;
            if (Beans.isNotEmpty((Object)lastdays) && 0 != lastdays && Beans.isNotEmpty((Object)time)) {
                Timestamp d_start = this.getDate(time, -lastdays.intValue());
                Timestamp d_end = this.getDate(time, 0);
                filebyte = this.exportExcel(d_start, d_end);
            } else {
                filebyte = this.exportExcel(null, null);
            }
            String dateString = this.getDateString();
            if (null != filebyte) {
                this.sendMail(serviceProvider, email, null, "\u77ed\u4fe1\u6ee1\u610f\u5ea6\u8c03\u67e5\u7ed3\u679c", new ByteArrayInputStream(filebyte), "\u77ed\u4fe1\u6ee1\u610f\u5ea6\u8c03\u67e5\u7ed3\u679c" + dateString + ".xls", "");
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            e.printStackTrace();
        }
        logger.debug((Object)"end to export sms research!");
    }

    public boolean sendMail(String serviceProvider, String emailAddress, String ccAddress, String title, ByteArrayInputStream is, String attachName, String contentHtml) {
        MailManager mailManager = MailManager.getInstance((String)serviceProvider);
        return mailManager.sendHtmlMail(emailAddress, ccAddress, title, (InputStream)is, attachName, contentHtml);
    }

    public byte[] exportExcel(Timestamp d_start, Timestamp d_end) throws IOException {
        List<SmsResearch> smsResearchList = this.retrieveSmsResearch(d_start, d_end);
        if (Beans.isEmpty(smsResearchList) || smsResearchList.size() == 0) {
            return null;
        }
        SmsResearchExcelCreater r = new SmsResearchExcelCreater(smsResearchList);
        return r.getExcelByte();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SmsResearch> retrieveSmsResearch(Timestamp d_start, Timestamp d_end) {
        logger.info((Object)("retrieveSmsResearch params -- d_start:" + d_start + " d_end:" + d_end));
        ArrayList<SmsResearch> returnvalue = new ArrayList<SmsResearch>();
        DataSource smsDS = DataSourceClient.getInstanceByName((String)"jdbc/interfaceGWDS").getDataSource();
        Connection conn = null;
        Statement prepStmt = null;
        ResultSet rs = null;
        try {
            conn = smsDS.getConnection();
            StringBuilder sql = new StringBuilder("select * from prl_smsgw_sms_research a where 1=1");
            if (Beans.isNotEmpty((Object)d_start) && Beans.isNotEmpty((Object)d_end)) {
                sql.append(" and a.feedback_time>?");
                sql.append(" and a.feedback_time<=?");
            }
            logger.info((Object)("retrieveSmsResearch sql is: " + sql.toString()));
            prepStmt = conn.prepareStatement(sql.toString());
            if (Beans.isNotEmpty((Object)d_start) && Beans.isNotEmpty((Object)d_end)) {
                prepStmt.setTimestamp(1, d_start);
                prepStmt.setTimestamp(2, d_end);
            }
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                SmsResearch sms = new SmsResearch();
                sms.setBusiness_time(rs.getTimestamp("business_time"));
                sms.setService_staff(rs.getString("service_staff"));
                sms.setMobile_number(rs.getString("mobile_number"));
                sms.setCustomer_name(rs.getString("customer_name"));
                sms.setCall_time(rs.getTimestamp("call_time"));
                sms.setCall_summary((String)Constants.mydSummaryMap.get(rs.getString("call_summary")));
                sms.setProduct_type((String)Constants.productTypeMap.get(rs.getString("product_type")));
                sms.setCustomer_region((String)Constants.customerRegionMap.get(rs.getString("customer_region")));
                sms.setSms_status((String)Constants.smsStatusMap.get(rs.getString("sms_status")));
                sms.setCustomer_feedback(rs.getString("customer_feedback"));
                returnvalue.add(sms);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (prepStmt != null) {
                    prepStmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return returnvalue;
    }

    private static String getScope(String content) {
        String returnvalue = null;
        if (Beans.isEmpty((Object)content)) {
            return returnvalue;
        }
        int index = content.indexOf("#");
        returnvalue = content.substring(index + 1);
        return returnvalue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer updateSmsResearch(SmsReceive sms) throws Exception {
        Integer returnvalue = null;
        DataSource smsDS = DataSourceClient.getInstanceByName((String)"jdbc/interfaceGWDS").getDataSource();
        Connection conn = null;
        Statement prepStmt = null;
        try {
            conn = smsDS.getConnection();
            StringBuilder sql = new StringBuilder("update prl_smsgw_sms_research a set a.sms_status=?,a.customer_feedback=?,a.feedback_time=?,a.feedback_id=? where id =(");
            sql.append("select id from(");
            sql.append(" select a.id,a.sms_sendtime from prl_smsgw_sms_research a where a.sms_status = ? and a.mobile_number=? ");
            sql.append(" and to_date(to_char(a.sms_sendtime,'yyyy-mm-dd hh24:mi:ss'),'yyyy-mm-dd hh24:mi:ss') < to_date(to_char(?+120/24/60/60,'yyyy-mm-dd HH24:MI:SS'),'yyyy-mm-dd HH24:MI:SS')");
            sql.append(" and (select count(*) from prl_smsgw_sms_research where feedback_id=?)=0");
            sql.append(" order by sms_sendtime)");
            sql.append(" where rownum=1)");
            prepStmt = conn.prepareStatement(sql.toString());
            try {
                int i = Integer.parseInt(sms.getSmsContent());
                if (1 <= i && i <= 4) {
                    prepStmt.setString(1, Constants.SmsResearStatus.sent_feedbacked.value);
                } else {
                    prepStmt.setString(1, Constants.SmsResearStatus.sent_errorfeedback.value);
                }
            }
            catch (Exception e) {
                prepStmt.setString(1, Constants.SmsResearStatus.sent_errorfeedback.value);
            }
            prepStmt.setString(2, sms.getSmsContent());
            prepStmt.setTimestamp(3, new Timestamp(sms.getReceiveTime().getTime()));
            prepStmt.setInt(4, sms.getId());
            prepStmt.setString(5, Constants.SmsResearStatus.sent_nofeedback.value);
            prepStmt.setString(6, sms.getMobileNumber());
            prepStmt.setTimestamp(7, new Timestamp(sms.getReceiveTime().getTime()));
            prepStmt.setInt(8, sms.getId());
            returnvalue = prepStmt.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage());
            returnvalue = -1;
        }
        finally {
            try {
                if (prepStmt != null) {
                    prepStmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return returnvalue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SmsReceive> getNewReceiveSms() {
        ArrayList<SmsReceive> returnvalue = new ArrayList<SmsReceive>();
        DataSource smsDS = DataSourceClient.getInstanceByName((String)"jdbc/interfaceGWDS").getDataSource();
        Connection conn = null;
        Statement prepStmt = null;
        ResultSet rs = null;
        try {
            conn = smsDS.getConnection();
            StringBuilder sql = new StringBuilder("select * from prl_smsgw_sms_receive where id not in(select feedback_id from prl_smsgw_sms_research where feedback_id is not null) order by receive_time");
            logger.info((Object)("getReceiveSms sql is: " + sql.toString()));
            prepStmt = conn.prepareStatement(sql.toString());
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                SmsReceive sms = new SmsReceive();
                sms.setId(rs.getInt("id"));
                sms.setBusinessType(rs.getString("business_type"));
                sms.setMobileNumber(rs.getString("mobile_number"));
                sms.setSmsContent(rs.getString("sms_content"));
                sms.setReceiveTime(rs.getTimestamp("receive_time"));
                returnvalue.add(sms);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (prepStmt != null) {
                    prepStmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return returnvalue;
    }

    public void interrupt() {
        this.isInterrupt = true;
    }

    public Timestamp getDate(String time, int day) {
        Timestamp returnvalue = null;
        String[] items = time.split(":");
        int h = Integer.parseInt(items[0]);
        int m = Integer.parseInt(items[1]);
        Calendar cal = Calendar.getInstance();
        cal.set(5, cal.get(5) + day);
        cal.set(11, h);
        cal.set(12, m);
        returnvalue = new Timestamp(cal.getTime().getTime());
        return returnvalue;
    }

    public String getDateString() {
        String returnvalue = null;
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        returnvalue = day < 10 ? String.valueOf(year) + String.valueOf(month) + "0" + String.valueOf(day) : String.valueOf(year) + String.valueOf(month) + String.valueOf(day);
        return returnvalue;
    }
}

