/*
 * Decompiled with CFR 0.152.
 */
package com.allianz.cn.pc.services.sms.jobs;

import com.allianz.cn.pc.services.sms.beans.SmsReceive;
import com.allianz.cn.pc.services.sms.beans.SmsResearch;
import com.allianz.cn.pc.services.sms.jobs.SmsMYDResearchReceiveJob;
import com.allianz.cn.pc.services.sms.utils.SmsResearchExcelCreater;
import com.allianz.cn.pc.utils.Beans;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.sql.Timestamp;
import java.util.List;
import org.apache.cactus.ServletTestCase;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class SmsMYDResearchReceiveJobTest
extends ServletTestCase {
    private static SmsMYDResearchReceiveJob obj = new SmsMYDResearchReceiveJob();
    private static List<SmsReceive> smsList = null;
    private static List<SmsResearch> smsResearchList = null;
    private static byte[] excelBytes = null;

    public static void main(String[] args) {
        String[] args2 = new String[]{SmsMYDResearchReceiveJobTest.class.getName()};
        JUnitCore.main((String[])args2);
    }

    @Before
    public void setUp() throws Exception {
        System.out.println("SmsResearchExcelReaderTest setUp");
    }

    @After
    public void tearDown() throws Exception {
    }

    @BeforeClass
    public static void setUpBeforeClass() {
        System.out.println("SmsResearchExcelReaderTest setUpBeforeClass");
    }

    @AfterClass
    public static void tearDownAfterClass() {
        System.out.println("SmsResearchExcelReaderTest tearDownAfterClass");
    }

    @Test
    public void test1GetReceiveSms() {
        smsList = obj.getNewReceiveSms();
        SmsMYDResearchReceiveJobTest.assertEquals((int)1, (int)smsList.size());
    }

    @Test
    public void test2UpdateSmsResearch() {
        try {
            for (SmsReceive sms : smsList) {
                obj.updateSmsResearch(sms);
            }
        }
        catch (Exception e) {
            SmsMYDResearchReceiveJobTest.fail((String)"updateSmsResearch error");
        }
    }

    @Test
    public void test3retrieveSmsResearch() {
        Timestamp d_start = obj.getDate("17:30", -100);
        Timestamp d_end = obj.getDate("17:30", 100);
        smsResearchList = obj.retrieveSmsResearch(d_start, d_end);
        SmsMYDResearchReceiveJobTest.assertEquals((int)1, (int)smsResearchList.size());
    }

    @Test
    public void test4ExportExcel() {
        if (Beans.isEmpty(smsResearchList) || smsResearchList.size() == 0) {
            SmsMYDResearchReceiveJobTest.fail((String)"\u8c03\u67e5\u7ed3\u679c\u4e3a\u7a7a");
        }
        SmsResearchExcelCreater r = new SmsResearchExcelCreater(smsResearchList);
        String outdir = "D:\\temp\\interfacegw\\smsMail\\smsResearchResult";
        try {
            excelBytes = r.getExcelByte();
            FileOutputStream out = new FileOutputStream(outdir + "\\test.xls");
            out.write(excelBytes);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            SmsMYDResearchReceiveJobTest.fail((String)"\u5bfc\u51faexcel\u5931\u8d25");
            e.printStackTrace();
        }
    }

    @Test
    public void test5SendMail() {
        if (Beans.isEmpty((Object)excelBytes)) {
            SmsMYDResearchReceiveJobTest.fail((String)"\u9644\u4ef6\u5185\u5bb9\u4e3a\u7a7a");
        }
        Boolean result = obj.sendMail("itApplication", "coffeexie.sino@allianz.cn", null, "\u77ed\u4fe1\u6ee1\u610f\u5ea6\u8c03\u67e5\u7ed3\u679c", new ByteArrayInputStream(excelBytes), "\u77ed\u4fe1\u6ee1\u610f\u5ea6\u8c03\u67e5\u7ed3\u679c.xls", null);
        SmsMYDResearchReceiveJobTest.assertTrue((boolean)result);
    }

    static {
        System.out.println("SmsResearchExcelReaderTest static");
    }
}

