/*
 * Decompiled with CFR 0.152.
 */
package com.allianz.cn.pc.services.sms.jobs;

import com.allianz.cn.pc.services.sms.beans.SmsResearch;
import com.allianz.cn.pc.services.sms.utils.SmsResearchExcelReader;
import com.allianz.cn.pc.services.smsmailgw.Constants;
import com.allianz.cn.pc.utils.Beans;
import com.allianz.cn.pc.utils.DataSourceClient;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.InterruptableJob;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;

@DisallowConcurrentExecution
public class SmsMYDResearchSendJob
implements InterruptableJob {
    private static Logger logger = Logger.getLogger(SmsMYDResearchSendJob.class);
    private boolean isInterrupt = false;
    private static final String BUSINESS_TYPE = "MYD";
    private static final String tag_success = "_success";
    private static final String tag_failure = "_failure";
    private static final String current_app = "SMSMAILGT";
    private String scanPath = null;

    public void execute(JobExecutionContext jobExecutionContext) {
        logger.debug((Object)"start to import sms research!");
        try {
            JobDataMap dataMap = jobExecutionContext.getJobDetail().getJobDataMap();
            this.scanPath = dataMap.getString("ATTACH_URL");
            Integer count = dataMap.getInt("PRE_PROCESS_AMOUNT");
            File file = new File(this.scanPath);
            this.scanDirAndSave(file);
            this.retriveAndSendMsg(count);
        }
        catch (Exception e) {
            logger.error((Object)e);
            e.printStackTrace();
        }
        logger.debug((Object)"end to import sms research!");
    }

    public Integer retriveAndSendMsg(Integer count) {
        Integer returnvalue = 0;
        List<SmsResearch> unSendsmsList = this.retrieveNeedSendSmsRecord(count);
        for (SmsResearch sms : unSendsmsList) {
            try {
                this.addSmsSchedule(sms);
                sms.setSms_status(Constants.SmsResearStatus.sent_nofeedback.value);
                sms.setSms_sendtime(new Date());
                returnvalue = returnvalue + this.updateResearchSmsStatus(sms);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return returnvalue;
    }

    private Integer addSmsSchedule(SmsResearch sms) throws Exception {
        Integer returnvalue = null;
        DataSource smsDS = DataSourceClient.getInstanceByName((String)"jdbc/interfaceGWDS").getDataSource();
        Connection conn = null;
        Statement prepStmt = null;
        try {
            conn = smsDS.getConnection();
            String sql = "insert into prl_smsgw_schedule_send (ID, CONTENT, SEND_MOBILE, APP_NAME, STATUS, SCHEULE_SENDTIME, REMARK, INSERTTIMEFORHIS, OPERATIONTIME)values (prl_smsgw_schedule_seq.nextval, ?, ?, ?, '0', null, ?, ?, null)";
            prepStmt = conn.prepareStatement(sql);
            prepStmt.setString(1, sms.getSend_content());
            prepStmt.setString(2, sms.getMobile_number());
            prepStmt.setString(3, current_app);
            prepStmt.setString(4, BUSINESS_TYPE);
            prepStmt.setTimestamp(5, new Timestamp(new Date().getTime()));
            returnvalue = prepStmt.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage());
            throw e;
        }
        finally {
            try {
                if (prepStmt != null) {
                    prepStmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return returnvalue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SmsResearch> retrieveNeedSendSmsRecord(Integer amount) {
        DataSource smsDS = DataSourceClient.getInstanceByName((String)"jdbc/interfaceGWDS").getDataSource();
        Connection conn = null;
        Statement prepStmt = null;
        ResultSet rs = null;
        ArrayList<SmsResearch> result = new ArrayList<SmsResearch>();
        try {
            conn = smsDS.getConnection();
            StringBuilder sql = new StringBuilder("select a.id,a.mobile_number,b.value from prl_smsgw_sms_research a,prl_smsgw_sms_model b where a.sms_model=b.key and b.sms_type='MYD' ");
            sql.append("and a.sms_status=? ");
            if (Beans.isNotEmpty((Object)amount) && amount > 0) {
                sql.append(" and rownum<=?");
            }
            prepStmt = conn.prepareStatement(sql.toString());
            prepStmt.setString(1, Constants.SmsResearStatus.unsend.value);
            if (Beans.isNotEmpty((Object)amount) && amount > 0) {
                prepStmt.setInt(2, amount);
            }
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                SmsResearch sms = new SmsResearch();
                sms.setId(rs.getInt(1));
                sms.setMobile_number(rs.getString(2));
                sms.setSend_content(rs.getString(3));
                result.add(sms);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (prepStmt != null) {
                    prepStmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    private Integer updateResearchSmsStatus(SmsResearch sms) throws Exception {
        Integer returnvalue = null;
        DataSource smsDS = DataSourceClient.getInstanceByName((String)"jdbc/interfaceGWDS").getDataSource();
        Connection conn = null;
        Statement prepStmt = null;
        try {
            conn = smsDS.getConnection();
            String sql = "update prl_smsgw_sms_research a set a.sms_status=?,a.sms_sendtime=? where a.id=?";
            prepStmt = conn.prepareStatement(sql);
            prepStmt.setString(1, sms.getSms_status());
            prepStmt.setTimestamp(2, new Timestamp(sms.getSms_sendtime().getTime()));
            prepStmt.setInt(3, sms.getId());
            returnvalue = prepStmt.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage());
            throw e;
        }
        finally {
            try {
                if (prepStmt != null) {
                    prepStmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return returnvalue;
    }

    public Integer saveResearchSms(SmsResearch sms) throws Exception {
        Integer returnvalue = null;
        DataSource smsDS = DataSourceClient.getInstanceByName((String)"jdbc/interfaceGWDS").getDataSource();
        Connection conn = null;
        Statement prepStmt = null;
        try {
            conn = smsDS.getConnection();
            long endtime = System.currentTimeMillis();
            String sql = "insert into prl_smsgw_sms_research (ID, BUSINESS_TIME, SERVICE_STAFF, MOBILE_NUMBER, CUSTOMER_NAME, CALL_TIME, CALL_SUMMARY, PRODUCT_TYPE, CUSTOMER_REGION, SMS_STATUS, CUSTOMER_FEEDBACK,FEEDBACK_TIMe, VALUE1, VALUE2,sms_model,sms_sendtime) values (prl_smsgw_sms_research_seq.nextval, ?, ?, ?, ?, ?, ?, ?, ?, ?, null,null, null, null,?,null)";
            prepStmt = conn.prepareStatement(sql);
            if (Beans.isNotEmpty((Object)sms.getBusiness_time())) {
                prepStmt.setTimestamp(1, new Timestamp(sms.getBusiness_time().getTime()));
            } else {
                prepStmt.setTimestamp(1, null);
            }
            prepStmt.setString(2, sms.getService_staff());
            prepStmt.setString(3, sms.getMobile_number());
            prepStmt.setString(4, sms.getCustomer_name());
            if (Beans.isNotEmpty((Object)sms.getCall_time())) {
                prepStmt.setTimestamp(5, new Timestamp(sms.getCall_time().getTime()));
            } else {
                prepStmt.setTimestamp(5, null);
            }
            prepStmt.setString(6, sms.getCall_summary());
            prepStmt.setString(7, sms.getProduct_type());
            prepStmt.setString(8, sms.getCustomer_region());
            prepStmt.setString(9, Constants.SmsResearStatus.unsend.value);
            prepStmt.setString(10, (String)Constants.smsModelMap.get(sms.getProduct_type()));
            returnvalue = prepStmt.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage());
            throw e;
        }
        finally {
            try {
                if (prepStmt != null) {
                    prepStmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return returnvalue;
    }

    public void interrupt() {
        this.isInterrupt = true;
    }

    public boolean scanDirAndSave(File dir) {
        String todayStr = this.getDateString();
        try {
            if (dir.isDirectory()) {
                for (File f : dir.listFiles()) {
                    if (!todayStr.equals(f.getName()) || !f.isDirectory()) continue;
                    for (File excel : f.listFiles()) {
                        if (!excel.getName().endsWith("xls") && !excel.getName().endsWith("xlsx") || excel.getName().contains(tag_success) || excel.getName().contains(tag_failure)) continue;
                        this.readExcel(excel);
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error((Object)ex.getMessage());
            return false;
        }
        return true;
    }

    public String getDateString() {
        String returnvalue = null;
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        returnvalue = day < 10 ? String.valueOf(year) + String.valueOf(month) + "0" + String.valueOf(day) : String.valueOf(year) + String.valueOf(month) + String.valueOf(day);
        return returnvalue;
    }

    private void readExcel(File excel) throws Exception {
        logger.info((Object)"SmsMYDResearchSendJob readExcel------------");
        SmsResearchExcelReader r = new SmsResearchExcelReader(excel);
        r.readExcel();
        r.close();
        if (Beans.isEmpty((Object)r.getErrorMsg().toString())) {
            List<SmsResearch> smsList = r.getSmsList();
            for (SmsResearch sms : smsList) {
                this.saveResearchSms(sms);
            }
        } else {
            logger.error((Object)r.getErrorMsg().toString());
            String newFileName = this.renameFile(excel, tag_failure);
            File errorFile = new File(newFileName + ".log");
            BufferedWriter writer = new BufferedWriter(new FileWriter(errorFile));
            writer.write(r.getErrorMsg().toString());
            writer.flush();
            writer.close();
            throw new Exception(r.getErrorMsg().toString());
        }
        this.renameFile(excel, tag_success);
    }

    private String renameFile(File file, String tag) {
        String filepath = file.getPath();
        String s1 = filepath.substring(0, filepath.indexOf("."));
        String s2 = filepath.substring(filepath.indexOf("."));
        String newFilePath = s1 + tag + s2;
        File newFile = new File(newFilePath);
        boolean flag = true;
        try {
            logger.info((Object)("\u6587\u4ef6\u91cd\u547d\u540d\u4e3a " + newFilePath));
            flag = file.renameTo(newFile);
            logger.info((Object)("\u6587\u4ef6\u91cd\u547d\u540d \u6210\u529f?" + flag));
            if (!flag) {
                this.renameFile(file, "0" + tag);
            }
        }
        catch (Exception e) {
            file.delete();
            logger.error((Object)e.getMessage());
        }
        return s1 + tag;
    }

    public static void main(String[] args) {
        String filepath = "D:\\temp\\interfacegw\\smsMail\\smsResearch\\20151020\\E607B020.xlsx";
        File file = new File(filepath);
        String s1 = filepath.substring(0, filepath.indexOf("."));
        String s2 = filepath.substring(filepath.indexOf("."));
        String newFilePath = s1 + "_test" + s2;
        File newfile = new File(newFilePath);
        try {
            System.out.println("\u6587\u4ef6 \u5b58\u5728?" + file.exists());
            System.out.println("\u91cd\u547d\u540d\u6587\u4ef6 \u5b58\u5728?" + newfile.exists());
            boolean flag = file.renameTo(newfile);
            System.out.println("\u6587\u4ef6\u91cd\u547d\u540d \u6210\u529f?" + flag);
            if (!flag) {
                try {
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                    FileWriter fileWriter = new FileWriter(file);
                    fileWriter.write("");
                    fileWriter.flush();
                    fileWriter.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

