/*
 * Decompiled with CFR 0.152.
 */
package com.allianz.cn.pc.services.sms.jobs;

import com.allianz.cn.pc.services.sms.SMSFactory;
import com.allianz.cn.pc.services.sms.SMSService;
import com.allianz.cn.pc.services.sms.beans.SmsReceive;
import com.allianz.cn.pc.utils.Beans;
import com.allianz.cn.pc.utils.DataSourceClient;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.InterruptableJob;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;

@DisallowConcurrentExecution
public class SmsReceiveJob
implements InterruptableJob {
    private static Logger logger = Logger.getLogger(SmsReceiveJob.class);
    private boolean isInterrupt = false;

    public void execute(JobExecutionContext jobExecutionContext) {
        logger.debug((Object)"start to receive sms!");
        try {
            JobDataMap dataMap = jobExecutionContext.getJobDetail().getJobDataMap();
            String appName = dataMap.getString("JOB_CONTENT_GROUP");
            SMSService smsService = SMSFactory.getSMSInstance(appName);
            List<SmsReceive> smsList = smsService.receiveSMS();
            logger.debug((Object)("saving received sms to prl_smsgw_sms_receive, size is " + smsList.size()));
            for (SmsReceive sms : smsList) {
                this.saveReceiveSms(sms);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            e.printStackTrace();
        }
        logger.debug((Object)"end to receive sms!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer saveReceiveSms(SmsReceive sms) {
        Integer returnvalue = null;
        DataSource smsDS = DataSourceClient.getInstanceByName((String)"jdbc/interfaceGWDS").getDataSource();
        Connection conn = null;
        Statement prepStmt = null;
        try {
            conn = smsDS.getConnection();
            String sql = "insert into prl_smsgw_sms_receive (ID, CHANNEL_NUMBER, MOBILE_NUMBER, SMS_CONTENT, RECEIVE_TIME, BUSINESS_TYPE,sms_provider, VALUE1, VALUE2) values (prl_smsgw_sms_receive_seq.nextval, ?, ?, ?, ?, ?, ?,null, null)";
            prepStmt = conn.prepareStatement(sql);
            prepStmt.setString(1, sms.getChannelNumber());
            prepStmt.setString(2, sms.getMobileNumber());
            prepStmt.setString(3, sms.getSmsContent());
            if (Beans.isNotEmpty((Object)sms.getReceiveTime())) {
                prepStmt.setTimestamp(4, new Timestamp(sms.getReceiveTime().getTime()));
            } else {
                prepStmt.setTimestamp(4, new Timestamp(new Date().getTime()));
            }
            prepStmt.setString(5, sms.getBusinessType());
            prepStmt.setString(6, sms.getSmsProvider());
            returnvalue = prepStmt.executeUpdate();
        }
        catch (Exception e) {
            logger.error((Object)("saveReceiveSms error: " + e));
        }
        finally {
            try {
                if (prepStmt != null) {
                    prepStmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return returnvalue;
    }

    public void interrupt() {
        this.isInterrupt = true;
    }
}

