/*
 * Decompiled with CFR 0.152.
 */
package com.allianz.cn.pc.services.sms.utils;

import com.allianz.cn.pc.utils.Beans;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Dates {
    private static String defaultDateFormatParthen = "yyyyMMddHHmmssSSS";
    private static ThreadLocal<DateFormat> defaultDateFormatTL = new ThreadLocal();
    public static final int HOUR = 10;
    public static final int DAY = 11;
    public static final int MINUTE = 12;
    public static final int SECOND = 13;
    public static final int MILLISECOND = 14;
    private static ThreadLocal<Map<String, DateFormat>> dateFormatsTL = new ThreadLocal();

    public static Date getBeginOfDay(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date getEndOfDay(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        c.set(14, 999);
        return c.getTime();
    }

    public static Date toDate(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Date) {
            return new Date(((Date)o).getTime());
        }
        String s = o.toString();
        if ((s = s.replaceAll("\\D", "")).length() < 8) {
            return null;
        }
        if (s.length() < defaultDateFormatParthen.length()) {
            StringBuilder sb = new StringBuilder(defaultDateFormatParthen.length());
            sb.append(s);
            while (sb.length() < defaultDateFormatParthen.length()) {
                sb.append('0');
            }
            s = sb.toString();
        } else {
            s = s.substring(0, defaultDateFormatParthen.length());
        }
        try {
            DateFormat defaultDateFormat = defaultDateFormatTL.get();
            if (defaultDateFormat == null) {
                defaultDateFormat = new SimpleDateFormat(defaultDateFormatParthen);
                defaultDateFormatTL.set(defaultDateFormat);
            }
            return defaultDateFormat.parse(s);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toString(Date date, String format) {
        return Dates.retrieveDateFormat(format).format(date);
    }

    public static DateFormat retrieveDateFormat(String format) {
        DateFormat dateFormat;
        Map<String, DateFormat> dateFormats = dateFormatsTL.get();
        if (dateFormats == null) {
            dateFormats = new HashMap<String, DateFormat>();
            dateFormatsTL.set(dateFormats);
        }
        if ((dateFormat = dateFormats.get(format = format.trim())) == null) {
            dateFormat = new SimpleDateFormat(format);
            dateFormats.put(format, dateFormat);
        }
        return dateFormat;
    }

    public static boolean validateDate(String date, String pattren) {
        DateFormat dateFormat = Dates.retrieveDateFormat(pattren);
        try {
            dateFormat.parse(date);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static Date getDateTimeBefore(Date date, int type, int value) {
        long time = date.getTime() / 1000L;
        switch (type) {
            case 11: {
                time -= (long)(86400 * value);
                break;
            }
            case 10: {
                time -= (long)(3600 * value);
                break;
            }
            case 12: {
                time -= (long)(60 * value);
                break;
            }
            case 13: {
                time -= (long)value;
                break;
            }
        }
        return new Date(time * 1000L);
    }

    public static Date getDateTimeAfter(Date date, int type, long value) {
        long nextTime = date.getTime() / 1000L;
        switch (type) {
            case 11: {
                nextTime += 86400L * value;
                break;
            }
            case 10: {
                nextTime += 3600L * value;
                break;
            }
            case 12: {
                nextTime += 60L * value;
                break;
            }
            case 13: {
                nextTime += value;
                break;
            }
        }
        return new Date(nextTime * 1000L);
    }

    public static Long compareCurrentTime(Date start) {
        if (Beans.isEmpty((Object)start)) {
            return null;
        }
        return new Date().getTime() - start.getTime();
    }
}

