/*
 * Decompiled with CFR 0.152.
 */
package com.allianz.cn.pc.services.sms.utils;

import com.allianz.cn.pc.utils.Beans;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.jbo.ValidationException;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;

public class Excels {
    private POIFSFileSystem fs;
    private HSSFWorkbook wb;
    private HSSFSheet sheet;
    private HSSFRow row;
    private static Logger logger = Logger.getLogger(Excels.class);

    public String[] readExcelTitle(InputStream is) {
        try {
            this.fs = new POIFSFileSystem(is);
            this.wb = new HSSFWorkbook(this.fs);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.sheet = this.wb.getSheetAt(0);
        this.row = this.sheet.getRow(0);
        int colNum = this.row.getPhysicalNumberOfCells();
        String[] title = new String[colNum];
        for (int i = 0; i < colNum; ++i) {
            title[i] = Excels.getStringCellValue((Cell)this.row.getCell(i));
        }
        return title;
    }

    public ArrayList<HashMap<String, Object>> getResultFromExcel(InputStream is, String[] headerNames) {
        ArrayList<HashMap<String, Object>> result = new ArrayList<HashMap<String, Object>>();
        StringBuffer errorMsg = new StringBuffer();
        try {
            this.fs = new POIFSFileSystem(is);
            this.wb = new HSSFWorkbook(this.fs);
        }
        catch (Exception e) {
            logger.error((Object)("read inputstream exception:" + e.getMessage()));
            throw new ValidationException("read inputstream exception:" + e.getMessage());
        }
        this.sheet = this.wb.getSheetAt(0);
        int rowNum = this.sheet.getLastRowNum();
        this.row = this.sheet.getRow(0);
        int colNum = this.row.getPhysicalNumberOfCells();
        for (int i = 1; i <= rowNum; ++i) {
            try {
                this.row = this.sheet.getRow(i);
                HashMap<String, String> rowContent = new HashMap<String, String>();
                for (int j = 0; j < colNum; ++j) {
                    HSSFCell cell = this.row.getCell(j);
                    Object val = Excels.getStringCellValue((Cell)cell).trim();
                    if (Beans.isNotEmpty((Object)cell) && cell.getCellType() == 0 && HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                        double d = cell.getNumericCellValue();
                        val = HSSFDateUtil.getJavaDate((double)d);
                    }
                    rowContent.put(headerNames[j], (String)val);
                }
                result.add(rowContent);
                continue;
            }
            catch (Exception uoe) {
                errorMsg.append(i + " \u884c\u51fa\u73b0\u5f02\u5e38:" + uoe.getMessage());
            }
        }
        if (Beans.isNotEmpty((Object)errorMsg.toString())) {
            throw new ValidationException(errorMsg.toString());
        }
        return result;
    }

    public static String getStringCellValue(Cell cell) {
        String strCell = "";
        if (cell == null) {
            return "";
        }
        switch (cell.getCellType()) {
            case 1: {
                strCell = cell.getStringCellValue();
                break;
            }
            case 0: {
                DecimalFormat df = new DecimalFormat("#");
                strCell = df.format(cell.getNumericCellValue());
                break;
            }
            case 4: {
                strCell = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case 3: {
                strCell = "";
                break;
            }
            default: {
                strCell = "";
            }
        }
        if (strCell == null || strCell.equals("")) {
            return "";
        }
        return strCell;
    }
}

