/*
 * Decompiled with CFR 0.152.
 */
package com.allianz.cn.pc.services.sms.utils;

import com.allianz.cn.pc.services.sms.beans.SmsResearch;
import com.allianz.cn.pc.utils.Beans;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellRangeAddress;

public class SmsResearchExcelCreater {
    private HSSFWorkbook workbook = new HSSFWorkbook();
    private HSSFSheet sheet = this.workbook.createSheet();
    private HSSFCellStyle headstyle = this.workbook.createCellStyle();
    private HSSFCellStyle centerstyle = this.workbook.createCellStyle();

    public SmsResearchExcelCreater(List<SmsResearch> smsResearchList) {
        int colnum = 10;
        int headnum = 2;
        this.initWorkbookStyle(colnum);
        this.createHeader();
        this.loadData(smsResearchList, headnum);
    }

    private void loadData(List<SmsResearch> smsResearchList, int headnum) {
        SimpleDateFormat timeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (int i = 0; i < smsResearchList.size(); ++i) {
            SmsResearch data = smsResearchList.get(i);
            HSSFRow row = this.sheet.getRow(i + headnum);
            if (null == row) {
                row = this.sheet.createRow(i + headnum);
            }
            HSSFCell cell = row.createCell(0);
            if (Beans.isEmpty((Object)data.getBusiness_time())) {
                cell.setCellValue("");
            } else {
                cell.setCellValue(timeFormat.format(data.getBusiness_time()));
            }
            cell.setCellStyle(this.centerstyle);
            cell = row.createCell(1);
            cell.setCellValue((RichTextString)new HSSFRichTextString(data.getService_staff()));
            cell.setCellStyle(this.centerstyle);
            cell = row.createCell(2);
            cell.setCellValue((RichTextString)new HSSFRichTextString(data.getMobile_number()));
            cell.setCellStyle(this.centerstyle);
            cell = row.createCell(3);
            cell.setCellValue((RichTextString)new HSSFRichTextString(data.getCustomer_name()));
            cell.setCellStyle(this.centerstyle);
            cell = row.createCell(4);
            if (Beans.isEmpty((Object)data.getCall_time())) {
                cell.setCellValue("");
            } else {
                cell.setCellValue(timeFormat.format(data.getCall_time()));
            }
            cell.setCellStyle(this.centerstyle);
            cell = row.createCell(5);
            cell.setCellValue((RichTextString)new HSSFRichTextString(data.getCall_summary()));
            cell.setCellStyle(this.centerstyle);
            cell = row.createCell(6);
            cell.setCellValue((RichTextString)new HSSFRichTextString(data.getProduct_type()));
            cell.setCellStyle(this.centerstyle);
            cell = row.createCell(7);
            cell.setCellValue((RichTextString)new HSSFRichTextString(data.getCustomer_region()));
            cell.setCellStyle(this.centerstyle);
            cell = row.createCell(8);
            cell.setCellValue((RichTextString)new HSSFRichTextString(data.getSms_status()));
            cell.setCellStyle(this.centerstyle);
            cell = row.createCell(9);
            cell.setCellValue((RichTextString)new HSSFRichTextString(data.getCustomer_feedback()));
            cell.setCellStyle(this.centerstyle);
        }
    }

    private void initWorkbookStyle(int colnum) {
        this.sheet.createFreezePane(1, 2);
        for (int i = 0; i < colnum; ++i) {
            this.sheet.setColumnWidth(i, 4000);
        }
        HSSFFont headfont = this.workbook.createFont();
        headfont.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
        headfont.setFontHeightInPoints((short)11);
        headfont.setBoldweight((short)700);
        this.headstyle.setFont(headfont);
        this.headstyle.setAlignment((short)2);
        this.headstyle.setVerticalAlignment((short)1);
        this.headstyle.setLocked(true);
        this.headstyle.setWrapText(true);
        HSSFFont font = this.workbook.createFont();
        font.setFontName("\u5b8b\u4f53");
        font.setFontHeightInPoints((short)10);
        this.centerstyle.setFont(font);
        this.centerstyle.setAlignment((short)2);
        this.centerstyle.setVerticalAlignment((short)1);
        this.centerstyle.setWrapText(true);
        this.centerstyle.setLeftBorderColor((short)8);
        this.centerstyle.setBorderLeft((short)1);
        this.centerstyle.setRightBorderColor((short)8);
        this.centerstyle.setBorderRight((short)1);
        this.centerstyle.setBorderBottom((short)1);
        this.centerstyle.setBottomBorderColor((short)8);
        this.centerstyle.setFillForegroundColor((short)9);
    }

    private void createHeader() {
        HSSFRow row0 = this.sheet.createRow(0);
        HSSFRow row1 = this.sheet.createRow(1);
        row0.setHeight((short)300);
        row1.setHeight((short)300);
        HSSFCell cell00 = row0.createCell(0);
        cell00.setCellValue((RichTextString)new HSSFRichTextString("\u4e1a\u52a1\u65f6\u95f4"));
        cell00.setCellStyle(this.headstyle);
        CellRangeAddress range = new CellRangeAddress(0, 1, 0, 0);
        this.sheet.addMergedRegion(range);
        HSSFCell cell01 = row0.createCell(1);
        cell01.setCellValue((RichTextString)new HSSFRichTextString("\u5ba2\u670d\u4eba\u5458"));
        cell01.setCellStyle(this.headstyle);
        range = new CellRangeAddress(0, 1, 1, 1);
        this.sheet.addMergedRegion(range);
        HSSFCell cell02 = row0.createCell(2);
        cell02.setCellValue((RichTextString)new HSSFRichTextString("\u5ba2\u6237\u4fe1\u606f"));
        cell02.setCellStyle(this.headstyle);
        range = new CellRangeAddress(0, 0, 2, 7);
        this.sheet.addMergedRegion(range);
        HSSFCell cell08 = row0.createCell(8);
        cell08.setCellValue((RichTextString)new HSSFRichTextString("\u8c03\u67e5\u7ed3\u679c"));
        cell08.setCellStyle(this.headstyle);
        range = new CellRangeAddress(0, 0, 8, 9);
        this.sheet.addMergedRegion(range);
        HSSFCell cell12 = row1.createCell(2);
        cell12.setCellValue((RichTextString)new HSSFRichTextString("\u53d1\u9001\u624b\u673a\u53f7\u7801"));
        cell12.setCellStyle(this.headstyle);
        HSSFCell cell13 = row1.createCell(3);
        cell13.setCellValue((RichTextString)new HSSFRichTextString("\u5ba2\u6237\u59d3\u540d"));
        cell13.setCellStyle(this.headstyle);
        HSSFCell cell14 = row1.createCell(4);
        cell14.setCellValue((RichTextString)new HSSFRichTextString("\u6765\u7535\u65f6\u95f4"));
        cell14.setCellStyle(this.headstyle);
        HSSFCell cell15 = row1.createCell(5);
        cell15.setCellValue((RichTextString)new HSSFRichTextString("\u6765\u7535\u7b80\u8ff0"));
        cell15.setCellStyle(this.headstyle);
        HSSFCell cell16 = row1.createCell(6);
        cell16.setCellValue((RichTextString)new HSSFRichTextString("\u4ea7\u54c1\u7c7b\u522b"));
        cell16.setCellStyle(this.headstyle);
        HSSFCell cell17 = row1.createCell(7);
        cell17.setCellValue((RichTextString)new HSSFRichTextString("\u5ba2\u6237\u6240\u5c5e\u5730\u533a"));
        cell17.setCellStyle(this.headstyle);
        HSSFCell cell18 = row1.createCell(8);
        cell18.setCellValue((RichTextString)new HSSFRichTextString("\u53d1\u9001\u6807\u8bc6"));
        cell18.setCellStyle(this.headstyle);
        HSSFCell cell19 = row1.createCell(9);
        cell19.setCellValue((RichTextString)new HSSFRichTextString("\u5ba2\u6237\u8bc4\u5206"));
        cell19.setCellStyle(this.headstyle);
    }

    public byte[] getExcelByte() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.workbook.write((OutputStream)os);
        return os.toByteArray();
    }

    public static void main(String[] args) {
        ArrayList<SmsResearch> smsResearchList = new ArrayList<SmsResearch>();
        SmsResearch sms = new SmsResearch();
        sms.setBusiness_time(new Date());
        sms.setService_staff("\u963f\u4e09");
        sms.setMobile_number("15920135190");
        sms.setCustomer_name("\u5c0f\u660e");
        sms.setCall_time(new Date());
        sms.setCall_summary("\u6295\u8bc9");
        sms.setProduct_type("\u8f66\u9669");
        sms.setCustomer_region("\u5e7f\u4e1c");
        sms.setSms_status("\u5df2\u53d1\u9001\u5df2\u56de\u590d");
        sms.setCustomer_feedback("5");
        smsResearchList.add(sms);
        SmsResearchExcelCreater r = new SmsResearchExcelCreater(smsResearchList);
        String outdir = "D:\\temp\\interfacegw\\smsMail\\smsResearchResult";
        try {
            FileOutputStream out = new FileOutputStream(outdir + "\\test.xls");
            out.write(r.getExcelByte());
            out.flush();
            out.close();
            System.out.println("\u5bfc\u51faexcel\u6210\u529f");
            System.out.println(outdir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

