/*
 * Decompiled with CFR 0.152.
 */
package com.allianz.cn.pc.services.sms.utils;

import com.allianz.cn.pc.services.sms.beans.SmsResearch;
import com.allianz.cn.pc.services.sms.utils.Dates;
import com.allianz.cn.pc.services.sms.utils.Excels;
import com.allianz.cn.pc.utils.Beans;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class SmsResearchExcelReader {
    private static Logger logger = Logger.getLogger(SmsResearchExcelReader.class);
    private File excelFile;
    private int rowNum = 0;
    private int colNum;
    private StringBuilder errorMsg = new StringBuilder();
    private List<SmsResearch> smsList = new ArrayList<SmsResearch>();
    private InputStream is = null;
    private Workbook book = null;

    public SmsResearchExcelReader(File file) {
        this.excelFile = file;
    }

    private SmsResearchExcelReader() {
    }

    public void close() {
        if (null != this.is) {
            try {
                this.is.close();
            }
            catch (IOException ioe) {
                logger.error((Object)ioe.getMessage());
            }
        }
        if (null != this.book) {
            try {
                this.book.close();
            }
            catch (IOException ioe) {
                logger.error((Object)ioe.getMessage());
            }
        }
    }

    public void readExcel() {
        try {
            this.is = new FileInputStream(this.excelFile);
            POIFSFileSystem fs = new POIFSFileSystem(this.is);
            this.book = new HSSFWorkbook(fs);
            Sheet sheet = this.book.getSheetAt(0);
            this.readSheet(sheet);
        }
        catch (Exception e) {
            try {
                this.book = new XSSFWorkbook(this.excelFile);
                Sheet sheet = this.book.getSheetAt(0);
                this.readSheet(sheet);
            }
            catch (Exception f) {
                this.errorMsg.append(f.getMessage());
                f.printStackTrace();
                logger.info((Object)("read inputstream exception:" + f.getMessage()));
            }
        }
    }

    public void readSheet(Sheet sheet) {
        this.rowNum = sheet.getLastRowNum() + 1;
        Row row = sheet.getRow(0);
        this.colNum = row.getPhysicalNumberOfCells();
        logger.info((Object)("\u5f00\u59cb\u8bfbexcel " + this.excelFile.getPath()));
        logger.info((Object)(this.excelFile.getName() + " \u884c\u6570:" + this.rowNum));
        logger.info((Object)(this.excelFile.getName() + " \u5217\u6570:" + this.colNum));
        for (int i = 2; i < this.rowNum; ++i) {
            row = sheet.getRow(i);
            SmsResearch t = this.readRow(row);
            if (Beans.isEmpty((Object)t.getMobile_number()) || Beans.isEmpty((Object)t.getProduct_type()) || Beans.isEmpty((Object)t.getCustomer_region())) {
                if (this.isEmptyObject(t)) continue;
                this.errorMsg.append(this.excelFile.getName() + " \u8bfb\u53d6\u6587\u4ef6\u7b2c" + i + "\u884c\uff0c\u5fc5\u586b\u4fe1\u606f\u4e3a\u7a7a;\n");
                continue;
            }
            this.smsList.add(t);
        }
        logger.info((Object)("\u7ed3\u675f\u8bfbexcel " + this.excelFile.getName()));
    }

    private boolean isEmptyObject(SmsResearch model) {
        boolean returnvalue = true;
        Field[] field = model.getClass().getDeclaredFields();
        for (int i = 0; i < field.length; ++i) {
            String name = field[i].getName();
            name = name.substring(0, 1).toUpperCase() + name.substring(1);
            try {
                Method m = model.getClass().getMethod("get" + name, new Class[0]);
                Object value = m.invoke((Object)model, new Object[0]);
                if (Beans.isEmpty((Object)value)) continue;
                returnvalue = false;
                break;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
        }
        return returnvalue;
    }

    private SmsResearch readRow(Row row) {
        SimpleDateFormat timeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SmsResearch t = new SmsResearch();
        block12: for (int j = 0; j < this.colNum; ++j) {
            Cell cell = row.getCell(j);
            Object value = Excels.getStringCellValue(cell).trim();
            if (Beans.isNotEmpty((Object)cell) && cell.getCellType() == 0 && HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                double d = cell.getNumericCellValue();
                value = HSSFDateUtil.getJavaDate((double)d);
            }
            switch (j) {
                case 0: {
                    t.setBusiness_time(Dates.toDate(value));
                    continue block12;
                }
                case 1: {
                    t.setService_staff(value + "");
                    continue block12;
                }
                case 2: {
                    t.setMobile_number(value + "");
                    continue block12;
                }
                case 3: {
                    t.setCustomer_name(value + "");
                    continue block12;
                }
                case 4: {
                    t.setCall_time(Dates.toDate(value));
                    continue block12;
                }
                case 5: {
                    t.setCall_summary(value + "");
                    continue block12;
                }
                case 6: {
                    t.setProduct_type(value + "");
                    continue block12;
                }
                case 7: {
                    t.setCustomer_region(value + "");
                    continue block12;
                }
                case 8: {
                    t.setSms_status(value + "");
                    continue block12;
                }
                case 9: {
                    t.setCustomer_feedback(value + "");
                    continue block12;
                }
            }
        }
        return t;
    }

    public void setRowNum(int rowNum) {
        this.rowNum = rowNum;
    }

    public int getRowNum() {
        return this.rowNum;
    }

    public void setColNum(int colNum) {
        this.colNum = colNum;
    }

    public int getColNum() {
        return this.colNum;
    }

    public void setSmsList(List<SmsResearch> smsList) {
        this.smsList = smsList;
    }

    public List<SmsResearch> getSmsList() {
        return this.smsList;
    }

    public void setExcelFile(File excelFile) {
        this.excelFile = excelFile;
    }

    public File getExcelFile() {
        return this.excelFile;
    }

    public void setErrorMsg(StringBuilder errorMsg) {
        this.errorMsg = errorMsg;
    }

    public StringBuilder getErrorMsg() {
        return this.errorMsg;
    }
}

