/*
 * Decompiled with CFR 0.152.
 */
package com.allinpay.ets.client.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class Base64 {
    private static final int LOWER_CASE_A_VALUE = 26;
    private static final int ZERO_VALUE = 52;
    private static final int PLUS_VALUE = 62;
    private static final int SLASH_VALUE = 63;
    private static final int SIX_BIT_MASK = 63;
    private static final int EIGHT_BIT_MASK = 255;
    private String mString;
    private int mIndex = 0;

    public static String encode(byte[] data) {
        return new Base64().internalEncode(data);
    }

    public String internalEncode(byte[] data) {
        int charCount = data.length * 4 / 3 + 4;
        StringBuffer result = new StringBuffer(charCount * 77 / 76);
        int byteArrayLength = data.length;
        int byteArrayIndex = 0;
        int byteTriplet = 0;
        while (byteArrayIndex < byteArrayLength - 2) {
            byteTriplet = this.convertUnsignedByteToInt(data[byteArrayIndex++]);
            byteTriplet <<= 8;
            byteTriplet |= this.convertUnsignedByteToInt(data[byteArrayIndex++]);
            byteTriplet <<= 8;
            byte b4 = (byte)(0x3F & (byteTriplet |= this.convertUnsignedByteToInt(data[byteArrayIndex++])));
            byte b3 = (byte)(0x3F & (byteTriplet >>= 6));
            byte b2 = (byte)(0x3F & (byteTriplet >>= 6));
            byte b1 = (byte)(0x3F & (byteTriplet >>= 6));
            result.append(this.mapByteToChar(b1));
            result.append(this.mapByteToChar(b2));
            result.append(this.mapByteToChar(b3));
            result.append(this.mapByteToChar(b4));
        }
        if (byteArrayIndex == byteArrayLength - 1) {
            byteTriplet = this.convertUnsignedByteToInt(data[byteArrayIndex++]);
            byte b2 = (byte)(0x3F & (byteTriplet <<= 4));
            byte b1 = (byte)(0x3F & (byteTriplet >>= 6));
            result.append(this.mapByteToChar(b1));
            result.append(this.mapByteToChar(b2));
            result.append("==");
        }
        if (byteArrayIndex == byteArrayLength - 2) {
            byteTriplet = this.convertUnsignedByteToInt(data[byteArrayIndex++]);
            byteTriplet <<= 8;
            byteTriplet |= this.convertUnsignedByteToInt(data[byteArrayIndex++]);
            byte b3 = (byte)(0x3F & (byteTriplet <<= 2));
            byte b2 = (byte)(0x3F & (byteTriplet >>= 6));
            byte b1 = (byte)(0x3F & (byteTriplet >>= 6));
            result.append(this.mapByteToChar(b1));
            result.append(this.mapByteToChar(b2));
            result.append(this.mapByteToChar(b3));
            result.append("=");
        }
        return result.toString();
    }

    public static byte[] decode(String data) {
        return new Base64().internalDecode(data);
    }

    public byte[] internalDecode(String data) {
        this.mString = data;
        this.mIndex = 0;
        int mUsefulLength = 0;
        int length = this.mString.length();
        for (int i = 0; i < length; ++i) {
            if (!this.isUsefulChar(this.mString.charAt(i))) continue;
            ++mUsefulLength;
        }
        int byteArrayLength = mUsefulLength * 3 / 4;
        byte[] result = new byte[byteArrayLength];
        int byteTriplet = 0;
        int byteIndex = 0;
        while (byteIndex + 2 < byteArrayLength) {
            byteTriplet = this.mapCharToInt(this.getNextUsefulChar());
            byteTriplet <<= 6;
            byteTriplet |= this.mapCharToInt(this.getNextUsefulChar());
            byteTriplet <<= 6;
            byteTriplet |= this.mapCharToInt(this.getNextUsefulChar());
            byteTriplet <<= 6;
            result[byteIndex + 2] = (byte)((byteTriplet |= this.mapCharToInt(this.getNextUsefulChar())) & 0xFF);
            result[byteIndex + 1] = (byte)((byteTriplet >>= 8) & 0xFF);
            result[byteIndex] = (byte)((byteTriplet >>= 8) & 0xFF);
            byteIndex += 3;
        }
        if (byteIndex == byteArrayLength - 1) {
            byteTriplet = this.mapCharToInt(this.getNextUsefulChar());
            byteTriplet <<= 6;
            byteTriplet |= this.mapCharToInt(this.getNextUsefulChar());
            result[byteIndex] = (byte)((byteTriplet >>= 4) & 0xFF);
        }
        if (byteIndex == byteArrayLength - 2) {
            byteTriplet = this.mapCharToInt(this.getNextUsefulChar());
            byteTriplet <<= 6;
            byteTriplet |= this.mapCharToInt(this.getNextUsefulChar());
            byteTriplet <<= 6;
            byteTriplet |= this.mapCharToInt(this.getNextUsefulChar());
            result[byteIndex + 1] = (byte)((byteTriplet >>= 2) & 0xFF);
            result[byteIndex] = (byte)((byteTriplet >>= 8) & 0xFF);
        }
        return result;
    }

    private int mapCharToInt(char c) {
        if (c >= 'A' && c <= 'Z') {
            return c - 65;
        }
        if (c >= 'a' && c <= 'z') {
            return c - 97 + 26;
        }
        if (c >= '0' && c <= '9') {
            return c - 48 + 52;
        }
        if (c == '+') {
            return 62;
        }
        if (c == '/') {
            return 63;
        }
        throw new IllegalArgumentException(c + " is not a valid Base64 character.");
    }

    private char mapByteToChar(byte b) {
        if (b < 26) {
            return (char)(65 + b);
        }
        if (b < 52) {
            return (char)(97 + (b - 26));
        }
        if (b < 62) {
            return (char)(48 + (b - 52));
        }
        if (b == 62) {
            return '+';
        }
        if (b == 63) {
            return '/';
        }
        throw new IllegalArgumentException("Byte " + new Integer(b) + " is not a valid Base64 value");
    }

    private boolean isUsefulChar(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '+' || c == '/';
    }

    private char getNextUsefulChar() {
        char result = '_';
        while (!this.isUsefulChar(result)) {
            result = this.mString.charAt(this.mIndex++);
        }
        return result;
    }

    private int convertUnsignedByteToInt(byte b) {
        if (b >= 0) {
            return b;
        }
        return 256 + b;
    }

    public static void main(String[] args) throws Exception {
        String tString = "I am \u5218\u6c38\u88d5!1";
        System.out.println("Text = [" + tString + "]");
        String tEncoded = Base64.encode(tString.getBytes());
        System.out.println("Encoded = [" + tEncoded + "]");
        byte[] tDecoded = Base64.decode(tEncoded);
        System.out.println("Decoded = [" + new String(tDecoded) + "]");
        for (int i = 0; i < 1; ++i) {
            String tTestCompressedString = "eJyFU9uOozAM/ZWK923CrdDKzYhtd6U+FFUD/YAoWFNmIbAJ3aHz9Wugt4eRJjzUPrbOObJdeOnravYPjS0bvXbcOXdmqFVTlPpt7Rzz3z9i50XA5njIUJ0NCtijtfINZ2WxdhKP84i+Jefc9XweOAJ2+SvasZp9Ub0qCRKac2C3FPru0qLgLrApgl5V0lohCZgiaKUWC8/zFtz13ZEy8mMeABsKZMuok9SdAKn+/tylghp4GAckcgWgRrPbijheDPDSX9KLPGATDLItj6YSp65r7YqxRlelxrk6lVqeNXls5WWumpolh12Ghoyz3EhtWfa6kaY4ULVoSGtiAfbwk11sh7WAzkiF6bkWfBFGQQjsDkAhOxS3ac1cf+WGq4CsjTiwG8PhPHDaYTplIfbvyUf6mfj77Z9+//nLTXP1kb4f/XR7XNPUqOMb3nagS+rmTC5jGihN8gkBWrehU7gIN1wAu2eAfdtopA4iusfAHuYsdl2Fo8agC+wJgKQoEkXkNBuNVT5uPSL6pxxQleMpDL9Qqk2jN01BfcAeCbArU2nttO7xkacrAApNR4vl3zz";
            String tResultString = Base64.getDecodeMsg(tTestCompressedString);
            System.out.println("tResultString = [" + tResultString + "]");
        }
    }

    public static String getEncodeMsg(String tMessage) {
        String returnStr = "";
        try {
            ByteArrayOutputStream byteStream = Base64.getCompressedStr(tMessage);
            if (byteStream != null) {
                returnStr = Base64.encode(byteStream.toByteArray());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return returnStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteArrayOutputStream getCompressedStr(String tMessage) {
        ByteArrayOutputStream compressedStream = null;
        try {
            if (tMessage != null && !"".equals(tMessage)) {
                int got;
                byte[] input = tMessage.getBytes("UTF-8");
                Deflater compresser = new Deflater();
                compresser.setInput(input);
                compresser.finish();
                compressedStream = new ByteArrayOutputStream();
                byte[] buf = new byte[2048];
                while (!compresser.finished() && (got = compresser.deflate(buf)) >= 1) {
                    compressedStream.write(buf, 0, got);
                }
                compresser.end();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (compressedStream != null) {
                try {
                    compressedStream.close();
                }
                catch (IOException ioex) {
                    ioex.printStackTrace();
                }
            }
        }
        return compressedStream;
    }

    public static String getDecodeMsg(String tMessage) {
        String outputString = "";
        byte[] inputStr = null;
        try {
            String newStr = tMessage;
            newStr = newStr.replaceAll(" ", "+");
            inputStr = Base64.decode(newStr);
            outputString = Base64.getDeCompressedStr(inputStr);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return outputString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDeCompressedStr(byte[] tMessage) {
        String returnStr = "";
        ByteArrayOutputStream aDeCompressedStream = null;
        try {
            int got;
            Inflater decompresser = new Inflater();
            decompresser.setInput(tMessage);
            aDeCompressedStream = new ByteArrayOutputStream();
            byte[] buf = new byte[2048];
            while (!decompresser.finished() && (got = decompresser.inflate(buf)) >= 1) {
                aDeCompressedStream.write(buf, 0, got);
            }
            decompresser.end();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (aDeCompressedStream != null) {
                    aDeCompressedStream.close();
                }
            }
            catch (IOException ioex) {
                ioex.printStackTrace();
            }
        }
        try {
            returnStr = aDeCompressedStream.toString("UTF-8");
        }
        catch (UnsupportedEncodingException encodeEx) {
            encodeEx.printStackTrace();
        }
        return returnStr;
    }
}

