/*
 * Decompiled with CFR 0.152.
 */
package com.allinpay.ets.client.web;

import com.allinpay.ets.client.PaymentResult;
import com.allinpay.ets.client.RequestOrder;
import com.allinpay.ets.client.SecurityUtil;
import com.allinpay.ets.client.StringUtil;
import com.allinpay.ets.client.TrxException;
import com.allinpay.ets.client.util.Rsa;
import java.io.UnsupportedEncodingException;
import java.security.PrivateKey;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bouncycastle.util.encoders.Base64;

public abstract class AbstractMerchantClient {
    public static final int SIGNTYPE_MD5 = 0;
    public static final int SIGNTYPE_CERT = 1;
    public static final int SIGNTYPE_SHA_1 = 2;
    public static final int INPUTCHARSET_UTF8 = 1;
    public static final int INPUTCHARSET_GBK = 2;
    public static final int INPUTCHARSET_GB2312 = 3;
    public static final String VERSION_PAYMENT_V1 = "v1.0";
    public static final String VERSION_PAYMENT_V2 = "v2.0";
    public static final String VERSION_REFUND_V13 = "v1.3";
    public static final String VERSION_REFUND_V23 = "v2.3";
    public static final String VERSION_QUERY_V15 = "v1.5";
    public static final String VERSION_BATCHQUERY_V17 = "v1.7";
    public static final String VERSION_REALNAME_VERIFY_V5 = "v5.0";
    public static final String VERSION_REALNAME_PAYMENT_V51 = "v5.1";
    public static final String VERSION_REALNAME_VANDPAYMENT_V55 = "v5.5";
    public static final int PAYTYPE_ALL = 0;
    public static final int PAYTYPE_EBankPay = 1;
    public static final int PAYTYPE_PrepaidCardPay = 2;
    public static final int PAYTYPE_TelephonePay = 3;
    public static final int PAYTYPE_EBankB2BPay = 4;
    public static final int PAYTYPE_RealNamePay = 5;
    private static Pattern orderAmountPattern = Pattern.compile("\\d{1,16}");
    private static Pattern orderIdPattern = Pattern.compile("[\\w,_,-]{1,50}");
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    String currentDate = this.sdf.format(new Date());

    public abstract String sign(RequestOrder var1) throws TrxException;

    public abstract boolean verify(PaymentResult var1) throws TrxException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String generateSignMsg(RequestOrder requestOrder) throws TrxException {
        StringBuffer st = new StringBuffer();
        String signMsg = "";
        try {
            st.append("=== Signature start, env: java jdk1.5, date:" + this.currentDate + " ===\n");
            this.checkSignParams(requestOrder);
            String signSrc = this.generateSignSrc(requestOrder);
            st.append("[signSrc]").append(signSrc).append(" \n");
            switch (requestOrder.getSignType()) {
                case 0: {
                    signMsg = this.generateSignMsgOfMD5(signSrc);
                    break;
                }
                case 1: {
                    signMsg = this.generateSignMsgOfCert(signSrc);
                    break;
                }
            }
            st.append("[signMsg]").append(signMsg).append(" \n");
            st.append("=== Signature end, env: java jdk1.5, date:" + this.currentDate + " ===\n");
        }
        finally {
            System.out.println(st.toString());
        }
        return signMsg;
    }

    public String generateSignSrc(RequestOrder requestOrder) {
        String signSrc = null;
        if (VERSION_PAYMENT_V1.equals(requestOrder.getVersion())) {
            signSrc = this.generatePaymentSignSrc(requestOrder);
        } else if (VERSION_REFUND_V13.equals(requestOrder.getVersion())) {
            signSrc = this.generateRefundSignSrc(requestOrder);
        } else if (VERSION_QUERY_V15.equals(requestOrder.getVersion())) {
            signSrc = this.generateQuerySignSrc(requestOrder);
        } else if (VERSION_PAYMENT_V2.equals(requestOrder.getVersion())) {
            signSrc = this.generatePaymentSignSrc(requestOrder);
        } else if (VERSION_REFUND_V23.equals(requestOrder.getVersion())) {
            signSrc = this.generateRefundSignSrc(requestOrder);
        }
        return signSrc;
    }

    protected boolean verifySignMsg(PaymentResult paymentResult) throws TrxException {
        StringBuffer st = new StringBuffer();
        boolean returnValue = false;
        try {
            st.append("=== Verify start, env: java jdk1.5, date:" + this.currentDate + " ===\n");
            String signSrc = this.generateVerifySrc(paymentResult);
            st.append("[signSrc][").append(signSrc).append("] \n");
            String signMsg = paymentResult.getSignMsg();
            st.append("[signMsg][").append(signMsg).append("] \n");
            switch (Integer.parseInt(paymentResult.getSignType())) {
                case 0: {
                    String strMD5 = this.generateSignMsgOfMD5(signSrc);
                    if (!strMD5.equals(signMsg)) break;
                    returnValue = true;
                    break;
                }
                case 1: {
                    returnValue = SecurityUtil.verifyByRSA(paymentResult.getCertPath(), signSrc.getBytes("UTF-8"), Base64.decode((String)signMsg));
                    break;
                }
            }
            st.append("[verifyResult]").append(returnValue).append(" \n");
            st.append("=== Verify end, env: java jdk1.5, date:" + this.currentDate + " ===\n");
            boolean bl = returnValue;
            return bl;
        }
        catch (UnsupportedEncodingException e) {
            System.out.println(e.getMessage());
            throw new TrxException("TX10001", "\u4e0d\u652f\u6301\u7684\u5b57\u7b26\u7f16\u7801\u683c\u5f0f");
        }
        finally {
            System.out.println(st.toString());
        }
    }

    public String generateSignMsgOfMD5(String signSrc) {
        return SecurityUtil.MD5Encode(signSrc);
    }

    public String generateSignMsgOfCert(String signSrc) {
        return SecurityUtil.MD5Encode(signSrc);
    }

    public String generateSignMsgOfCert(String signSrc, String priavteCertPath, String password) throws TrxException {
        String signMsg = "";
        try {
            Rsa sa = new Rsa();
            PrivateKey privateKey = Rsa.loadPrivateKey(priavteCertPath, password);
            signMsg = new String(Base64.encode((byte[])Rsa.signSha1WithRsa(signSrc.getBytes(), privateKey)));
            return signMsg;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            throw new TrxException("TX20001", "\u7b7e\u540d\u5f02\u5e38");
        }
    }

    private String generatePaymentSignSrc(RequestOrder requestOrder) {
        StringBuffer bufSignSrc = new StringBuffer();
        StringUtil.appendSignPara(bufSignSrc, "inputCharset", requestOrder.getInputCharset() < 0 ? "" : String.valueOf(requestOrder.getInputCharset()));
        StringUtil.appendSignPara(bufSignSrc, "pickupUrl", requestOrder.getPickupUrl());
        StringUtil.appendSignPara(bufSignSrc, "receiveUrl", requestOrder.getReceiveUrl());
        StringUtil.appendSignPara(bufSignSrc, "version", requestOrder.getVersion());
        StringUtil.appendSignPara(bufSignSrc, "language", requestOrder.getLanguage() < 0 ? "" : String.valueOf(requestOrder.getLanguage()));
        StringUtil.appendSignPara(bufSignSrc, "signType", String.valueOf(requestOrder.getSignType()));
        StringUtil.appendSignPara(bufSignSrc, "merchantId", requestOrder.getMerchantId());
        StringUtil.appendSignPara(bufSignSrc, "payerName", requestOrder.getPayerName());
        StringUtil.appendSignPara(bufSignSrc, "payerEmail", requestOrder.getPayerEmail());
        StringUtil.appendSignPara(bufSignSrc, "payerTelephone", requestOrder.getPayerTelephone());
        StringUtil.appendSignPara(bufSignSrc, "payerIDCard", requestOrder.getPayerIDCard());
        StringUtil.appendSignPara(bufSignSrc, "pid", requestOrder.getPid());
        StringUtil.appendSignPara(bufSignSrc, "orderNo", requestOrder.getOrderNo());
        StringUtil.appendSignPara(bufSignSrc, "orderAmount", String.valueOf(requestOrder.getOrderAmount()));
        StringUtil.appendSignPara(bufSignSrc, "orderCurrency", requestOrder.getOrderCurrency());
        StringUtil.appendSignPara(bufSignSrc, "orderDatetime", requestOrder.getOrderDatetime());
        StringUtil.appendSignPara(bufSignSrc, "orderExpireDatetime", requestOrder.getOrderExpireDatetime());
        StringUtil.appendSignPara(bufSignSrc, "productName", requestOrder.getProductName());
        StringUtil.appendSignPara(bufSignSrc, "productPrice", requestOrder.getProductPrice() < 0L ? "" : String.valueOf(requestOrder.getProductPrice()));
        StringUtil.appendSignPara(bufSignSrc, "productNum", requestOrder.getProductNum() < 0 ? "" : String.valueOf(requestOrder.getProductNum()));
        StringUtil.appendSignPara(bufSignSrc, "productId", requestOrder.getProductId());
        StringUtil.appendSignPara(bufSignSrc, "productDesc", requestOrder.getProductDesc());
        StringUtil.appendSignPara(bufSignSrc, "ext1", requestOrder.getExt1());
        StringUtil.appendSignPara(bufSignSrc, "ext2", requestOrder.getExt2());
        StringUtil.appendSignPara(bufSignSrc, "extTL", requestOrder.getExtTL());
        if (requestOrder.getVersion().startsWith("v1")) {
            StringUtil.appendSignPara(bufSignSrc, "payType", requestOrder.getPayType() < 0 ? "" : String.valueOf(requestOrder.getPayType()));
            StringUtil.appendSignPara(bufSignSrc, "issuerId", requestOrder.getIssuerId());
        }
        StringUtil.appendSignPara(bufSignSrc, "pan", requestOrder.getPan());
        StringUtil.appendSignPara(bufSignSrc, "tradeNature", requestOrder.getTradeNature());
        StringUtil.appendLastSignPara(bufSignSrc, "key", requestOrder.getKey());
        return bufSignSrc.toString();
    }

    private String generateRefundSignSrc(RequestOrder requestOrder) {
        StringBuffer bufSignSrc = new StringBuffer();
        StringUtil.appendSignPara(bufSignSrc, "version", requestOrder.getVersion());
        StringUtil.appendSignPara(bufSignSrc, "signType", String.valueOf(requestOrder.getSignType()));
        StringUtil.appendSignPara(bufSignSrc, "merchantId", requestOrder.getMerchantId());
        StringUtil.appendSignPara(bufSignSrc, "orderNo", requestOrder.getOrderNo());
        StringUtil.appendSignPara(bufSignSrc, "refundAmount", String.valueOf(requestOrder.getRefundAmount()));
        if (VERSION_REFUND_V23.equals(requestOrder.getVersion())) {
            StringUtil.appendSignPara(bufSignSrc, "mchtRefundOrderNo", String.valueOf(requestOrder.getMchtRefundOrderNo()));
        }
        StringUtil.appendSignPara(bufSignSrc, "orderDatetime", String.valueOf(requestOrder.getOrderDatetime()));
        StringUtil.appendLastSignPara(bufSignSrc, "key", requestOrder.getKey());
        return bufSignSrc.toString();
    }

    private String generateQuerySignSrc(RequestOrder requestOrder) {
        StringBuffer bufSignSrc = new StringBuffer();
        StringUtil.appendSignPara(bufSignSrc, "merchantId", requestOrder.getMerchantId());
        StringUtil.appendSignPara(bufSignSrc, "version", requestOrder.getVersion());
        StringUtil.appendSignPara(bufSignSrc, "signType", String.valueOf(requestOrder.getSignType()));
        StringUtil.appendSignPara(bufSignSrc, "orderNo", requestOrder.getOrderNo());
        StringUtil.appendSignPara(bufSignSrc, "orderDatetime", requestOrder.getOrderDatetime());
        StringUtil.appendSignPara(bufSignSrc, "queryDatetime", requestOrder.getQueryDateTime());
        StringUtil.appendLastSignPara(bufSignSrc, "key", requestOrder.getKey());
        return bufSignSrc.toString();
    }

    private String generateRNPaymentSignSrc(RequestOrder requestOrder) {
        StringBuffer bufSignSrc = new StringBuffer();
        StringUtil.appendSignPara(bufSignSrc, "inputCharset", requestOrder.getInputCharset() < 0 ? "" : String.valueOf(requestOrder.getInputCharset()));
        StringUtil.appendSignPara(bufSignSrc, "pickupUrl", requestOrder.getPickupUrl());
        StringUtil.appendSignPara(bufSignSrc, "receiveUrl", requestOrder.getReceiveUrl());
        StringUtil.appendSignPara(bufSignSrc, "version", requestOrder.getVersion());
        StringUtil.appendSignPara(bufSignSrc, "language", requestOrder.getLanguage() < 0 ? "" : String.valueOf(requestOrder.getLanguage()));
        StringUtil.appendSignPara(bufSignSrc, "signType", String.valueOf(requestOrder.getSignType()));
        StringUtil.appendSignPara(bufSignSrc, "merchantId", requestOrder.getMerchantId());
        StringUtil.appendSignPara(bufSignSrc, "payerName", requestOrder.getPayerName());
        StringUtil.appendSignPara(bufSignSrc, "payerEmail", requestOrder.getPayerEmail());
        StringUtil.appendSignPara(bufSignSrc, "payerTelephone", requestOrder.getPayerTelephone());
        StringUtil.appendSignPara(bufSignSrc, "pid", requestOrder.getPid());
        StringUtil.appendSignPara(bufSignSrc, "orderNo", requestOrder.getOrderNo());
        StringUtil.appendSignPara(bufSignSrc, "orderAmount", String.valueOf(requestOrder.getOrderAmount()));
        StringUtil.appendSignPara(bufSignSrc, "orderCurrency", requestOrder.getOrderCurrency());
        StringUtil.appendSignPara(bufSignSrc, "orderDatetime", requestOrder.getOrderDatetime());
        StringUtil.appendSignPara(bufSignSrc, "orderExpireDatetime", requestOrder.getOrderExpireDatetime());
        StringUtil.appendSignPara(bufSignSrc, "productName", requestOrder.getProductName());
        StringUtil.appendSignPara(bufSignSrc, "productPrice", requestOrder.getProductPrice() < 0L ? "" : String.valueOf(requestOrder.getProductPrice()));
        StringUtil.appendSignPara(bufSignSrc, "productNum", requestOrder.getProductNum() < 0 ? "" : String.valueOf(requestOrder.getProductNum()));
        StringUtil.appendSignPara(bufSignSrc, "productId", requestOrder.getProductId());
        StringUtil.appendSignPara(bufSignSrc, "productDesc", requestOrder.getProductDesc());
        StringUtil.appendSignPara(bufSignSrc, "ext1", requestOrder.getExt1());
        StringUtil.appendSignPara(bufSignSrc, "ext2", requestOrder.getExt2());
        StringUtil.appendSignPara(bufSignSrc, "payType", requestOrder.getPayType() < 0 ? "" : String.valueOf(requestOrder.getPayType()));
        StringUtil.appendSignPara(bufSignSrc, "issuerId", requestOrder.getIssuerId());
        StringUtil.appendSignPara(bufSignSrc, "userName", requestOrder.getUserName());
        StringUtil.appendSignPara(bufSignSrc, "credentialsType", requestOrder.getCredentialsType());
        StringUtil.appendSignPara(bufSignSrc, "credentialsNo", requestOrder.getCredentialsNo());
        StringUtil.appendSignPara(bufSignSrc, "txOrgId", requestOrder.getTxOrgId());
        StringUtil.appendSignPara(bufSignSrc, "pan", requestOrder.getPan());
        StringUtil.appendLastSignPara(bufSignSrc, "key", requestOrder.getKey());
        return bufSignSrc.toString();
    }

    private String generateRNVerifySignSrc(RequestOrder requestOrder) {
        StringBuffer bufSignSrc = new StringBuffer();
        StringUtil.appendSignPara(bufSignSrc, "inputCharset", requestOrder.getInputCharset() < 0 ? "" : String.valueOf(requestOrder.getInputCharset()));
        StringUtil.appendSignPara(bufSignSrc, "pickupUrl", requestOrder.getPickupUrl());
        StringUtil.appendSignPara(bufSignSrc, "receiveUrl", requestOrder.getReceiveUrl());
        StringUtil.appendSignPara(bufSignSrc, "version", requestOrder.getVersion());
        StringUtil.appendSignPara(bufSignSrc, "language", requestOrder.getLanguage() < 0 ? "" : String.valueOf(requestOrder.getLanguage()));
        StringUtil.appendSignPara(bufSignSrc, "signType", String.valueOf(requestOrder.getSignType()));
        StringUtil.appendSignPara(bufSignSrc, "merchantId", requestOrder.getMerchantId());
        StringUtil.appendSignPara(bufSignSrc, "orderNo", String.valueOf(requestOrder.getOrderNo()));
        StringUtil.appendSignPara(bufSignSrc, "orderDatetime", String.valueOf(requestOrder.getOrderDatetime()));
        StringUtil.appendSignPara(bufSignSrc, "payType", requestOrder.getPayType() < 0 ? "" : String.valueOf(requestOrder.getPayType()));
        StringUtil.appendSignPara(bufSignSrc, "userName", requestOrder.getUserName());
        StringUtil.appendSignPara(bufSignSrc, "credentialsType", requestOrder.getCredentialsType());
        StringUtil.appendSignPara(bufSignSrc, "credentialsNo", requestOrder.getCredentialsNo());
        StringUtil.appendSignPara(bufSignSrc, "txOrgId", requestOrder.getTxOrgId());
        StringUtil.appendSignPara(bufSignSrc, "pan", requestOrder.getPan());
        StringUtil.appendLastSignPara(bufSignSrc, "key", requestOrder.getKey());
        return bufSignSrc.toString();
    }

    public String generateRNVAndPaymentSignSrc(RequestOrder requestOrder) {
        return this.generateRNPaymentSignSrc(requestOrder);
    }

    private String generateRNVAndPaymentVerifySrc(PaymentResult paymentResult) {
        return this.generateRNPaymentVerifySrc(paymentResult);
    }

    protected String generateVerifySrc(PaymentResult paymentResult) {
        String verifySrc = null;
        if (VERSION_PAYMENT_V1.equals(paymentResult.getVersion())) {
            verifySrc = this.generatePaymentVerifySrc(paymentResult);
        } else if (VERSION_REFUND_V13.equals(paymentResult.getVersion())) {
            verifySrc = this.generateRefundVerifySrc(paymentResult);
        } else if (VERSION_QUERY_V15.equals(paymentResult.getVersion())) {
            verifySrc = this.generateQueryVerifySrc(paymentResult);
        } else if (VERSION_PAYMENT_V2.equals(paymentResult.getVersion())) {
            verifySrc = this.generatePaymentVerifySrc(paymentResult);
        } else if (VERSION_REFUND_V23.equals(paymentResult.getVersion())) {
            verifySrc = this.generateRefundVerifySrc(paymentResult);
        }
        return verifySrc;
    }

    private String generateRNPaymentVerifySrc(PaymentResult paymentResult) {
        StringBuffer bufSignSrc = new StringBuffer();
        StringUtil.appendSignPara(bufSignSrc, "merchantId", paymentResult.getMerchantId());
        StringUtil.appendSignPara(bufSignSrc, "version", paymentResult.getVersion());
        StringUtil.appendSignPara(bufSignSrc, "language", paymentResult.getLanguage());
        StringUtil.appendSignPara(bufSignSrc, "signType", paymentResult.getSignType());
        StringUtil.appendSignPara(bufSignSrc, "payType", paymentResult.getPayType());
        StringUtil.appendSignPara(bufSignSrc, "issuerId", paymentResult.getIssuerId());
        StringUtil.appendSignPara(bufSignSrc, "paymentOrderId", paymentResult.getPaymentOrderId());
        StringUtil.appendSignPara(bufSignSrc, "orderNo", paymentResult.getOrderNo());
        StringUtil.appendSignPara(bufSignSrc, "orderDatetime", paymentResult.getOrderDatetime());
        StringUtil.appendSignPara(bufSignSrc, "orderAmount", paymentResult.getOrderAmount());
        StringUtil.appendSignPara(bufSignSrc, "payDatetime", paymentResult.getPayDatetime());
        StringUtil.appendSignPara(bufSignSrc, "payAmount", paymentResult.getPayAmount());
        StringUtil.appendSignPara(bufSignSrc, "ext1", paymentResult.getExt1());
        StringUtil.appendSignPara(bufSignSrc, "ext2", paymentResult.getExt2());
        StringUtil.appendSignPara(bufSignSrc, "payResult", paymentResult.getPayResult());
        StringUtil.appendSignPara(bufSignSrc, "errorCode", paymentResult.getErrorCode());
        StringUtil.appendSignPara(bufSignSrc, "userName", paymentResult.getUserName());
        StringUtil.appendSignPara(bufSignSrc, "credentialsType", paymentResult.getCredentialsType());
        StringUtil.appendSignPara(bufSignSrc, "credentialsNo", paymentResult.getCredentialsNo());
        StringUtil.appendSignPara(bufSignSrc, "txOrgId", paymentResult.getTxOrgId());
        StringUtil.appendSignPara(bufSignSrc, "pan", paymentResult.getPan());
        switch (Integer.parseInt(paymentResult.getSignType())) {
            case 0: {
                StringUtil.appendSignPara(bufSignSrc, "returnDatetime", paymentResult.getReturnDatetime());
                StringUtil.appendLastSignPara(bufSignSrc, "key", paymentResult.getKey());
                break;
            }
            case 1: {
                StringUtil.appendLastSignPara(bufSignSrc, "returnDatetime", paymentResult.getReturnDatetime());
                break;
            }
        }
        return bufSignSrc.toString();
    }

    private String generateRNVerifyVerifySrc(PaymentResult paymentResult) {
        StringBuffer bufSignSrc = new StringBuffer();
        StringUtil.appendSignPara(bufSignSrc, "merchantId", paymentResult.getMerchantId());
        StringUtil.appendSignPara(bufSignSrc, "version", paymentResult.getVersion());
        StringUtil.appendSignPara(bufSignSrc, "language", paymentResult.getLanguage());
        StringUtil.appendSignPara(bufSignSrc, "signType", paymentResult.getSignType());
        StringUtil.appendSignPara(bufSignSrc, "payType", paymentResult.getPayType());
        StringUtil.appendSignPara(bufSignSrc, "paymentOrderId", paymentResult.getPaymentOrderId());
        StringUtil.appendSignPara(bufSignSrc, "orderNo", paymentResult.getOrderNo());
        StringUtil.appendSignPara(bufSignSrc, "orderDatetime", paymentResult.getOrderDatetime());
        StringUtil.appendSignPara(bufSignSrc, "payDatetime", paymentResult.getPayDatetime());
        StringUtil.appendSignPara(bufSignSrc, "payResult", paymentResult.getPayResult());
        StringUtil.appendSignPara(bufSignSrc, "errorCode", paymentResult.getErrorCode());
        StringUtil.appendSignPara(bufSignSrc, "userName", paymentResult.getUserName());
        StringUtil.appendSignPara(bufSignSrc, "credentialsType", paymentResult.getCredentialsType());
        StringUtil.appendSignPara(bufSignSrc, "credentialsNo", paymentResult.getCredentialsNo());
        StringUtil.appendSignPara(bufSignSrc, "txOrgId", paymentResult.getTxOrgId());
        StringUtil.appendSignPara(bufSignSrc, "pan", paymentResult.getPan());
        switch (Integer.parseInt(paymentResult.getSignType())) {
            case 0: {
                StringUtil.appendSignPara(bufSignSrc, "returnDatetime", paymentResult.getReturnDatetime());
                StringUtil.appendLastSignPara(bufSignSrc, "key", paymentResult.getKey());
                break;
            }
            case 1: {
                StringUtil.appendLastSignPara(bufSignSrc, "returnDatetime", paymentResult.getReturnDatetime());
                break;
            }
        }
        return bufSignSrc.toString();
    }

    private String generatePaymentVerifySrc(PaymentResult paymentResult) {
        StringBuffer bufSignSrc = new StringBuffer();
        StringUtil.appendSignPara(bufSignSrc, "merchantId", paymentResult.getMerchantId());
        StringUtil.appendSignPara(bufSignSrc, "version", paymentResult.getVersion());
        StringUtil.appendSignPara(bufSignSrc, "language", paymentResult.getLanguage());
        StringUtil.appendSignPara(bufSignSrc, "signType", paymentResult.getSignType());
        StringUtil.appendSignPara(bufSignSrc, "payType", paymentResult.getPayType());
        StringUtil.appendSignPara(bufSignSrc, "issuerId", paymentResult.getIssuerId());
        StringUtil.appendSignPara(bufSignSrc, "paymentOrderId", paymentResult.getPaymentOrderId());
        StringUtil.appendSignPara(bufSignSrc, "orderNo", paymentResult.getOrderNo());
        StringUtil.appendSignPara(bufSignSrc, "orderDatetime", paymentResult.getOrderDatetime());
        StringUtil.appendSignPara(bufSignSrc, "orderAmount", String.valueOf(paymentResult.getOrderAmount()));
        StringUtil.appendSignPara(bufSignSrc, "payDatetime", paymentResult.getPayDatetime());
        StringUtil.appendSignPara(bufSignSrc, "payAmount", String.valueOf(paymentResult.getPayAmount()));
        StringUtil.appendSignPara(bufSignSrc, "ext1", paymentResult.getExt1());
        StringUtil.appendSignPara(bufSignSrc, "ext2", paymentResult.getExt2());
        StringUtil.appendSignPara(bufSignSrc, "payResult", paymentResult.getPayResult());
        StringUtil.appendSignPara(bufSignSrc, "errorCode", paymentResult.getErrorCode());
        switch (Integer.parseInt(paymentResult.getSignType())) {
            case 0: {
                StringUtil.appendSignPara(bufSignSrc, "returnDatetime", paymentResult.getReturnDatetime());
                StringUtil.appendLastSignPara(bufSignSrc, "key", paymentResult.getKey());
                break;
            }
            case 1: {
                StringUtil.appendLastSignPara(bufSignSrc, "returnDatetime", paymentResult.getReturnDatetime());
                break;
            }
        }
        return bufSignSrc.toString();
    }

    private String generateRefundVerifySrc(PaymentResult paymentResult) {
        StringBuffer bufSignSrc = new StringBuffer();
        StringUtil.appendSignPara(bufSignSrc, "merchantId", paymentResult.getMerchantId());
        StringUtil.appendSignPara(bufSignSrc, "version", paymentResult.getVersion());
        StringUtil.appendSignPara(bufSignSrc, "signType", paymentResult.getSignType());
        StringUtil.appendSignPara(bufSignSrc, "orderNo", paymentResult.getOrderNo());
        StringUtil.appendSignPara(bufSignSrc, "orderAmount", paymentResult.getOrderAmount());
        StringUtil.appendSignPara(bufSignSrc, "orderDatetime", paymentResult.getOrderDatetime());
        StringUtil.appendSignPara(bufSignSrc, "refundAmount", paymentResult.getRefundAmount());
        StringUtil.appendSignPara(bufSignSrc, "refundDatetime", paymentResult.getRefundDatetime());
        StringUtil.appendSignPara(bufSignSrc, "refundResult", paymentResult.getRefundResult());
        if (VERSION_REFUND_V13.equals(paymentResult.getVersion())) {
            StringUtil.appendSignPara(bufSignSrc, "errorCode", paymentResult.getErrorCode());
        }
        if (Integer.parseInt(paymentResult.getSignType()) == 0) {
            StringUtil.appendSignPara(bufSignSrc, "mchtRefundOrderNo", paymentResult.getMchtRefundOrderNo());
            StringUtil.appendSignPara(bufSignSrc, "returnDatetime", paymentResult.getReturnDatetime());
            StringUtil.appendLastSignPara(bufSignSrc, "key", paymentResult.getKey());
        }
        if (Integer.parseInt(paymentResult.getSignType()) == 1) {
            StringUtil.appendSignPara(bufSignSrc, "mchtRefundOrderNo", paymentResult.getMchtRefundOrderNo());
            StringUtil.appendLastSignPara(bufSignSrc, "returnDatetime", paymentResult.getReturnDatetime());
        }
        return bufSignSrc.toString();
    }

    private String generateQueryVerifySrc(PaymentResult paymentResult) {
        return this.generatePaymentVerifySrc(paymentResult);
    }

    protected void checkSignParams(RequestOrder requestOrder) throws TrxException {
        if (VERSION_PAYMENT_V1.equals(requestOrder.getVersion())) {
            this.checkPaymentSignParams(requestOrder);
        } else if (VERSION_REFUND_V13.equals(requestOrder.getVersion())) {
            this.checkRefundSignParams(requestOrder);
        } else if (VERSION_QUERY_V15.equals(requestOrder.getVersion())) {
            this.checkQuerySignParams(requestOrder);
        }
        if (VERSION_PAYMENT_V2.equals(requestOrder.getVersion())) {
            this.checkPaymentSignParams(requestOrder);
        } else if (VERSION_REFUND_V23.equals(requestOrder.getVersion())) {
            this.checkRefundSignParams(requestOrder);
        }
    }

    private void checkRNVAndPaymentSignParams(RequestOrder requestOrder) throws TrxException {
        this.checkRNPaymentSignParams(requestOrder);
    }

    private void checkRNVerifySignParams(RequestOrder requestOrder) throws TrxException {
        int charset = requestOrder.getInputCharset();
        if (charset >= 0 && charset != 1 && charset != 2 && charset != 3) {
            throw new TrxException("TX10001", "\u4e0d\u652f\u6301\u7684\u5b57\u7b26\u7f16\u7801\u683c\u5f0f");
        }
        String pickupUrl = requestOrder.getPickupUrl();
        String receiveUrl = requestOrder.getReceiveUrl();
        if (StringUtil.isEmpty(pickupUrl) && StringUtil.isEmpty(receiveUrl)) {
            throw new TrxException("TX10002", "\u53d6\u8d27\u5730\u5740\u548c\u901a\u77e5\u5730\u5740\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (!StringUtil.isEmpty(pickupUrl) && !pickupUrl.startsWith("http")) {
            throw new TrxException("TX10003", "\u53d6\u8d27\u5730\u5740\u4e0d\u5408\u6cd5");
        }
        if (!StringUtil.isEmpty(receiveUrl) && !receiveUrl.startsWith("http")) {
            throw new TrxException("TX10004", "\u901a\u77e5\u5730\u5740\u4e0d\u5408\u6cd5");
        }
        if (!VERSION_REALNAME_VERIFY_V5.equals(requestOrder.getVersion())) {
            throw new TrxException("TX10005", "\u7248\u672c\u53f7\u4e0d\u5408\u6cd5");
        }
        if (StringUtil.isEmpty(requestOrder.getMerchantId())) {
            throw new TrxException("TX10006", "\u5546\u6237\u53f7\u4e0d\u5408\u6cd5");
        }
        String orderId = requestOrder.getOrderNo();
        if (StringUtil.isEmpty(orderId) || orderId.length() > 50 || !this.isPatternMatcher(orderIdPattern, orderId)) {
            throw new TrxException("TX10009", "\u8ba2\u5355\u53f7\u4e0d\u5408\u6cd5");
        }
        if (StringUtil.isEmpty(requestOrder.getOrderDatetime())) {
            throw new TrxException("TX10011", "\u8ba2\u5355\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
            formatter.parse(requestOrder.getOrderDatetime());
        }
        catch (ParseException e) {
            throw new TrxException("TX10012", "\u8ba2\u5355\u65f6\u95f4\u4e0d\u5408\u6cd5");
        }
        int payType = requestOrder.getPayType();
        if (payType != 5) {
            throw new TrxException("TX10018", "\u652f\u4ed8\u65b9\u5f0f\u4e0d\u5408\u6cd5");
        }
        int signType = requestOrder.getSignType();
        if (signType != 0 && signType != 1) {
            throw new TrxException("TX10019", "\u7b7e\u540d\u7c7b\u578b\u4e0d\u5408\u6cd5");
        }
        String userName = requestOrder.getUserName();
        if (StringUtil.isEmpty(userName) || userName.length() > 20) {
            throw new TrxException("TX10020", "\u5b9e\u540d\u4ea4\u6613-\u7528\u6237\u771f\u5b9e\u59d3\u540d\u4e0d\u5408\u6cd5");
        }
        String credentialsType = requestOrder.getCredentialsType();
        if (!(!StringUtil.isEmpty(credentialsType) && ("01".equals(credentialsType) || "02".equals(credentialsType) || "03".equals(credentialsType) || "04".equals(credentialsType) || "05".equals(credentialsType) || "06".equals(credentialsType) || "07".equals(credentialsType) || "99".equals(credentialsType)))) {
            throw new TrxException("TX10021", "\u5b9e\u540d\u4ea4\u6613-\u8bc1\u4ef6\u7c7b\u578b\u4e0d\u5408\u6cd5");
        }
        if (StringUtil.isEmpty(requestOrder.getCredentialsNo()) || requestOrder.getCredentialsNo().length() > 20) {
            throw new TrxException("TX10022", "\u5b9e\u540d\u4ea4\u6613-\u8bc1\u4ef6\u53f7\u7801\u4e0d\u5408\u6cd5");
        }
        if (StringUtil.isEmpty(requestOrder.getTxOrgId()) || requestOrder.getTxOrgId().length() > 11) {
            throw new TrxException("TX10023", "\u5b9e\u540d\u4ea4\u6613-\u6307\u5b9a\u4ea4\u6613\u673a\u6784\u53f7\u4e0d\u5408\u6cd5");
        }
        if (StringUtil.isEmpty(requestOrder.getPan()) || requestOrder.getPan().length() > 19) {
            throw new TrxException("TX10024", "\u5b9e\u540d\u4ea4\u6613-\u5361\u53f7\u4e0d\u5408\u6cd5");
        }
    }

    private void checkRNPaymentSignParams(RequestOrder requestOrder) throws TrxException {
        int charset = requestOrder.getInputCharset();
        if (charset >= 0 && charset != 1 && charset != 2 && charset != 3) {
            throw new TrxException("TX10001", "\u4e0d\u652f\u6301\u7684\u5b57\u7b26\u7f16\u7801\u683c\u5f0f");
        }
        String pickupUrl = requestOrder.getPickupUrl();
        String receiveUrl = requestOrder.getReceiveUrl();
        if (StringUtil.isEmpty(pickupUrl) && StringUtil.isEmpty(receiveUrl)) {
            throw new TrxException("TX10002", "\u53d6\u8d27\u5730\u5740\u548c\u901a\u77e5\u5730\u5740\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (!StringUtil.isEmpty(pickupUrl) && !pickupUrl.startsWith("http")) {
            throw new TrxException("TX10003", "\u53d6\u8d27\u5730\u5740\u4e0d\u5408\u6cd5");
        }
        if (!StringUtil.isEmpty(receiveUrl) && !receiveUrl.startsWith("http")) {
            throw new TrxException("TX10004", "\u901a\u77e5\u5730\u5740\u4e0d\u5408\u6cd5");
        }
        if (!VERSION_REALNAME_PAYMENT_V51.equals(requestOrder.getVersion()) && !VERSION_REALNAME_VANDPAYMENT_V55.equals(requestOrder.getVersion())) {
            throw new TrxException("TX10005", "\u7248\u672c\u53f7\u4e0d\u5408\u6cd5");
        }
        if (StringUtil.isEmpty(requestOrder.getMerchantId())) {
            throw new TrxException("TX10006", "\u5546\u6237\u53f7\u4e0d\u5408\u6cd5");
        }
        if (!StringUtil.isEmpty(requestOrder.getPayerName()) && requestOrder.getPayerName().length() > 32) {
            throw new TrxException("TX10007", "\u4ed8\u6b3e\u4eba\u540d\u79f0\u4e0d\u5408\u6cd5");
        }
        if (!StringUtil.isEmpty(requestOrder.getPayerEmail()) && requestOrder.getPayerEmail().length() > 50) {
            throw new TrxException("TX10008", "\u4ed8\u6b3e\u4eba\u7684email\u5730\u5740\u4e0d\u5408\u6cd5");
        }
        String orderId = requestOrder.getOrderNo();
        if (StringUtil.isEmpty(orderId) || orderId.length() > 50 || !this.isPatternMatcher(orderIdPattern, orderId)) {
            throw new TrxException("TX10009", "\u8ba2\u5355\u53f7\u4e0d\u5408\u6cd5");
        }
        Long amount = requestOrder.getOrderAmount();
        if (null == amount || amount <= 0L || !this.isPatternMatcher(orderAmountPattern, amount.toString())) {
            throw new TrxException("TX10010", "\u8ba2\u5355\u91d1\u989d\u4e0d\u5408\u6cd5");
        }
        if (StringUtil.isEmpty(requestOrder.getOrderDatetime())) {
            throw new TrxException("TX10011", "\u8ba2\u5355\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
            formatter.parse(requestOrder.getOrderDatetime());
        }
        catch (ParseException e) {
            throw new TrxException("TX10012", "\u8ba2\u5355\u65f6\u95f4\u4e0d\u5408\u6cd5");
        }
        if (!StringUtil.isEmpty(requestOrder.getProductName()) && requestOrder.getProductName().length() > 256) {
            throw new TrxException("TX10013", "\u4ea7\u54c1\u540d\u79f0\u4e0d\u5408\u6cd5");
        }
        if (!StringUtil.isEmpty(requestOrder.getProductId()) && requestOrder.getProductId().length() > 20) {
            throw new TrxException("TX10014", "\u4ea7\u54c1\u4ee3\u7801\u4e0d\u5408\u6cd5");
        }
        if (!StringUtil.isEmpty(requestOrder.getProductDesc()) && requestOrder.getProductDesc().length() > 400) {
            throw new TrxException("TX10015", "\u4ea7\u54c1\u63cf\u8ff0\u4fe1\u606f\u4e0d\u5408\u6cd5");
        }
        if (!StringUtil.isEmpty(requestOrder.getExt1()) && requestOrder.getExt1().length() > 128) {
            throw new TrxException("TX10016", "\u6269\u5c55\u53c2\u65701\u4e0d\u5408\u6cd5");
        }
        if (!StringUtil.isEmpty(requestOrder.getExt2()) && requestOrder.getExt2().length() > 128) {
            throw new TrxException("TX10017", "\u6269\u5c55\u53c2\u65702\u4e0d\u5408\u6cd5");
        }
        int payType = requestOrder.getPayType();
        if (payType != 5) {
            throw new TrxException("TX10018", "\u652f\u4ed8\u65b9\u5f0f\u4e0d\u5408\u6cd5");
        }
        int signType = requestOrder.getSignType();
        if (signType != 0 && signType != 1) {
            throw new TrxException("TX10019", "\u7b7e\u540d\u7c7b\u578b\u4e0d\u5408\u6cd5");
        }
        String userName = requestOrder.getUserName();
        if (StringUtil.isEmpty(userName) || userName.length() > 20) {
            throw new TrxException("TX10020", "\u5b9e\u540d\u4ea4\u6613-\u7528\u6237\u771f\u5b9e\u59d3\u540d\u4e0d\u5408\u6cd5");
        }
        String credentialsType = requestOrder.getCredentialsType();
        if (!(!StringUtil.isEmpty(credentialsType) && ("01".equals(credentialsType) || "02".equals(credentialsType) || "03".equals(credentialsType) || "04".equals(credentialsType) || "05".equals(credentialsType) || "06".equals(credentialsType) || "07".equals(credentialsType) || "99".equals(credentialsType)))) {
            throw new TrxException("TX10021", "\u5b9e\u540d\u4ea4\u6613-\u8bc1\u4ef6\u7c7b\u578b\u4e0d\u5408\u6cd5");
        }
        if (StringUtil.isEmpty(requestOrder.getCredentialsNo()) || requestOrder.getCredentialsNo().length() > 20) {
            throw new TrxException("TX10022", "\u5b9e\u540d\u4ea4\u6613-\u8bc1\u4ef6\u53f7\u7801\u4e0d\u5408\u6cd5");
        }
        if (StringUtil.isEmpty(requestOrder.getTxOrgId()) || requestOrder.getTxOrgId().length() > 11) {
            throw new TrxException("TX10023", "\u5b9e\u540d\u4ea4\u6613-\u6307\u5b9a\u4ea4\u6613\u673a\u6784\u53f7\u4e0d\u5408\u6cd5");
        }
        if (StringUtil.isEmpty(requestOrder.getPan()) || requestOrder.getPan().length() > 19) {
            throw new TrxException("TX10024", "\u5b9e\u540d\u4ea4\u6613-\u5361\u53f7\u4e0d\u5408\u6cd5");
        }
    }

    private void checkRefundSignParams(RequestOrder requestOrder) throws TrxException {
        if (StringUtil.isEmpty(requestOrder.getMerchantId())) {
            throw new TrxException("TX10006", "\u5546\u6237\u53f7\u4e0d\u5408\u6cd5");
        }
        if (!VERSION_REFUND_V13.equals(requestOrder.getVersion()) && !VERSION_REFUND_V23.equals(requestOrder.getVersion())) {
            throw new TrxException("TX10005", "\u7248\u672c\u53f7\u4e0d\u5408\u6cd5");
        }
        int signType = requestOrder.getSignType();
        if (signType != 0 && signType != 1) {
            throw new TrxException("TX10019", "\u7b7e\u540d\u7c7b\u578b\u4e0d\u5408\u6cd5");
        }
        String orderId = requestOrder.getOrderNo();
        if (StringUtil.isEmpty(orderId) || orderId.length() > 50 || !this.isPatternMatcher(orderIdPattern, orderId)) {
            throw new TrxException("TX10009", "\u8ba2\u5355\u53f7\u4e0d\u5408\u6cd5");
        }
        Long amount = requestOrder.getRefundAmount();
        if (null == amount || amount <= 0L || !this.isPatternMatcher(orderAmountPattern, amount.toString())) {
            throw new TrxException("TX10010", "\u8ba2\u5355\u91d1\u989d\u4e0d\u5408\u6cd5");
        }
        if (StringUtil.isEmpty(requestOrder.getOrderDatetime())) {
            throw new TrxException("TX10011", "\u8ba2\u5355\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
            formatter.parse(requestOrder.getOrderDatetime());
        }
        catch (ParseException e) {
            throw new TrxException("TX10012", "\u8ba2\u5355\u65f6\u95f4\u4e0d\u5408\u6cd5");
        }
    }

    private void checkQuerySignParams(RequestOrder requestOrder) throws TrxException {
        SimpleDateFormat formatter;
        if (StringUtil.isEmpty(requestOrder.getMerchantId())) {
            throw new TrxException("TX10006", "\u5546\u6237\u53f7\u4e0d\u5408\u6cd5");
        }
        if (!VERSION_QUERY_V15.equals(requestOrder.getVersion())) {
            throw new TrxException("TX10005", "\u7248\u672c\u53f7\u4e0d\u5408\u6cd5");
        }
        int signType = requestOrder.getSignType();
        if (signType != 0 && signType != 1) {
            throw new TrxException("TX10019", "\u7b7e\u540d\u7c7b\u578b\u4e0d\u5408\u6cd5");
        }
        String orderId = requestOrder.getOrderNo();
        if (StringUtil.isEmpty(orderId) || orderId.length() > 50 || !this.isPatternMatcher(orderIdPattern, orderId)) {
            throw new TrxException("TX10009", "\u8ba2\u5355\u53f7\u4e0d\u5408\u6cd5");
        }
        if (StringUtil.isEmpty(requestOrder.getOrderDatetime())) {
            throw new TrxException("TX10011", "\u8ba2\u5355\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            formatter = new SimpleDateFormat("yyyyMMddHHmmss");
            formatter.parse(requestOrder.getOrderDatetime());
        }
        catch (ParseException e) {
            throw new TrxException("TX10012", "\u8ba2\u5355\u65f6\u95f4\u4e0d\u5408\u6cd5");
        }
        if (StringUtil.isEmpty(requestOrder.getQueryDateTime())) {
            throw new TrxException("TX10030", "\u67e5\u8be2\u65f6\u95f4\u4e0d\u5408\u6cd5");
        }
        try {
            formatter = new SimpleDateFormat("yyyyMMddHHmmss");
            formatter.parse(requestOrder.getQueryDateTime());
        }
        catch (ParseException e) {
            throw new TrxException("TX10031", "\u67e5\u8be2\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void checkPaymentSignParams(RequestOrder requestOrder) throws TrxException {
        int charset = requestOrder.getInputCharset();
        if (charset >= 0 && charset != 1 && charset != 2 && charset != 3) {
            throw new TrxException("TX10001", "\u4e0d\u652f\u6301\u7684\u5b57\u7b26\u7f16\u7801\u683c\u5f0f");
        }
        String pickupUrl = requestOrder.getPickupUrl();
        String receiveUrl = requestOrder.getReceiveUrl();
        if (StringUtil.isEmpty(pickupUrl) && StringUtil.isEmpty(receiveUrl)) {
            throw new TrxException("TX10002", "\u53d6\u8d27\u5730\u5740\u548c\u901a\u77e5\u5730\u5740\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (!StringUtil.isEmpty(pickupUrl) && !pickupUrl.startsWith("http")) {
            throw new TrxException("TX10003", "\u53d6\u8d27\u5730\u5740\u4e0d\u5408\u6cd5");
        }
        if (!StringUtil.isEmpty(receiveUrl) && !receiveUrl.startsWith("http")) {
            throw new TrxException("TX10004", "\u901a\u77e5\u5730\u5740\u4e0d\u5408\u6cd5");
        }
        if (!VERSION_PAYMENT_V1.equals(requestOrder.getVersion())) {
            throw new TrxException("TX10005", "\u7248\u672c\u53f7\u4e0d\u5408\u6cd5");
        }
        if (StringUtil.isEmpty(requestOrder.getMerchantId())) {
            throw new TrxException("TX10006", "\u5546\u6237\u53f7\u4e0d\u5408\u6cd5");
        }
        if (!StringUtil.isEmpty(requestOrder.getPayerName()) && requestOrder.getPayerName().length() > 32) {
            throw new TrxException("TX10007", "\u4ed8\u6b3e\u4eba\u540d\u79f0\u4e0d\u5408\u6cd5");
        }
        if (!StringUtil.isEmpty(requestOrder.getPayerEmail()) && requestOrder.getPayerEmail().length() > 50) {
            throw new TrxException("TX10008", "\u4ed8\u6b3e\u4eba\u7684email\u5730\u5740\u4e0d\u5408\u6cd5");
        }
        String orderId = requestOrder.getOrderNo();
        if (StringUtil.isEmpty(orderId) || orderId.length() > 50 || !this.isPatternMatcher(orderIdPattern, orderId)) {
            throw new TrxException("TX10009", "\u8ba2\u5355\u53f7\u4e0d\u5408\u6cd5");
        }
        Long amount = requestOrder.getOrderAmount();
        if (null == amount || amount <= 0L || !this.isPatternMatcher(orderAmountPattern, amount.toString())) {
            throw new TrxException("TX10010", "\u8ba2\u5355\u91d1\u989d\u4e0d\u5408\u6cd5");
        }
        if (StringUtil.isEmpty(requestOrder.getOrderDatetime())) {
            throw new TrxException("TX10011", "\u8ba2\u5355\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
            formatter.parse(requestOrder.getOrderDatetime());
        }
        catch (ParseException e) {
            throw new TrxException("TX10012", "\u8ba2\u5355\u65f6\u95f4\u4e0d\u5408\u6cd5");
        }
        if (!StringUtil.isEmpty(requestOrder.getProductName()) && requestOrder.getProductName().length() > 256) {
            throw new TrxException("TX10013", "\u4ea7\u54c1\u540d\u79f0\u4e0d\u5408\u6cd5");
        }
        if (!StringUtil.isEmpty(requestOrder.getProductId()) && requestOrder.getProductId().length() > 20) {
            throw new TrxException("TX10014", "\u4ea7\u54c1\u4ee3\u7801\u4e0d\u5408\u6cd5");
        }
        if (!StringUtil.isEmpty(requestOrder.getProductDesc()) && requestOrder.getProductDesc().length() > 400) {
            throw new TrxException("TX10015", "\u4ea7\u54c1\u63cf\u8ff0\u4fe1\u606f\u4e0d\u5408\u6cd5");
        }
        if (!StringUtil.isEmpty(requestOrder.getExt1()) && requestOrder.getExt1().length() > 128) {
            throw new TrxException("TX10016", "\u6269\u5c55\u53c2\u65701\u4e0d\u5408\u6cd5");
        }
        if (!StringUtil.isEmpty(requestOrder.getExt2()) && requestOrder.getExt2().length() > 128) {
            throw new TrxException("TX10017", "\u6269\u5c55\u53c2\u65702\u4e0d\u5408\u6cd5");
        }
        int payType = requestOrder.getPayType();
        if (payType < 0) {
            throw new TrxException("TX10018", "\u652f\u4ed8\u65b9\u5f0f\u4e0d\u5408\u6cd5");
        }
        if (!StringUtil.isEmpty(requestOrder.getIssuerId()) && payType <= 0) {
            throw new TrxException("TX10025", "\u672a\u6307\u5b9a\u652f\u4ed8\u65b9\u5f0f");
        }
        int signType = requestOrder.getSignType();
        if (signType != 0 && signType != 1) {
            throw new TrxException("TX10019", "\u7b7e\u540d\u7c7b\u578b\u4e0d\u5408\u6cd5");
        }
        String tradeNature = requestOrder.getTradeNature();
        String orderCurrency = requestOrder.getOrderCurrency();
        if (StringUtil.isEmpty(tradeNature) && !StringUtil.isEmpty(orderCurrency) && !"0".equals(orderCurrency) && !"156".equals(orderCurrency)) {
            throw new TrxException("TX10029", "\u5e01\u79cd\u975e\u4eba\u6c11\u5e01\u65f6\uff0c\u8d38\u6613\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    protected boolean isPatternMatcher(Pattern p, String matherStr) {
        Matcher m = p.matcher(matherStr);
        return m.matches();
    }
}

