/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus.session.repository.inmemory;

import com.amadeus.session.SessionData;
import com.amadeus.session.SessionManager;
import com.amadeus.session.SessionRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryRepository
implements SessionRepository {
    private static final Logger logger = LoggerFactory.getLogger(InMemoryRepository.class);
    ConcurrentHashMap<String, SessionData> sessionDataCache = new ConcurrentHashMap();
    ConcurrentHashMap<String, Map<String, Object>> sessionAttributeCache = new ConcurrentHashMap();
    private SessionManager sessionManager;
    private final String namespace;
    private ScheduledFuture<?> cleanupFuture;

    public InMemoryRepository(String namespace) {
        this.namespace = namespace;
    }

    private void remove(String sessionId) {
        String id = this.id(sessionId);
        this.sessionDataCache.remove(id);
        this.sessionAttributeCache.remove(id);
    }

    private String id(String id) {
        return new StringBuilder(this.namespace.length() + 1 + id.length()).append(this.namespace).append(':').append(id).toString();
    }

    @Override
    public SessionData getSessionData(String id) {
        return this.sessionDataCache.get(this.id(id));
    }

    @Override
    public void storeSessionData(SessionData sessionData) {
        String id = this.id(sessionData.getId());
        this.sessionDataCache.put(id, sessionData);
        this.sessionAttributeCache.putIfAbsent(id, new ConcurrentHashMap());
    }

    @Override
    public Set<String> getAllKeys(SessionData session) {
        Map<String, Object> attributes = this.sessionAttributeCache.get(this.id(session.getId()));
        if (attributes != null) {
            return attributes.keySet();
        }
        return Collections.emptySet();
    }

    @Override
    public Object getSessionAttribute(SessionData session, String attribute) {
        Map<String, Object> attributes = this.sessionAttributeCache.get(this.id(session.getId()));
        if (attributes != null) {
            return attributes.get(attribute);
        }
        return null;
    }

    @Override
    public void remove(SessionData session) {
        this.remove(session.getId());
    }

    @Override
    public boolean prepareRemove(SessionData session) {
        this.sessionDataCache.remove(this.id(session.getId()));
        return true;
    }

    @Override
    public SessionRepository.CommitTransaction startCommit(SessionData session) {
        return new Transaction(session);
    }

    @Override
    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
        this.cleanupFuture = sessionManager.schedule("in-memory-cleanup", new CleanupTask(), TimeUnit.MINUTES.toSeconds(1L));
    }

    @Override
    public void requestFinished() {
    }

    @Override
    public void setSessionAttribute(SessionData session, String name, Object value) {
        this.getAttributeMap(session.getId()).put(name, value);
    }

    private Map<String, Object> getAttributeMap(String sessionId) {
        Map<String, Object> attrPrev;
        String id = this.id(sessionId);
        Map<String, Object> attrs = this.sessionAttributeCache.get(id);
        if (attrs == null && (attrPrev = this.sessionAttributeCache.putIfAbsent(id, attrs = new ConcurrentHashMap<String, Object>())) != null) {
            attrs = attrPrev;
        }
        return attrs;
    }

    @Override
    public void removeSessionAttribute(SessionData session, String name) {
        this.getAttributeMap(session.getId()).remove(name);
    }

    @Override
    public boolean cleanSessionsOnShutdown() {
        return true;
    }

    @Override
    public Collection<String> getOwnedSessionIds() {
        ArrayList<String> list = new ArrayList<String>(this.sessionDataCache.size());
        for (SessionData sd : this.sessionDataCache.values()) {
            list.add(sd.getId());
        }
        return Collections.unmodifiableCollection(list);
    }

    @Override
    public void close() {
        if (this.cleanupFuture != null) {
            this.cleanupFuture.cancel(true);
            this.cleanupFuture = null;
        }
    }

    @Override
    public void sessionIdChange(SessionData sessionData) {
        Map<String, Object> attributes;
        String id = this.id(sessionData.getId());
        String oldId = this.id(sessionData.getOriginalId());
        SessionData originalSessionData = this.sessionDataCache.get(oldId);
        if (originalSessionData != null) {
            this.sessionDataCache.put(id, originalSessionData);
            this.sessionDataCache.remove(oldId);
            originalSessionData.setNewSessionId(sessionData.getId());
        }
        if ((attributes = this.sessionAttributeCache.remove(oldId)) != null) {
            this.sessionAttributeCache.put(id, attributes);
            this.sessionAttributeCache.remove(oldId);
        }
    }

    private class Transaction
    implements SessionRepository.CommitTransaction {
        ConcurrentHashMap<String, Object> attributes = new ConcurrentHashMap();
        Map<String, Object> toRemove = new ConcurrentHashMap<String, Object>();
        private SessionData session;

        Transaction(SessionData session) {
            this.session = session;
        }

        @Override
        public void addAttribute(String key, Object value) {
            if (value == null) {
                this.toRemove.put(key, key);
            } else {
                this.attributes.put(key, value);
            }
        }

        @Override
        public void removeAttribute(String key) {
            this.toRemove.put(key, key);
        }

        @Override
        public void commit() {
            String id = InMemoryRepository.this.id(this.session.getId());
            SessionData sessionData = InMemoryRepository.this.sessionDataCache.get(id);
            if (sessionData == null) {
                sessionData = new SessionData(this.session.getId(), this.session.getLastAccessedTime(), this.session.getMaxInactiveInterval(), this.session.getCreationTime(), null);
            }
            sessionData.setLastAccessedTime(this.session.getLastAccessedTime());
            sessionData.setMaxInactiveInterval(this.session.getMaxInactiveInterval());
            InMemoryRepository.this.sessionDataCache.put(id, sessionData);
            Map attrs = InMemoryRepository.this.getAttributeMap(this.session.getId());
            attrs.putAll(this.attributes);
            for (String key : this.toRemove.keySet()) {
                attrs.remove(key);
            }
        }

        @Override
        public boolean isSetAllAttributes() {
            return false;
        }

        @Override
        public boolean isDistributing() {
            return false;
        }
    }

    final class CleanupTask
    implements Runnable {
        CleanupTask() {
        }

        @Override
        public void run() {
            long instant = System.currentTimeMillis();
            try {
                HashSet<String> toRemove = new HashSet<String>();
                logger.debug("Sessions in cache {} for {}", InMemoryRepository.this.sessionDataCache, (Object)InMemoryRepository.this.sessionManager);
                for (SessionData sd : InMemoryRepository.this.sessionDataCache.values()) {
                    if (instant - sd.getLastAccessedTime() <= TimeUnit.SECONDS.toMillis(sd.getMaxInactiveInterval())) continue;
                    toRemove.add(sd.getId());
                }
                for (String id : toRemove) {
                    InMemoryRepository.this.sessionManager.delete(id, true);
                    logger.debug("Expiring session with key {}", (Object)id);
                    InMemoryRepository.this.remove(id);
                }
                if (!toRemove.isEmpty()) {
                    logger.info("At {} for {} expired sessions {}", new Object[]{instant, InMemoryRepository.this.sessionManager, toRemove});
                }
            }
            catch (Exception e) {
                logger.error("An error occured while trying to exipre sessions.", (Throwable)e);
            }
        }
    }
}

