/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus.session.repository.redis;

import com.amadeus.session.WrappedException;
import com.amadeus.session.repository.redis.AbstractJedisFacade;
import com.amadeus.session.repository.redis.RedisFacade;
import com.amadeus.session.repository.redis.SafeEncoder;
import com.amadeus.session.repository.redis.TransactionalJedisCluster;
import com.codahale.metrics.MetricRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.BinaryJedisPubSub;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.exceptions.JedisClusterException;
import redis.clients.util.JedisClusterCRC16;
import redis.clients.util.Pool;

class JedisClusterFacade
extends AbstractJedisFacade {
    private final TransactionalJedisCluster jedisCluster;
    private boolean transactionOnKey;

    JedisClusterFacade(TransactionalJedisCluster jedisCluster) {
        this.jedisCluster = jedisCluster;
    }

    @Override
    public void psubscribe(final RedisFacade.RedisPubSub listener, String pattern) {
        BinaryJedisPubSub bps = new BinaryJedisPubSub(){

            public void onPMessage(byte[] pattern, byte[] channel, byte[] message) {
                listener.onPMessage(pattern, channel, message);
            }
        };
        listener.link(bps);
        this.jedisCluster.psubscribe(bps, new byte[][]{SafeEncoder.encode(pattern)});
    }

    @Override
    public void punsubscribe(RedisFacade.RedisPubSub listener, byte[] pattern) {
        ((BinaryJedisPubSub)listener.getLinked()).punsubscribe((byte[][])new byte[][]{pattern});
    }

    @Override
    public Long hdel(byte[] key, byte[] ... fields) {
        return this.jedisCluster.hdel(key, fields);
    }

    @Override
    public List<byte[]> hmget(byte[] key, byte[] ... fields) {
        return this.jedisCluster.hmget(key, fields);
    }

    @Override
    public String hmset(byte[] key, Map<byte[], byte[]> hash) {
        return this.jedisCluster.hmset(key, hash);
    }

    @Override
    public Long hsetnx(byte[] key, byte[] field, byte[] value) {
        return this.jedisCluster.hsetnx(key, field, value);
    }

    @Override
    public Long hset(byte[] key, byte[] field, byte[] value) {
        return this.jedisCluster.hset(key, field, value);
    }

    @Override
    public Set<byte[]> hkeys(byte[] key) {
        return this.jedisCluster.hkeys(key);
    }

    @Override
    public String set(byte[] key, byte[] value) {
        return this.jedisCluster.set(key, value);
    }

    @Override
    public String setex(byte[] key, int expiry, byte[] value) {
        return this.jedisCluster.setex(key, expiry, value);
    }

    @Override
    public Long expire(byte[] key, int value) {
        return this.jedisCluster.expire(key, value);
    }

    @Override
    public void srem(byte[] key, byte[] ... member) {
        this.jedisCluster.srem(key, member);
    }

    @Override
    public Long sadd(byte[] key, byte[] ... member) {
        return this.jedisCluster.sadd(key, member);
    }

    @Override
    public Long del(byte[] ... keys) {
        return this.jedisCluster.del(keys);
    }

    @Override
    public Boolean exists(byte[] key) {
        return this.jedisCluster.exists(key);
    }

    @Override
    public Set<byte[]> smembers(byte[] key) {
        return this.jedisCluster.smembers(key);
    }

    @Override
    public Set<byte[]> spop(byte[] key, long count) {
        return this.jedisCluster.spop(key, count);
    }

    @Override
    public Long expireAt(byte[] key, long unixTime) {
        return this.jedisCluster.expireAt(key, unixTime);
    }

    @Override
    public Long zadd(byte[] key, double score, byte[] elem) {
        return this.jedisCluster.zadd(key, score, elem);
    }

    @Override
    public Long zrem(byte[] key, byte[] ... fields) {
        return this.jedisCluster.zrem(key, fields);
    }

    @Override
    public Set<byte[]> zrangeByScore(byte[] key, double start, double end) {
        return this.jedisCluster.zrangeByScore(key, start, end);
    }

    @Override
    public Set<byte[]> zrange(byte[] key, long start, long end) {
        return this.jedisCluster.zrange(key, start, end);
    }

    @Override
    public Long persist(byte[] key) {
        return this.jedisCluster.persist(key);
    }

    @Override
    public String info(String section) {
        return this.jedisCluster.info(section);
    }

    @Override
    public void close() {
        try {
            this.jedisCluster.close();
        }
        catch (IOException e) {
            throw new WrappedException(e);
        }
    }

    @Override
    public void requestFinished() {
    }

    @Override
    public String rename(byte[] oldkey, byte[] newkey) {
        int newSlot;
        int slot = JedisClusterCRC16.getSlot((byte[])oldkey);
        if (slot != (newSlot = JedisClusterCRC16.getSlot((byte[])newkey))) {
            return this.renameToDifferentSlots(oldkey, newkey);
        }
        return this.jedisCluster.rename(oldkey, newkey);
    }

    private String renameToDifferentSlots(byte[] oldkey, byte[] newkey) {
        String result;
        String type;
        switch (type = this.jedisCluster.type(oldkey)) {
            case "string": {
                result = this.renameString(oldkey, newkey);
                break;
            }
            case "hash": {
                result = this.renameHash(oldkey, newkey);
                break;
            }
            case "set": {
                result = this.renameSet(oldkey, newkey);
                break;
            }
            case "list": {
                result = this.renameList(oldkey, newkey);
                break;
            }
            case "zrange": {
                result = this.renameZRange(oldkey, newkey);
                break;
            }
            default: {
                throw new JedisClusterException("Unknown element type " + type + " for key " + SafeEncoder.encode(oldkey));
            }
        }
        return result;
    }

    String renameSet(byte[] oldkey, byte[] newkey) {
        Set value = this.jedisCluster.smembers(oldkey);
        if (value == null) {
            return "ERR";
        }
        this.jedisCluster.sadd(newkey, (byte[][])new ArrayList(value).toArray((T[])new byte[0][]));
        this.jedisCluster.del(oldkey);
        return "OK";
    }

    String renameHash(byte[] oldkey, byte[] newkey) {
        Map value = this.jedisCluster.hgetAll(oldkey);
        if (value == null) {
            return "ERR";
        }
        this.jedisCluster.hmset(newkey, value);
        this.jedisCluster.del(oldkey);
        return "OK";
    }

    String renameString(byte[] oldkey, byte[] newkey) {
        byte[] value = this.jedisCluster.get(oldkey);
        if (value == null) {
            return "ERR";
        }
        this.jedisCluster.set(newkey, value);
        this.jedisCluster.del(oldkey);
        return "OK";
    }

    String renameList(byte[] oldkey, byte[] newkey) {
        List lrange = this.jedisCluster.lrange(oldkey, 0L, -1L);
        if (lrange == null) {
            return "ERR";
        }
        this.jedisCluster.rpush(newkey, (byte[][])lrange.toArray((T[])new byte[0][]));
        this.jedisCluster.del(oldkey);
        return "OK";
    }

    String renameZRange(byte[] oldkey, byte[] newkey) {
        Set values = this.jedisCluster.zrangeWithScores(oldkey, 0L, -1L);
        if (values == null) {
            return "ERR";
        }
        HashMap<byte[], Double> scoreMembers = new HashMap<byte[], Double>(values.size());
        for (Tuple t : values) {
            scoreMembers.put(t.getBinaryElement(), t.getScore());
        }
        this.jedisCluster.zadd(newkey, scoreMembers);
        this.jedisCluster.del(oldkey);
        return "OK";
    }

    @Override
    public byte[] get(byte[] key) {
        return this.jedisCluster.get(key);
    }

    @Override
    public Long publish(byte[] channel, byte[] message) {
        return this.jedisCluster.publish(channel, message);
    }

    @Override
    public void startMonitoring(MetricRegistry metrics) {
        for (JedisPool item : this.jedisCluster.getClusterNodes().values()) {
            AbstractJedisFacade.addMetrics((Pool<Jedis>)item, metrics);
        }
    }

    @Override
    public <T> RedisFacade.ResponseFacade<T> transaction(byte[] key, RedisFacade.TransactionRunner<T> transaction) {
        if (this.transactionOnKey) {
            return this.jedisCluster.transaction(key, transaction);
        }
        return this.jedisCluster.transaction(transaction);
    }

    public void setTransactionOnKey(boolean transactionOnKey) {
        this.transactionOnKey = transactionOnKey;
    }
}

