/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus.session.repository.redis;

import com.amadeus.session.repository.redis.AbstractRedisSessionRepositoryFactory;
import com.amadeus.session.repository.redis.JedisClusterFacade;
import com.amadeus.session.repository.redis.JedisPoolFacade;
import com.amadeus.session.repository.redis.RedisConfiguration;
import com.amadeus.session.repository.redis.RedisFacade;
import com.amadeus.session.repository.redis.TransactionalJedisCluster;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.util.Pool;

public class JedisSessionRepositoryFactory
extends AbstractRedisSessionRepositoryFactory {
    @Override
    protected RedisFacade getRedisFacade(RedisConfiguration config) {
        JedisPoolConfig poolConfig = JedisSessionRepositoryFactory.configurePool(config);
        switch (config.clusterMode) {
            case "SINGLE": {
                return this.singleInstance(poolConfig, config);
            }
            case "SENTINEL": {
                return this.sentinelFacade(poolConfig, config);
            }
            case "CLUSTER": {
                return this.clusterFacade(poolConfig, config);
            }
        }
        throw new IllegalArgumentException("Unsupported redis mode: " + config);
    }

    static JedisPoolConfig configurePool(RedisConfiguration config) {
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxTotal(Integer.parseInt(config.poolSize));
        poolConfig.setMaxIdle(Math.min(poolConfig.getMaxIdle(), poolConfig.getMaxTotal()));
        poolConfig.setMinIdle(Math.min(poolConfig.getMinIdle(), poolConfig.getMaxIdle()));
        return poolConfig;
    }

    private RedisFacade singleInstance(JedisPoolConfig poolConfig, RedisConfiguration config) {
        int port = Integer.parseInt(config.port);
        String[] serverAndPort = config.server.split(":");
        if (serverAndPort.length > 1) {
            port = Integer.parseInt(serverAndPort[1]);
        }
        return new JedisPoolFacade((Pool<Jedis>)new JedisPool((GenericObjectPoolConfig)poolConfig, config.server, port, config.timeout.intValue()));
    }

    RedisFacade sentinelFacade(JedisPoolConfig poolConfig, RedisConfiguration config) {
        return new JedisPoolFacade((Pool<Jedis>)new JedisSentinelPool(config.masterName, config.sentinels(), (GenericObjectPoolConfig)poolConfig, config.timeout.intValue()));
    }

    RedisFacade clusterFacade(JedisPoolConfig poolConfig, RedisConfiguration config) {
        return new JedisClusterFacade(new TransactionalJedisCluster(JedisSessionRepositoryFactory.jedisHostsAndPorts(config), config.timeout, poolConfig));
    }

    static Set<HostAndPort> jedisHostsAndPorts(RedisConfiguration config) {
        HashSet<HostAndPort> hostsAndPorts = new HashSet<HostAndPort>();
        for (RedisConfiguration.HostAndPort hp : config.hostsAndPorts()) {
            hostsAndPorts.add(new HostAndPort(hp.host, hp.port));
        }
        return hostsAndPorts;
    }
}

