/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus.session.repository.redis;

import com.amadeus.session.SessionConfiguration;
import com.amadeus.session.repository.redis.ExpirationStrategy;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisConfiguration {
    public static final String METRIC_PREFIX = "com.amadeus.session";
    public static final String REDIS_USE_IPV4 = "com.amadeus.session.redis.ipv4";
    public static final String REDIS_USE_IPV6 = "com.amadeus.session.redis.ipv6";
    public static final String REDIS_EXPIRATION_STRATEGY = "com.amadeus.session.redis.expiration";
    public static final String REDIS_TIMEOUT = "com.amadeus.session.redis.timeout";
    public static final String DEFAULT_REDIS_TIMEOUT = "2000";
    public static final String REDIS_PORT = "com.amadeus.session.redis.port";
    public static final String REDIS_HOST = "com.amadeus.session.redis.host";
    public static final String REDIS_POOL_SIZE = "com.amadeus.session.redis.pool";
    public static final String DEFAULT_REDIS_POOL_SIZE = "100";
    public static final String REDIS_CLUSTER_MODE = "com.amadeus.session.redis.mode";
    public static final String REDIS_MASTER_NAME = "com.amadeus.session.redis.master";
    public static final String DEFAULT_REDIS_MASTER_NAME = "com.amadeus.session";
    static final Logger logger = LoggerFactory.getLogger(RedisConfiguration.class);
    static final String POOL_SIZE_PROPERTY = "pool=";
    static final String CLUSTER_MODE_PROPERTY = "mode=";
    static final String MASTER_NAME_PROPERTY = "master=";
    static final String HOST_PROPERTY = "host=";
    static final String REDIS_PORT_PROPERTY = "port=";
    static final String EXPIRATION_PROPERTY = "expiration=";
    static final String TIMEOUT_PROPERTY = "timeout=";
    String clusterMode;
    String masterName;
    String server;
    String port;
    String poolSize;
    ExpirationStrategy strategy;
    Boolean supportIpV6;
    Boolean supportIpV4;
    Integer timeout = null;

    public ExpirationStrategy getStrategy() {
        return this.strategy;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public String getPoolSize() {
        return this.poolSize;
    }

    public RedisConfiguration(SessionConfiguration conf) {
        this.readConfigurationString(conf.getProviderConfiguration());
        this.serverAddress(conf);
        if (this.masterName == null) {
            this.masterName = conf.getAttribute(REDIS_MASTER_NAME, "com.amadeus.session");
        }
        if (this.clusterMode == null) {
            this.clusterMode = conf.getAttribute(REDIS_CLUSTER_MODE, "SINGLE");
        }
        this.ipSupport(conf);
        if (this.poolSize == null) {
            this.poolSize = conf.getAttribute(REDIS_POOL_SIZE, DEFAULT_REDIS_POOL_SIZE);
        }
        if (this.strategy == null) {
            String expirationStrategy = conf.getAttribute(REDIS_EXPIRATION_STRATEGY, "NOTIF");
            try {
                this.strategy = ExpirationStrategy.valueOf(expirationStrategy);
            }
            catch (IllegalArgumentException e) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Unknown expiration strategy. Got: `{}`, supported: {}, Excepion: {}", new Object[]{expirationStrategy, Arrays.asList(ExpirationStrategy.values()), e});
                }
                this.strategy = ExpirationStrategy.NOTIF;
            }
        }
        if (this.timeout == null) {
            this.timeout = Integer.parseInt(conf.getAttribute(REDIS_TIMEOUT, DEFAULT_REDIS_TIMEOUT));
        }
        logger.info("Redis configuration: {}", (Object)this);
    }

    private void serverAddress(SessionConfiguration conf) {
        if (this.server == null) {
            this.server = conf.getAttribute(REDIS_HOST, "localhost");
        }
        if (this.port == null) {
            this.port = conf.getAttribute(REDIS_PORT, "6379");
        }
    }

    private void ipSupport(SessionConfiguration conf) {
        if (this.supportIpV4 == null) {
            this.supportIpV4 = Boolean.valueOf(conf.getAttribute(REDIS_USE_IPV4, "true"));
        }
        if (this.supportIpV6 == null) {
            this.supportIpV6 = Boolean.valueOf(conf.getAttribute(REDIS_USE_IPV6, "false"));
        }
    }

    private void readConfigurationString(String conf) {
        if (conf != null) {
            String[] args;
            for (String arg : args = conf.split(",")) {
                this.parseArgFromConfiguration(arg.trim());
            }
        }
    }

    private void parseArgFromConfiguration(String arg) {
        if (arg.startsWith(POOL_SIZE_PROPERTY)) {
            this.poolSize = arg.substring(POOL_SIZE_PROPERTY.length());
        } else if (arg.startsWith(REDIS_PORT_PROPERTY)) {
            this.port = arg.substring(REDIS_PORT_PROPERTY.length());
        } else if (arg.startsWith(CLUSTER_MODE_PROPERTY)) {
            this.clusterMode = arg.substring(CLUSTER_MODE_PROPERTY.length());
        } else if (arg.startsWith(HOST_PROPERTY)) {
            this.server = arg.substring(HOST_PROPERTY.length());
        } else if (arg.startsWith(MASTER_NAME_PROPERTY)) {
            this.masterName = arg.substring(MASTER_NAME_PROPERTY.length());
        } else if (arg.startsWith(EXPIRATION_PROPERTY)) {
            try {
                this.strategy = ExpirationStrategy.valueOf(arg.substring(EXPIRATION_PROPERTY.length()));
            }
            catch (IllegalArgumentException e) {
                logger.warn("Unknown expiration strategy. Got: `" + arg + "`, supported: " + Arrays.asList(ExpirationStrategy.values()), (Throwable)e);
            }
        } else if (arg.startsWith(TIMEOUT_PROPERTY)) {
            this.timeout = Integer.parseInt(arg.substring(TIMEOUT_PROPERTY.length()));
        }
    }

    public List<HostAndPort> hostsAndPorts() {
        ArrayList<HostAndPort> hostAndPort = new ArrayList<HostAndPort>();
        int defaultPort = Integer.parseInt(this.port);
        try {
            String[] servers;
            for (String aServer : servers = this.server.split("[/;]")) {
                String[] serverAndPort = aServer.split(":");
                int portToUse = this.portToUse(serverAndPort, defaultPort);
                this.collectHosts(hostAndPort, serverAndPort, portToUse);
            }
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Unable to resolve cluster host for configuration " + this, e);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Port paramter was in server configuration. Expecting numeric values, but it was not: " + this);
        }
        logger.debug("Resolved hosts from '{}':{} are {}", new Object[]{this.server, this.port, hostAndPort});
        return hostAndPort;
    }

    private void collectHosts(List<HostAndPort> hostAndPort, String[] serverAndPort, int portToUse) throws UnknownHostException {
        InetAddress[] hosts;
        for (InetAddress host : hosts = this.resolveServers(serverAndPort[0])) {
            if (!this.isIpSupported(host)) continue;
            hostAndPort.add(new HostAndPort(host.getHostAddress(), portToUse));
        }
    }

    private int portToUse(String[] serverAndPort, int defaultPort) {
        int currentPort = defaultPort;
        if (serverAndPort.length > 1) {
            currentPort = Integer.parseInt(serverAndPort[1]);
        }
        return currentPort;
    }

    private InetAddress[] resolveServers(String serverName) throws UnknownHostException {
        InetAddress[] hosts = InetAddress.getAllByName(serverName);
        if (logger.isInfoEnabled()) {
            logger.info("Resolved hosts from '{}', parsed={} resolved={}", new Object[]{this.server, serverName, Arrays.asList(hosts)});
        }
        return hosts;
    }

    private boolean isIpSupported(InetAddress host) {
        if (host instanceof Inet6Address) {
            return this.supportIpV6;
        }
        return this.supportIpV4;
    }

    Set<String> sentinels() {
        return new HashSet<String>(Arrays.asList(this.server.split("[/;]")));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RedisConfiguration [clusterMode=").append(this.clusterMode).append(", masterName=").append(this.masterName).append(", server=").append(this.server).append(", port=").append(this.port).append(", poolSize=").append(this.poolSize).append(", strategy=").append((Object)this.strategy).append(", supportIpV6=").append(this.supportIpV6).append(", supportIpV4=").append(this.supportIpV4).append(", timeout=").append(this.timeout).append("]");
        return builder.toString();
    }

    public static class HostAndPort {
        final String host;
        final int port;

        HostAndPort(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }
    }
}

