/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus.session.repository.redis;

import com.amadeus.session.SerializerDeserializer;
import com.amadeus.session.SessionData;
import com.amadeus.session.SessionManager;
import com.amadeus.session.SessionRepository;
import com.amadeus.session.repository.redis.ExpirationStrategy;
import com.amadeus.session.repository.redis.NotificationExpirationManagement;
import com.amadeus.session.repository.redis.RedisExpirationStrategy;
import com.amadeus.session.repository.redis.RedisFacade;
import com.amadeus.session.repository.redis.SafeEncoder;
import com.amadeus.session.repository.redis.SortedSetSessionExpirationManagement;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisSessionRepository
implements SessionRepository {
    private static final Logger logger = LoggerFactory.getLogger(RedisSessionRepository.class);
    static final String DEFAULT_SESSION_PREFIX = "com.amadeus.session:";
    static final byte[] LAST_ACCESSED = SafeEncoder.encode("#:lastAccessed");
    static final byte[] MAX_INACTIVE_INTERVAL = SafeEncoder.encode("#:maxInactiveInterval");
    static final byte[] CREATION_TIME = SafeEncoder.encode("#:creationTime");
    static final byte[] INVALID_SESSION = SafeEncoder.encode("#:invalidSession");
    static final byte[] OWNER_NODE = SafeEncoder.encode("#:owner");
    static final byte[] BYTES_TRUE = SafeEncoder.encode(String.valueOf(1));
    private static final byte[] INTERNAL_PREFIX = new byte[]{35, 58};
    private static final int CREATION_TIME_INDEX = 2;
    private static final int INVALID_SESSION_INDEX = 3;
    private static final int OWNER_NODE_INDEX = 4;
    private static final RedisFacade.ResponseFacade<String> OK_RESULT = new RedisFacade.ResponseFacade<String>(){

        @Override
        public String get() {
            return "OK";
        }
    };
    private static final int BITS_IN_BYTE = 8;
    private final String owner;
    private final byte[] ownerByteArray;
    private final String keyPrefix;
    private final byte[] keyPrefixByteArray;
    private byte[] redirectionsChannel;
    private final RedisFacade redis;
    final RedisExpirationStrategy expirationManager;
    private SessionManager sessionManager;
    private Meter failoverMetrics;
    private boolean sticky;
    private final String namespace;

    public RedisSessionRepository(RedisFacade redis, String namespace, String owner, ExpirationStrategy strategy, boolean sticky) {
        this.redis = redis;
        this.owner = owner;
        this.namespace = namespace;
        this.ownerByteArray = SafeEncoder.encode(owner);
        String keyPrefixWithoutClusterGroup = "com.amadeus.session::" + namespace + ":";
        this.keyPrefix = keyPrefixWithoutClusterGroup + "{";
        this.keyPrefixByteArray = SafeEncoder.encode(this.keyPrefix);
        this.redirectionsChannel = SafeEncoder.encode(keyPrefixWithoutClusterGroup + "redirection");
        this.sticky = sticky;
        if (strategy == ExpirationStrategy.ZRANGE) {
            logger.info("Using ZRANGE (SortedSet) expiration managment");
            this.expirationManager = new SortedSetSessionExpirationManagement(redis, this, namespace, sticky, owner);
        } else {
            logger.info("Using notification expiration managment");
            this.expirationManager = new NotificationExpirationManagement(redis, this, namespace, owner, keyPrefixWithoutClusterGroup, sticky);
        }
    }

    @Override
    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
        MetricRegistry metrics = sessionManager.getMetrics();
        if (metrics != null) {
            metrics.removeMatching(new MetricFilter(){

                public boolean matches(String name, Metric metric) {
                    return name.startsWith(MetricRegistry.name((String)"com.amadeus.session", (String[])new String[]{"redis"}));
                }
            });
            if (this.sticky) {
                this.failoverMetrics = metrics.meter(MetricRegistry.name((String)"com.amadeus.session", (String[])new String[]{this.namespace, "redis", "failover"}));
            }
            this.redis.startMonitoring(metrics);
        }
        this.expirationManager.startExpiredSessionsTask(sessionManager);
    }

    @Override
    public SessionData getSessionData(String id) {
        byte[] prevOwnerBuffer;
        List<byte[]> values;
        byte[] key = this.sessionKey(id);
        List<byte[]> list = values = this.sticky ? this.redis.hmget(key, LAST_ACCESSED, MAX_INACTIVE_INTERVAL, CREATION_TIME, INVALID_SESSION, OWNER_NODE) : this.redis.hmget(key, LAST_ACCESSED, MAX_INACTIVE_INTERVAL, CREATION_TIME, INVALID_SESSION);
        if (!this.checkConsistent(id, values)) {
            return null;
        }
        long lastAccessed = RedisSessionRepository.longFrom(values.get(0));
        long creationTime = RedisSessionRepository.longFrom(values.get(2));
        String previousOwner = null;
        if (this.sticky && (prevOwnerBuffer = values.get(4)) != null && !(previousOwner = SafeEncoder.encode(prevOwnerBuffer)).equals(this.owner)) {
            logger.info("Retrieved session {}, last node {} to this node {}", new Object[]{id, previousOwner, this.owner});
            if (this.failoverMetrics != null) {
                this.failoverMetrics.mark();
            }
        }
        return new SessionData(id, lastAccessed, RedisSessionRepository.intFrom(values.get(1)), creationTime, previousOwner);
    }

    private boolean checkConsistent(String sessionId, List<byte[]> values) {
        byte[] invalidSessionFlag = values.get(3);
        if (invalidSessionFlag != null && invalidSessionFlag.length == 1 && invalidSessionFlag[0] == 1) {
            return false;
        }
        if (values.get(0) == null || values.get(1) == null) {
            if (values.get(0) != null || values.get(1) != null) {
                logger.warn("Session in redis repository is not consistent for sessionId: '{}' One of last accessed (index 0 in array), max inactive interval (index 1 in array) was null: {}", (Object)sessionId, values);
            }
            return false;
        }
        return true;
    }

    private static int intFrom(byte[] b) {
        return ByteBuffer.wrap(b).getInt();
    }

    private static long longFrom(byte[] b) {
        return ByteBuffer.wrap(b).getLong();
    }

    private static void addLong(Map<byte[], byte[]> attributes, byte[] attr, long value) {
        ByteBuffer b = ByteBuffer.allocate(8);
        b.putLong(value);
        attributes.put(attr, b.array());
    }

    private static void addInt(Map<byte[], byte[]> attributes, byte[] attr, int value) {
        ByteBuffer b = ByteBuffer.allocate(4);
        b.putInt(value);
        attributes.put(attr, b.array());
    }

    @Override
    public SessionRepository.CommitTransaction startCommit(SessionData session) {
        return new RedisSessionTransaction(session);
    }

    @Override
    public void remove(SessionData session) {
        this.redis.del(new byte[][]{this.sessionKey(session.getId())});
        this.expirationManager.sessionDeleted(session);
    }

    public byte[] sessionKey(String sessionId) {
        return SafeEncoder.encode(new StringBuilder(this.keyPrefix.length() + sessionId.length() + 1).append(this.keyPrefix).append(sessionId).append('}').toString());
    }

    private byte[] sessionKey(SessionData session) {
        return this.sessionKey(session.getId());
    }

    @Override
    public Object getSessionAttribute(SessionData session, String attribute) {
        List<byte[]> values = this.redis.hmget(this.sessionKey(session), new byte[][]{SafeEncoder.encode(attribute)});
        return this.serializerDeserializer().deserialize(values.get(0));
    }

    static boolean hasInternalPrefix(byte[] buf) {
        if (buf != null && buf.length > INTERNAL_PREFIX.length) {
            for (int i = 0; i < INTERNAL_PREFIX.length; ++i) {
                if (INTERNAL_PREFIX[i] == buf[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    byte[] getSessionKey(byte[] session) {
        int prefixLength = this.keyPrefixByteArray.length;
        byte[] copy = Arrays.copyOf(this.keyPrefixByteArray, prefixLength + session.length + 1);
        for (int i = 0; i < session.length; ++i) {
            copy[prefixLength + i] = session[i];
        }
        copy[prefixLength + session.length] = 125;
        return copy;
    }

    @Override
    public boolean prepareRemove(SessionData session) {
        Long result = this.redis.hsetnx(this.sessionKey(session.getId()), INVALID_SESSION, BYTES_TRUE);
        return result.intValue() == 1;
    }

    @Override
    public Set<String> getAllKeys(SessionData session) {
        HashSet<String> keys = new HashSet<String>();
        for (byte[] key : this.redis.hkeys(this.sessionKey(session))) {
            if (RedisSessionRepository.hasInternalPrefix(key)) continue;
            keys.add(SafeEncoder.encode(key));
        }
        return Collections.unmodifiableSet(keys);
    }

    @Override
    public void storeSessionData(SessionData sessionData) {
        HashMap<byte[], byte[]> attributes = new HashMap<byte[], byte[]>();
        RedisSessionRepository.addInt(attributes, MAX_INACTIVE_INTERVAL, sessionData.getMaxInactiveInterval());
        RedisSessionRepository.addLong(attributes, LAST_ACCESSED, sessionData.getLastAccessedTime());
        RedisSessionRepository.addLong(attributes, CREATION_TIME, sessionData.getCreationTime());
        if (this.sessionManager.getConfiguration().isSticky()) {
            attributes.put(OWNER_NODE, this.ownerByteArray);
        }
        this.redis.hmset(this.sessionKey(sessionData.getId()), attributes);
        this.expirationManager.sessionTouched(sessionData);
    }

    @Override
    public void requestFinished() {
        this.redis.requestFinished();
    }

    @Override
    public void setSessionAttribute(SessionData session, String name, Object value) {
        this.redis.hset(this.sessionKey(session), SafeEncoder.encode(name), this.serializerDeserializer().serialize(value));
    }

    private SerializerDeserializer serializerDeserializer() {
        return this.sessionManager.getSerializerDeserializer();
    }

    @Override
    public void removeSessionAttribute(SessionData session, String name) {
        this.redis.hdel(this.sessionKey(session), new byte[][]{SafeEncoder.encode(name)});
    }

    @Override
    public boolean cleanSessionsOnShutdown() {
        return false;
    }

    @Override
    public Collection<String> getOwnedSessionIds() {
        throw new UnsupportedOperationException("Redis repository doesn't support retrieval of session ids owned by node.");
    }

    @Override
    public void close() {
        this.redis.close();
        this.expirationManager.close();
    }

    RedisFacade getRedis() {
        return this.redis;
    }

    static String extractSessionId(String body) {
        int braceClosing;
        int beginIndex = body.lastIndexOf(58) + 1;
        String sessionId = body.substring(beginIndex);
        int braceOpening = sessionId.indexOf(123);
        if (braceOpening >= 0 && (braceClosing = sessionId.indexOf(125, braceOpening + 1)) > braceOpening) {
            int idLen = sessionId.length();
            StringBuilder sb = new StringBuilder(idLen - 2);
            if (braceOpening > 0) {
                sb.append(sessionId, 0, braceOpening);
            }
            sb.append(sessionId, braceOpening + 1, braceClosing).append(sessionId, braceClosing + 1, idLen);
            sessionId = sb.toString();
        }
        return sessionId;
    }

    @Override
    public void sessionIdChange(SessionData sessionData) {
        this.redis.rename(this.sessionKey(sessionData.getOldSessionId()), this.sessionKey(sessionData.getId()));
        this.redis.publish(this.redirectionsChannel, SafeEncoder.encode(sessionData.getOldSessionId() + ':' + sessionData.getId()));
        this.expirationManager.sessionIdChange(sessionData);
    }

    class RedisSessionTransaction
    implements SessionRepository.CommitTransaction,
    RedisFacade.TransactionRunner<String> {
        private Map<byte[], byte[]> attributes = new HashMap<byte[], byte[]>();
        private List<byte[]> toRemove = new ArrayList<byte[]>();
        private byte[] key;
        private SessionData session;

        RedisSessionTransaction(SessionData session) {
            this.key = RedisSessionRepository.this.sessionKey(session.getId());
            this.session = session;
        }

        @Override
        public void addAttribute(String attribute, Object value) {
            this.attributes.put(SafeEncoder.encode(attribute), RedisSessionRepository.this.serializerDeserializer().serialize(value));
        }

        @Override
        public void removeAttribute(String attribute) {
            this.toRemove.add(SafeEncoder.encode(attribute));
        }

        @Override
        public void commit() {
            if (this.session.isNew()) {
                RedisSessionRepository.addLong(this.attributes, CREATION_TIME, this.session.getCreationTime());
            }
            int maxInactiveInterval = this.session.getMaxInactiveInterval();
            RedisSessionRepository.addInt(this.attributes, MAX_INACTIVE_INTERVAL, maxInactiveInterval);
            RedisSessionRepository.addLong(this.attributes, LAST_ACCESSED, this.session.getLastAccessedTime());
            if (RedisSessionRepository.this.sessionManager.getConfiguration().isSticky()) {
                this.attributes.put(OWNER_NODE, RedisSessionRepository.this.ownerByteArray);
            }
            RedisSessionRepository.this.getRedis().transaction(this.key, this);
            RedisSessionRepository.this.expirationManager.sessionTouched(this.session);
        }

        @Override
        public RedisFacade.ResponseFacade<String> run(RedisFacade.TransactionFacade transaction) {
            if (!this.toRemove.isEmpty()) {
                byte[][] arr = (byte[][])this.toRemove.toArray((T[])new byte[0][]);
                transaction.hdel(this.key, arr);
            }
            if (!this.attributes.isEmpty()) {
                transaction.hmset(this.key, this.attributes);
            }
            return OK_RESULT;
        }

        @Override
        public boolean isSetAllAttributes() {
            return false;
        }

        @Override
        public boolean isDistributing() {
            return true;
        }
    }
}

