/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus.session.repository.redis;

import com.amadeus.session.SessionData;
import com.amadeus.session.SessionManager;
import com.amadeus.session.repository.redis.RedisExpirationStrategy;
import com.amadeus.session.repository.redis.RedisFacade;
import com.amadeus.session.repository.redis.RedisSessionRepository;
import com.amadeus.session.repository.redis.SafeEncoder;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SortedSetSessionExpirationManagement
implements RedisExpirationStrategy {
    private static Logger logger = LoggerFactory.getLogger((String)SortedSetSessionExpirationManagement.class.getName());
    static final String ALLSESSIONS_KEY = "com.amadeus.session:all-sessions-set:";
    static final int SESSION_PERSISTENCE_SAFETY_MARGIN = (int)TimeUnit.MINUTES.toSeconds(5L);
    private static final long SESSION_PERSISTENCE_SAFETY_MARGIN_MILLIS = TimeUnit.MINUTES.toMillis(5L);
    private static final Long ONE = 1L;
    private static final int REGULAR_CLEANUP_INTERVAL = 10;
    private final RedisFacade redis;
    private final RedisSessionRepository repository;
    private final byte[] sessionToExpireKey;
    private final boolean sticky;
    private ScheduledFuture<?> cleanupFuture;
    private final String owner;
    private final byte[] ownerAsBytes;

    SortedSetSessionExpirationManagement(RedisFacade redis, RedisSessionRepository redisSession, String namespace, boolean sticky, String owner) {
        this.redis = redis;
        this.repository = redisSession;
        this.sessionToExpireKey = SafeEncoder.encode(ALLSESSIONS_KEY + namespace);
        this.sticky = sticky;
        this.owner = owner;
        this.ownerAsBytes = owner != null ? SafeEncoder.encode(owner) : null;
    }

    @Override
    public void sessionDeleted(SessionData session) {
        if (this.sticky && session.getPreviousOwner() != null && !this.owner.equals(session.getPreviousOwner())) {
            this.redis.zrem(this.sessionToExpireKey, new byte[][]{SafeEncoder.encode(session.getId() + ":" + session.getPreviousOwner())});
        }
        this.redis.zrem(this.sessionToExpireKey, new byte[][]{this.sortedSetElem(session.getId())});
    }

    private byte[] sortedSetElem(String id) {
        if (!this.sticky) {
            return SafeEncoder.encode(id);
        }
        return this.sortedSetOwnerElem(id);
    }

    private byte[] sortedSetOwnerElem(String id) {
        return SafeEncoder.encode(id + ":" + this.owner);
    }

    @Override
    public void sessionTouched(SessionData session) {
        byte[] sessionKey = this.repository.sessionKey(session.getId());
        int sessionExpireInSeconds = session.getMaxInactiveInterval();
        if (sessionExpireInSeconds <= 0) {
            this.redis.persist(sessionKey);
            this.redis.zadd(this.sessionToExpireKey, Double.MAX_VALUE, this.sortedSetElem(session.getId()));
        } else {
            this.redis.zadd(this.sessionToExpireKey, session.expiresAt(), this.sortedSetElem(session.getId()));
            this.redis.expire(sessionKey, sessionExpireInSeconds + SESSION_PERSISTENCE_SAFETY_MARGIN);
        }
    }

    @Override
    public void startExpiredSessionsTask(SessionManager sessionManager) {
        CleanupTask task = new CleanupTask(sessionManager);
        long interval = Math.min(sessionManager.getConfiguration().getMaxInactiveInterval() / 10 + 1, 10);
        if (interval <= 0L) {
            interval = 10L;
        }
        logger.debug("Cleanup interval for sessions is {}", (Object)interval);
        this.cleanupFuture = sessionManager.schedule("redis.expiration-cleanup", task, interval);
    }

    private boolean sessionOwned(byte[] session) {
        if (!this.sticky) {
            return false;
        }
        if (session.length < this.ownerAsBytes.length + 1) {
            return false;
        }
        int i = this.ownerAsBytes.length - 1;
        int j = session.length - 1;
        while (i >= 0) {
            if (session[j] != this.ownerAsBytes[i]) {
                return false;
            }
            --i;
            --j;
        }
        return session[session.length - this.ownerAsBytes.length - 1] == 58;
    }

    @Override
    public void close() {
        if (this.cleanupFuture != null) {
            this.cleanupFuture.cancel(true);
            this.cleanupFuture = null;
        }
    }

    @Override
    public void sessionIdChange(SessionData sessionData) {
        this.redis.zrem(this.sessionToExpireKey, new byte[][]{this.sortedSetElem(sessionData.getOldSessionId())});
        this.redis.zadd(this.sessionToExpireKey, sessionData.expiresAt(), this.sortedSetElem(sessionData.getId()));
    }

    final class CleanupTask
    implements Runnable {
        private final SessionManager sessionManager;

        CleanupTask(SessionManager sessionManager) {
            this.sessionManager = sessionManager;
        }

        @Override
        public void run() {
            long now = System.currentTimeMillis();
            long start = SortedSetSessionExpirationManagement.this.sticky ? now - SESSION_PERSISTENCE_SAFETY_MARGIN_MILLIS : 0L;
            logger.debug("Cleaning up sessions expiring at {}", (Object)now);
            this.expireSessions(start, now, !SortedSetSessionExpirationManagement.this.sticky);
            if (SortedSetSessionExpirationManagement.this.sticky) {
                this.expireSessions(0L, start, true);
            }
        }

        private void expireSessions(long start, long end, boolean forceExpire) {
            Set<byte[]> sessionsToExpire = SortedSetSessionExpirationManagement.this.redis.zrangeByScore(SortedSetSessionExpirationManagement.this.sessionToExpireKey, start, end);
            if (sessionsToExpire != null && !sessionsToExpire.isEmpty()) {
                for (byte[] session : sessionsToExpire) {
                    if (!forceExpire && !SortedSetSessionExpirationManagement.this.sessionOwned(session) || !ONE.equals(SortedSetSessionExpirationManagement.this.redis.zrem(SortedSetSessionExpirationManagement.this.sessionToExpireKey, new byte[][]{session}))) continue;
                    String sessionId = this.extractSessionId(session);
                    logger.debug("Starting cleanup of session '{}'", (Object)sessionId);
                    this.sessionManager.delete(sessionId, true);
                }
            }
        }

        private String extractSessionId(byte[] session) {
            if (SortedSetSessionExpirationManagement.this.sticky) {
                for (int i = 0; i < session.length; ++i) {
                    if (session[i] != 58) continue;
                    return SafeEncoder.encode(session, 0, i);
                }
                if (logger.isWarnEnabled()) {
                    logger.warn("Unable to retrieve session id from expire key {}", (Object)SafeEncoder.encode(session));
                }
            }
            return SafeEncoder.encode(session);
        }
    }
}

