/*
 * Decompiled with CFR 0.152.
 */
package com.amadeus.session.servlet;

import com.amadeus.session.servlet.SessionHelpersFacade;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class SessionFilter
implements Filter {
    ServletContext servletContext;

    public void init(FilterConfig config) {
        this.initForSession(config);
    }

    public void initForSession(FilterConfig config) {
        if (this.servletContext == null) {
            this.servletContext = config.getServletContext();
            SessionHelpersFacade.initSessionManagement(this.servletContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest originalRequest, ServletResponse originalResponse, FilterChain chain) throws IOException, ServletException {
        ServletRequest request = SessionHelpersFacade.prepareRequest(originalRequest, originalResponse, this.servletContext);
        ServletResponse response = SessionHelpersFacade.prepareResponse(request, originalResponse, this.servletContext);
        try {
            chain.doFilter(request, response);
        }
        finally {
            SessionHelpersFacade.commitRequest(request, originalRequest, this.servletContext);
        }
    }

    public void destroy() {
    }
}

