/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreateVolumePermissionModifications;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.OperationType;
import com.amazonaws.services.ec2.model.SnapshotAttributeName;
import com.amazonaws.services.ec2.model.transform.ModifySnapshotAttributeRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ModifySnapshotAttributeRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<ModifySnapshotAttributeRequest> {
    private String snapshotId;
    private String attribute;
    private String operationType;
    private SdkInternalList<String> userIds;
    private SdkInternalList<String> groupNames;
    private CreateVolumePermissionModifications createVolumePermission;

    public ModifySnapshotAttributeRequest() {
    }

    public ModifySnapshotAttributeRequest(String snapshotId, String attribute, String operationType) {
        this.setSnapshotId(snapshotId);
        this.setAttribute(attribute);
        this.setOperationType(operationType);
    }

    public ModifySnapshotAttributeRequest(String snapshotId, SnapshotAttributeName attribute, OperationType operationType) {
        this.setSnapshotId(snapshotId);
        this.setAttribute(attribute.toString());
        this.setOperationType(operationType.toString());
    }

    public void setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public ModifySnapshotAttributeRequest withSnapshotId(String snapshotId) {
        this.setSnapshotId(snapshotId);
        return this;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public ModifySnapshotAttributeRequest withAttribute(String attribute) {
        this.setAttribute(attribute);
        return this;
    }

    public void setAttribute(SnapshotAttributeName attribute) {
        this.attribute = attribute.toString();
    }

    public ModifySnapshotAttributeRequest withAttribute(SnapshotAttributeName attribute) {
        this.setAttribute(attribute);
        return this;
    }

    public void setOperationType(String operationType) {
        this.operationType = operationType;
    }

    public String getOperationType() {
        return this.operationType;
    }

    public ModifySnapshotAttributeRequest withOperationType(String operationType) {
        this.setOperationType(operationType);
        return this;
    }

    public void setOperationType(OperationType operationType) {
        this.operationType = operationType.toString();
    }

    public ModifySnapshotAttributeRequest withOperationType(OperationType operationType) {
        this.setOperationType(operationType);
        return this;
    }

    public List<String> getUserIds() {
        if (this.userIds == null) {
            this.userIds = new SdkInternalList();
        }
        return this.userIds;
    }

    public void setUserIds(Collection<String> userIds) {
        if (userIds == null) {
            this.userIds = null;
            return;
        }
        this.userIds = new SdkInternalList(userIds);
    }

    public ModifySnapshotAttributeRequest withUserIds(String ... userIds) {
        if (this.userIds == null) {
            this.setUserIds((Collection<String>)new SdkInternalList(userIds.length));
        }
        for (String ele : userIds) {
            this.userIds.add((Object)ele);
        }
        return this;
    }

    public ModifySnapshotAttributeRequest withUserIds(Collection<String> userIds) {
        this.setUserIds(userIds);
        return this;
    }

    public List<String> getGroupNames() {
        if (this.groupNames == null) {
            this.groupNames = new SdkInternalList();
        }
        return this.groupNames;
    }

    public void setGroupNames(Collection<String> groupNames) {
        if (groupNames == null) {
            this.groupNames = null;
            return;
        }
        this.groupNames = new SdkInternalList(groupNames);
    }

    public ModifySnapshotAttributeRequest withGroupNames(String ... groupNames) {
        if (this.groupNames == null) {
            this.setGroupNames((Collection<String>)new SdkInternalList(groupNames.length));
        }
        for (String ele : groupNames) {
            this.groupNames.add((Object)ele);
        }
        return this;
    }

    public ModifySnapshotAttributeRequest withGroupNames(Collection<String> groupNames) {
        this.setGroupNames(groupNames);
        return this;
    }

    public void setCreateVolumePermission(CreateVolumePermissionModifications createVolumePermission) {
        this.createVolumePermission = createVolumePermission;
    }

    public CreateVolumePermissionModifications getCreateVolumePermission() {
        return this.createVolumePermission;
    }

    public ModifySnapshotAttributeRequest withCreateVolumePermission(CreateVolumePermissionModifications createVolumePermission) {
        this.setCreateVolumePermission(createVolumePermission);
        return this;
    }

    @Override
    public Request<ModifySnapshotAttributeRequest> getDryRunRequest() {
        Request<ModifySnapshotAttributeRequest> request = new ModifySnapshotAttributeRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSnapshotId() != null) {
            sb.append("SnapshotId: " + this.getSnapshotId() + ",");
        }
        if (this.getAttribute() != null) {
            sb.append("Attribute: " + this.getAttribute() + ",");
        }
        if (this.getOperationType() != null) {
            sb.append("OperationType: " + this.getOperationType() + ",");
        }
        if (this.getUserIds() != null) {
            sb.append("UserIds: " + this.getUserIds() + ",");
        }
        if (this.getGroupNames() != null) {
            sb.append("GroupNames: " + this.getGroupNames() + ",");
        }
        if (this.getCreateVolumePermission() != null) {
            sb.append("CreateVolumePermission: " + this.getCreateVolumePermission());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifySnapshotAttributeRequest)) {
            return false;
        }
        ModifySnapshotAttributeRequest other = (ModifySnapshotAttributeRequest)obj;
        if (other.getSnapshotId() == null ^ this.getSnapshotId() == null) {
            return false;
        }
        if (other.getSnapshotId() != null && !other.getSnapshotId().equals(this.getSnapshotId())) {
            return false;
        }
        if (other.getAttribute() == null ^ this.getAttribute() == null) {
            return false;
        }
        if (other.getAttribute() != null && !other.getAttribute().equals(this.getAttribute())) {
            return false;
        }
        if (other.getOperationType() == null ^ this.getOperationType() == null) {
            return false;
        }
        if (other.getOperationType() != null && !other.getOperationType().equals(this.getOperationType())) {
            return false;
        }
        if (other.getUserIds() == null ^ this.getUserIds() == null) {
            return false;
        }
        if (other.getUserIds() != null && !other.getUserIds().equals(this.getUserIds())) {
            return false;
        }
        if (other.getGroupNames() == null ^ this.getGroupNames() == null) {
            return false;
        }
        if (other.getGroupNames() != null && !other.getGroupNames().equals(this.getGroupNames())) {
            return false;
        }
        if (other.getCreateVolumePermission() == null ^ this.getCreateVolumePermission() == null) {
            return false;
        }
        return other.getCreateVolumePermission() == null || other.getCreateVolumePermission().equals(this.getCreateVolumePermission());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSnapshotId() == null ? 0 : this.getSnapshotId().hashCode());
        hashCode = 31 * hashCode + (this.getAttribute() == null ? 0 : this.getAttribute().hashCode());
        hashCode = 31 * hashCode + (this.getOperationType() == null ? 0 : this.getOperationType().hashCode());
        hashCode = 31 * hashCode + (this.getUserIds() == null ? 0 : this.getUserIds().hashCode());
        hashCode = 31 * hashCode + (this.getGroupNames() == null ? 0 : this.getGroupNames().hashCode());
        hashCode = 31 * hashCode + (this.getCreateVolumePermission() == null ? 0 : this.getCreateVolumePermission().hashCode());
        return hashCode;
    }

    public ModifySnapshotAttributeRequest clone() {
        return (ModifySnapshotAttributeRequest)super.clone();
    }
}

