/*
 * Decompiled with CFR 0.152.
 */
package com.anji.plus.gaea.annotation.enabled;

import com.anji.plus.gaea.annotation.condition.ConditionalOnGaeaComponent;
import com.anji.plus.gaea.annotation.enabled.EnabledGaeaConfiguration;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.env.Environment;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.CollectionUtils;

public class GaeaConfigurationImportSelector
implements ImportSelector,
EnvironmentAware {
    private Logger logger = LoggerFactory.getLogger(GaeaConfigurationImportSelector.class);
    private Environment environment;

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public String[] selectImports(AnnotationMetadata importingClassMetadata) {
        List list = SpringFactoriesLoader.loadFactoryNames(EnabledGaeaConfiguration.class, (ClassLoader)GaeaConfigurationImportSelector.class.getClassLoader());
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new String[0];
        }
        List<String> importAutoConfigurations = list.stream().filter(className -> {
            try {
                Class<?> gaeaExtensionClass = Class.forName(className);
                return gaeaExtensionClass.isAnnotationPresent(ConditionalOnGaeaComponent.class);
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }).collect(Collectors.toList());
        this.logger.info("\u76d6\u4e9a\u88c5\u8f7d\u7684\u7ec4\u4ef6\uff1a{}", importAutoConfigurations);
        return importAutoConfigurations.toArray(new String[0]);
    }
}

