/*
 * Decompiled with CFR 0.152.
 */
package com.anji.plus.gaea.cache;

import com.anji.plus.gaea.cache.CacheHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.BoundSetOperations;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.CollectionUtils;

public class RedisCacheHelper
implements CacheHelper {
    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Override
    public String stringGet(String key) {
        String regKey = this.regKey(key);
        if (StringUtils.isBlank((CharSequence)regKey)) {
            return "";
        }
        BoundValueOperations operations = this.stringRedisTemplate.boundValueOps((Object)regKey);
        return (String)operations.get();
    }

    @Override
    public Boolean setIfAbsent(String key, String value) {
        String regKey = this.regKey(key);
        if (StringUtils.isBlank((CharSequence)regKey)) {
            return false;
        }
        BoundValueOperations operations = this.stringRedisTemplate.boundValueOps((Object)regKey);
        return operations.setIfAbsent((Object)value);
    }

    @Override
    public Long increment(String key) {
        BoundValueOperations operations = this.stringRedisTemplate.boundValueOps((Object)key);
        return operations.increment();
    }

    @Override
    public void expire(String key, TimeUnit timeUnit, Long timeout) {
        this.stringRedisTemplate.expire((Object)key, timeout.longValue(), timeUnit);
    }

    @Override
    public Long increment(String key, Long step) {
        BoundValueOperations operations = this.stringRedisTemplate.boundValueOps((Object)key);
        return operations.increment(step.longValue());
    }

    @Override
    public boolean exist(String key) {
        return this.stringRedisTemplate.hasKey((Object)key);
    }

    @Override
    public Set<String> keys(String pattern) {
        return this.stringRedisTemplate.keys((Object)pattern);
    }

    @Override
    public void stringSet(String key, String value) {
        String regKey = this.regKey(key);
        if (StringUtils.isBlank((CharSequence)regKey)) {
            return;
        }
        BoundValueOperations operations = this.stringRedisTemplate.boundValueOps((Object)regKey);
        operations.set((Object)value);
    }

    @Override
    public void stringSetExpire(String key, String value, long time, TimeUnit timeUnit) {
        String regKey = this.regKey(key);
        if (StringUtils.isBlank((CharSequence)regKey)) {
            return;
        }
        BoundValueOperations operations = this.stringRedisTemplate.boundValueOps((Object)regKey);
        operations.set((Object)value, time, timeUnit);
    }

    @Override
    public void stringSetExpire(String key, String value, long seconds) {
        this.stringSetExpire(key, value, seconds, TimeUnit.SECONDS);
    }

    @Override
    public Map<String, String> hashGet(String key) {
        BoundHashOperations operations = this.stringRedisTemplate.boundHashOps((Object)key);
        return operations.entries();
    }

    @Override
    public String hashGetString(String key, String hashKey) {
        String regKey = this.regKey(key);
        if (StringUtils.isBlank((CharSequence)regKey)) {
            return "";
        }
        String regHashKey = this.regKey(hashKey);
        if (StringUtils.isBlank((CharSequence)regHashKey)) {
            return "";
        }
        BoundHashOperations operations = this.stringRedisTemplate.boundHashOps((Object)regKey);
        if (hashKey.contains(",")) {
            String[] split = hashKey.split(",");
            String reduce = Arrays.stream(split).reduce("", (all, item) -> {
                all = StringUtils.isBlank((CharSequence)all) ? (String)operations.get(item) : all + "," + (String)operations.get(item);
                return all;
            });
            return reduce;
        }
        return (String)operations.entries().get(regHashKey);
    }

    @Override
    public void hashDel(String key, String hashKey) {
        String regKey = this.regKey(key);
        if (StringUtils.isBlank((CharSequence)regKey)) {
            return;
        }
        String regHashKey = this.regKey(hashKey);
        if (StringUtils.isBlank((CharSequence)regHashKey)) {
            return;
        }
        BoundHashOperations operations = this.stringRedisTemplate.boundHashOps((Object)regKey);
        operations.delete(new Object[]{regHashKey});
    }

    @Override
    public void hashBatchDel(String key, Set<String> hashKeys) {
        String regKey = this.regKey(key);
        if (StringUtils.isBlank((CharSequence)regKey)) {
            return;
        }
        BoundHashOperations operations = this.stringRedisTemplate.boundHashOps((Object)regKey);
        operations.delete((Object[])hashKeys.toArray(new String[0]));
    }

    @Override
    public boolean hashExist(String key, String hashKey) {
        String regKey = this.regKey(key);
        if (StringUtils.isBlank((CharSequence)regKey)) {
            return false;
        }
        String regHashKey = this.regKey(hashKey);
        if (StringUtils.isBlank((CharSequence)regHashKey)) {
            return false;
        }
        BoundHashOperations operations = this.stringRedisTemplate.boundHashOps((Object)regKey);
        return operations.hasKey((Object)regHashKey);
    }

    @Override
    public boolean hashAnyExist(String key, String[] hashKeys) {
        String regKey = this.regKey(key);
        if (StringUtils.isBlank((CharSequence)regKey)) {
            return false;
        }
        BoundHashOperations operations = this.stringRedisTemplate.boundHashOps((Object)regKey);
        for (String hashKey : hashKeys) {
            if (!operations.hasKey((Object)hashKey).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void hashSet(String key, String hashKey, String hashValue) {
        String regKey = this.regKey(key);
        if (StringUtils.isBlank((CharSequence)regKey) || StringUtils.isBlank((CharSequence)hashKey)) {
            return;
        }
        String regHashKey = this.regKey(hashKey);
        if (StringUtils.isBlank((CharSequence)regHashKey)) {
            return;
        }
        BoundHashOperations operations = this.stringRedisTemplate.boundHashOps((Object)regKey);
        operations.put((Object)regHashKey, (Object)hashValue);
    }

    @Override
    public void hashSet(String key, Map<String, String> hash) {
        String regKey = this.regKey(key);
        if (StringUtils.isBlank((CharSequence)regKey)) {
            return;
        }
        if (CollectionUtils.isEmpty(hash)) {
            return;
        }
        BoundHashOperations operations = this.stringRedisTemplate.boundHashOps((Object)regKey);
        operations.putAll(hash);
    }

    @Override
    public boolean delete(String key) {
        String regKey = this.regKey(key);
        if (StringUtils.isBlank((CharSequence)regKey)) {
            return false;
        }
        return this.stringRedisTemplate.delete((Object)key);
    }

    @Override
    public boolean delete(List<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return false;
        }
        Long count = this.stringRedisTemplate.delete(keys);
        return count > 0L;
    }

    @Override
    public Long setAdd(String key, String[] values) {
        return this.setAdd(key, values, false);
    }

    @Override
    public Long setAdd(String key, String[] values, boolean clear) {
        if (clear) {
            this.stringRedisTemplate.delete((Object)key);
        }
        if (values != null && values.length == 0) {
            return 0L;
        }
        BoundSetOperations setOperations = this.stringRedisTemplate.boundSetOps((Object)key);
        return setOperations.add((Object[])values);
    }

    @Override
    public Set<String> setMembers(String key) {
        BoundSetOperations setOperations = this.stringRedisTemplate.boundSetOps((Object)key);
        return setOperations.members();
    }

    @Override
    public Boolean setExist(String key, String value) {
        String regKey = this.regKey(key);
        if (StringUtils.isBlank((CharSequence)regKey)) {
            return false;
        }
        BoundSetOperations setOperations = this.stringRedisTemplate.boundSetOps((Object)regKey);
        return setOperations.isMember((Object)value);
    }
}

