/*
 * Decompiled with CFR 0.152.
 */
package com.anji.plus.gaea.init;

import com.anji.plus.gaea.annotation.Permission;
import com.anji.plus.gaea.annotation.Permissions;
import com.anji.plus.gaea.constant.Enabled;
import com.anji.plus.gaea.controller.GaeaBootController;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class InitRequestUrlMappings {
    @Autowired
    private RequestMappingHandlerMapping requestMappingHandlerMapping;
    @Value(value="${spring.application.name:}")
    private String applicationName;

    public List<RequestInfo> getRequestInfos(Integer scanAnnotation) {
        Map handlerMethods = this.requestMappingHandlerMapping.getHandlerMethods();
        ArrayList<RequestInfo> list = new ArrayList<RequestInfo>();
        handlerMethods.entrySet().stream().forEach(entry -> {
            ArrayList<Permission> annotations = new ArrayList<Permission>();
            RequestInfo requestInfo = new RequestInfo();
            HandlerMethod value = (HandlerMethod)entry.getValue();
            if (value.getBeanType() == GaeaBootController.class) {
                return;
            }
            if (Enabled.YES.getValue().equals(scanAnnotation)) {
                Permission[] permissions;
                Method method = value.getMethod();
                Class beanType = value.getBeanType();
                if (!beanType.isAnnotationPresent(Permission.class) || !method.isAnnotationPresent(Permission.class) && !method.isAnnotationPresent(Permissions.class)) return;
                Permission typeAnnotation = beanType.getAnnotation(Permission.class);
                for (Permission methodAnnotation : permissions = (Permission[])method.getAnnotationsByType(Permission.class)) {
                    if (StringUtils.isNotBlank((CharSequence)methodAnnotation.superCode())) {
                        requestInfo.setMenuCode(methodAnnotation.superCode());
                    } else {
                        requestInfo.setMenuCode(typeAnnotation.code());
                    }
                    requestInfo.setAuthCode(typeAnnotation.code() + ":" + methodAnnotation.code());
                    requestInfo.setAuthName(typeAnnotation.name() + methodAnnotation.name());
                    annotations.add(methodAnnotation);
                }
            } else {
                requestInfo.setAuthCode(value.getBean() + "#" + value.getMethod().getName());
            }
            requestInfo.setBeanName(value.getBean().toString());
            requestInfo.setApplicationName(this.applicationName);
            RequestMappingInfo requestMappingInfo = (RequestMappingInfo)entry.getKey();
            Optional requestMethodOptional = requestMappingInfo.getMethodsCondition().getMethods().stream().findFirst();
            if (!requestMethodOptional.isPresent()) {
                return;
            }
            RequestMethod requestMethod = (RequestMethod)requestMethodOptional.get();
            Optional pathOptional = requestMappingInfo.getPatternsCondition().getPatterns().stream().findFirst();
            if (!pathOptional.isPresent()) {
                return;
            }
            String path = (String)pathOptional.get();
            if (path.contains("{")) {
                path = path.replaceAll("\\{\\w+\\}", "**");
            }
            requestInfo.setPath(requestMethod + "#" + path);
            if (Enabled.YES.getValue().equals(scanAnnotation) && annotations.size() > 1) {
                annotations.stream().forEach(annotation -> {
                    RequestInfo requestInfoTmp = new RequestInfo();
                    BeanUtils.copyProperties((Object)requestInfo, (Object)requestInfoTmp);
                    if (StringUtils.isNotBlank((CharSequence)annotation.superCode())) {
                        requestInfoTmp.setMenuCode(annotation.superCode());
                    }
                    requestInfoTmp.setAuthCode(annotation.code());
                    requestInfoTmp.setAuthName(annotation.name());
                    list.add(requestInfoTmp);
                });
                return;
            } else {
                list.add(requestInfo);
            }
        });
        return list;
    }

    public static class RequestInfo {
        private String applicationName;
        private String beanName;
        private String menuCode;
        private String authCode;
        private String authName;
        private String path;

        public String getApplicationName() {
            return this.applicationName;
        }

        public void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public String getAuthCode() {
            return this.authCode;
        }

        public void setAuthCode(String authCode) {
            this.authCode = authCode;
        }

        public String getAuthName() {
            return this.authName;
        }

        public void setAuthName(String authName) {
            this.authName = authName;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getBeanName() {
            return this.beanName;
        }

        public void setBeanName(String beanName) {
            this.beanName = beanName;
        }

        public String getMenuCode() {
            return this.menuCode;
        }

        public void setMenuCode(String menuCode) {
            this.menuCode = menuCode;
        }
    }
}

