/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphCollection;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Row;
import com.aspose.words.TableCollection;
import com.aspose.words.TableStyle;
import com.aspose.words.internal.zzW9E;
import com.aspose.words.zzWJW;
import com.aspose.words.zzWxF;
import com.aspose.words.zzXjH;
import com.aspose.words.zzY59;
import com.aspose.words.zzYy0;
import com.aspose.words.zzZ7H;
import com.aspose.words.zzZSW;
import com.aspose.words.zzZXh;
import com.aspose.words.zzZZX;
import com.aspose.words.zzlK;

public class Cell
extends CompositeNode<Node>
implements zzY59,
zzZXh {
    private zzYy0 zzQn;
    private CellFormat zzWMD;
    private ParagraphCollection zzY5L;
    private TableCollection zzX0C;

    public Cell(DocumentBase doc) {
        this(doc, new zzYy0());
    }

    Cell(DocumentBase doc, zzYy0 cellPr) {
        super(doc);
        this.zzQn = cellPr;
    }

    @Override
    public int getNodeType() {
        return 7;
    }

    final Cell zzl7() {
        return (Cell)this.zzZpo();
    }

    public Row getParentRow() {
        return (Row)this.zzZxo();
    }

    public Paragraph getFirstParagraph() {
        return (Paragraph)this.getChild(8, 0, false);
    }

    public Paragraph getLastParagraph() {
        return (Paragraph)this.getChild(8, -1, false);
    }

    public boolean isFirstCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getFirstCell()) {
                return true;
            }
        }
        return false;
    }

    public boolean isLastCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getLastCell()) {
                return true;
            }
        }
        return false;
    }

    final int zzX5s() {
        Row row = this.getParentRow();
        if (row != null) {
            return row.zzWqN(this, true);
        }
        return -1;
    }

    final int zzYpc() {
        if (this.getParentRow() != null) {
            return this.getParentRow().zzYpc();
        }
        return -1;
    }

    public CellFormat getCellFormat() {
        if (this.zzWMD == null) {
            this.zzWMD = new CellFormat(this);
        }
        return this.zzWMD;
    }

    public ParagraphCollection getParagraphs() {
        if (this.zzY5L == null) {
            this.zzY5L = new ParagraphCollection(this);
        }
        return this.zzY5L;
    }

    public TableCollection getTables() {
        if (this.zzX0C == null) {
            this.zzX0C = new TableCollection(this);
        }
        return this.zzX0C;
    }

    final zzYy0 zzZeq() {
        return this.zzQn;
    }

    final void zzYMS(zzYy0 zzYy02) {
        this.zzQn = zzYy02;
    }

    @Override
    final Node zzYMS(boolean bl, zzZ7H zzZ7H2) {
        zzYy0 zzYy02;
        Cell cell = (Cell)super.zzYMS(bl, zzZ7H2);
        zzYy0 zzYy03 = this.zzQn;
        cell.zzQn = zzYy02 = (zzYy0)zzYy03.zzYlz();
        cell.zzWMD = null;
        cell.zzY5L = null;
        cell.zzX0C = null;
        return cell;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzYMS(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitCellStart(this);
    }

    @Override
    final int zzWqN(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitCellEnd(this);
    }

    public void ensureMinimum() {
        zzlK.zzW8o(this);
    }

    @Override
    final boolean zzWbG(Node node) {
        return zzWxF.zzZd6(node);
    }

    final int zzZRj() {
        Row row = this.getParentRow();
        if (row == null) {
            return -1;
        }
        int n = -1;
        Cell cell = row.getFirstCell();
        while (cell != null) {
            if (cell.getCellFormat().getHorizontalMerge() != 2) {
                ++n;
            }
            if (cell == this) {
                return n;
            }
            Cell cell2 = cell;
            cell = (Cell)cell2.zzZpo();
        }
        return -1;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzQn.zzXWJ(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        Object object = this.zzQn.zzXWJ(key);
        if (object == null) {
            return this.fetchInheritedCellAttr(key);
        }
        zzZSW zzZSW2 = zzW9E.zzYMS(object, zzZSW.class);
        if (zzZSW2 != null && zzZSW2.isInheritedComplexAttr()) {
            return this.fetchInheritedCellAttr(key);
        }
        return object;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        Object object = this.zzZ2r(key);
        if (object != null) {
            return object;
        }
        if (this.getParentRow() != null) {
            Row row = this.getParentRow();
            switch (key) {
                case 3070: {
                    return row.fetchRowAttr(4300);
                }
                case 3090: {
                    return row.fetchRowAttr(4020);
                }
                case 3080: {
                    return row.fetchRowAttr(4310);
                }
                case 3100: {
                    return row.fetchRowAttr(4320);
                }
                case 3110: {
                    return row.fetchRowAttr(this.getParentRow().isFirstRow() ? 4050 : 4090);
                }
                case 3120: {
                    return row.fetchRowAttr(this.isFirstCell() ? 4060 : 4100);
                }
                case 3130: {
                    return row.fetchRowAttr(this.getParentRow().isLastRow() ? 4070 : 4090);
                }
                case 3140: {
                    return row.fetchRowAttr(this.isLastCell() ? 4080 : 4100);
                }
            }
        }
        return zzYy0.zzXLJ(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        this.zzQn.zzZjh(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzQn.clear();
    }

    private Object zzZ2r(int n) {
        Cell cell;
        if (this.getParentRow() == null || (cell = this).getParentRow().getParentTable() == null) {
            return null;
        }
        cell = this;
        TableStyle tableStyle = zzW9E.zzYMS((Object)cell.getParentRow().getParentTable().getStyle(), TableStyle.class);
        if (tableStyle != null) {
            return tableStyle.zzYMS(n, this);
        }
        return null;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzZZX getInsertRevision() {
        Cell cell = this;
        return cell.zzQn.getInsertRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setInsertRevision(zzZZX value) {
        Cloneable cloneable = this;
        zzZZX zzZZX2 = value;
        cloneable = cloneable.zzQn;
        ((zzWJW)cloneable).zzZjh(14, zzZZX2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzZZX getDeleteRevision() {
        Cell cell = this;
        return cell.zzQn.getDeleteRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setDeleteRevision(zzZZX value) {
        Cloneable cloneable = this;
        zzZZX zzZZX2 = value;
        cloneable = cloneable.zzQn;
        ((zzWJW)cloneable).zzZjh(12, zzZZX2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzXjH getMoveFromRevision() {
        Cell cell = this;
        return cell.zzQn.getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveFromRevision(zzXjH value) {
        Cloneable cloneable = this;
        zzXjH zzXjH2 = value;
        cloneable = cloneable.zzQn;
        ((zzWJW)cloneable).zzZjh(13, zzXjH2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzXjH getMoveToRevision() {
        Cell cell = this;
        return cell.zzQn.getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveToRevision(zzXjH value) {
        Cloneable cloneable = this;
        zzXjH zzXjH2 = value;
        cloneable = cloneable.zzQn;
        ((zzWJW)cloneable).zzZjh(15, zzXjH2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeMoveRevisions() {
        Cell cell = this;
        cell.zzQn.remove(13);
        cell = this;
        cell.zzQn.remove(15);
    }

    final zzYy0 zzWeT(boolean bl) {
        Cell cell;
        TableStyle tableStyle;
        zzYy0 zzYy02 = new zzYy0();
        this.zzYMS(3120, zzYy02);
        this.zzYMS(3140, zzYy02);
        this.zzYMS(3110, zzYy02);
        this.zzYMS(3130, zzYy02);
        this.zzYMS(3090, zzYy02);
        this.zzYMS(3100, zzYy02);
        this.zzYMS(3070, zzYy02);
        this.zzYMS(3080, zzYy02);
        if (bl && (tableStyle = zzW9E.zzYMS((Object)(cell = this).getParentRow().getParentTable().getStyle(), TableStyle.class)) != null) {
            tableStyle.zzWqN(this, zzYy02);
        }
        this.zzQn.zzWqN((zzWJW)zzYy02);
        return zzYy02;
    }

    private void zzYMS(int n, zzYy0 zzYy02) {
        zzYy02.zzZjh(n, this.fetchInheritedCellAttr(n));
    }
}

