/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.ChartMarker;
import com.aspose.words.ChartSeries;
import com.aspose.words.internal.zzW9E;
import com.aspose.words.internal.zzZR7;
import com.aspose.words.zzLG;
import com.aspose.words.zzVS1;
import com.aspose.words.zzW6a;
import com.aspose.words.zzWYr;
import com.aspose.words.zzWut;
import com.aspose.words.zzWwn;
import com.aspose.words.zzX3l;
import com.aspose.words.zzXXe;
import com.aspose.words.zzYNk;
import com.aspose.words.zzZo5;
import java.util.Date;
import java.util.Iterator;

public class ChartSeriesCollection
implements Iterable<ChartSeries> {
    private zzVS1 zz7j;

    ChartSeriesCollection(zzVS1 dmlChart) {
        this.zz7j = dmlChart;
    }

    public ChartSeries get(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zz7j.zzW07().get(index);
    }

    @Override
    public Iterator<ChartSeries> iterator() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zz7j.zzW07().iterator();
    }

    public void removeAt(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zz7j.zzW07().remove(index);
    }

    public void clear() {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zz7j.zzW07().clear();
        this.zzWUD(false);
    }

    public ChartSeries add(String seriesName, String[] categories, double[] values) {
        if (categories == null || values == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (categories.length <= 0 || values.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (categories.length != values.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzYMS(seriesName, values);
        chartSeries.zzWyQ().zzY2m(ChartSeriesCollection.zzWgE(categories));
        return chartSeries;
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzYMS(seriesName, yValues);
        chartSeries.zzWyQ().zzY2m(ChartSeriesCollection.zzY2m(xValues));
        return chartSeries;
    }

    private ChartSeries zzYMS(String string, zzZR7[] zzZR7Array, double[] dArray) {
        if (zzZR7Array == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (zzZR7Array.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (zzZR7Array.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzYMS(string, dArray);
        chartSeries.zzWyQ().zzY2m(ChartSeriesCollection.zzYMS(zzZR7Array));
        if (!this.zz7j.zzWhv()) {
            this.zzWUD(true);
        }
        return chartSeries;
    }

    public ChartSeries add(String seriesName, Date[] dates, double[] values) {
        return this.zzYMS(seriesName, zzZR7.zzYMS(dates), values);
    }

    private void zzWUD(boolean bl) {
        zzWut zzWut2 = zzW9E.zzYMS((Object)this.zz7j, zzWut.class);
        if (zzWut2 != null && zzWut2.zzXzV().zzVVO()) {
            zzWut2.zzXzV().zzlw().zzZlP(2, bl);
        }
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues, double[] bubbleSizes) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        if (this.zz7j.zzVX3() != 15) {
            this.zz7j.zzbj(1, "Please make sure you are using correct chart type. There is no way to set bubble size for non-bubble chart.");
        }
        ChartSeries chartSeries = this.zzYMS(seriesName, yValues);
        chartSeries.zzBC().zzWpt().zzZlP(3, this.zz7j.zzFu());
        chartSeries.zzWyQ().zzY2m(ChartSeriesCollection.zzY2m(xValues));
        if (bubbleSizes != null) {
            chartSeries.zzL4().zzY2m(ChartSeriesCollection.zzY2m(bubbleSizes));
        }
        return chartSeries;
    }

    private ChartSeries zzYMS(String string, double[] dArray) {
        ChartSeries chartSeries = new ChartSeries(this.zz7j);
        chartSeries.setName(string);
        this.zzWbG(chartSeries);
        chartSeries.zzWYr(this.zz7j.zzYeF().zzYYG() + 1);
        chartSeries.zzYD0(this.zz7j.zzYeF().zzgH() + 1);
        chartSeries.zzZgC().zzY2m(ChartSeriesCollection.zzY2m(dArray));
        chartSeries.zzVOK().zzY2m(chartSeries.zzZgC().zzHU());
        this.zz7j.zzXk2().zzZUR();
        this.zz7j.zzZKS(chartSeries);
        return chartSeries;
    }

    private void zzWbG(ChartSeries chartSeries) {
        chartSeries.zzBC().zzWpt().zzZlP(5, new zzZo5());
        switch (this.zz7j.zzVX3()) {
            case 2: 
            case 5: {
                ChartSeriesCollection.zzYMS(chartSeries, 5);
                return;
            }
            case 4: {
                ChartSeriesCollection.zzYMS(chartSeries, 5);
                ChartSeriesCollection.zzo9(chartSeries);
                return;
            }
            case 6: {
                ChartSeriesCollection.zzYMS(chartSeries, 1);
                ChartSeriesCollection.zzo9(chartSeries);
                return;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                ChartSeriesCollection.zzWpv(chartSeries);
            }
        }
    }

    private static void zzWpv(ChartSeries chartSeries) {
        zzZo5 zzZo52 = new zzZo5();
        zzZo52.setOutline(new zzWwn());
        zzXXe zzXXe2 = new zzXXe();
        zzXXe2.zzYIY(1);
        zzZo52.getOutline().setFill(new zzW6a(zzXXe2));
        zzZo52.getOutline().zzWNx(19050.0);
        chartSeries.zzBC().zzWpt().zzZlP(5, zzZo52);
    }

    private static void zzo9(ChartSeries chartSeries) {
        zzZo5 zzZo52 = new zzZo5();
        zzZo52.setOutline(new zzWwn());
        zzZo52.getOutline().setFill(new zzYNk());
        zzZo52.getOutline().setEndCap(0);
        zzZo52.getOutline().zzWNx(19050.0);
        chartSeries.zzBC().zzWpt().zzZlP(5, zzZo52);
    }

    private static void zzYMS(ChartSeries chartSeries, int n) {
        ChartMarker chartMarker = new ChartMarker(chartSeries.zzWvQ());
        chartMarker.zzXEq().zzZlP(0, n);
        chartSeries.zzBC().zzWpt().zzZlP(4, chartMarker);
    }

    private static zzLG zzY2m(double[] dArray) {
        int n = 0;
        zzLG zzLG2 = new zzLG(2, false);
        double[] dArray2 = dArray;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            double d = dArray2[i];
            if (!Double.isNaN(d)) {
                zzLG2.zzo9(new zzWYr(n, d, "General"));
            }
            ++n;
        }
        zzLG2.zzfq(dArray.length);
        zzLG2.zzaM();
        return zzLG2;
    }

    private static zzLG zzYMS(zzZR7[] zzZR7Array) {
        int n = 0;
        zzLG zzLG2 = new zzLG(2, false);
        zzZR7[] zzZR7Array2 = zzZR7Array;
        int n2 = zzZR7Array.length;
        for (int i = 0; i < n2; ++i) {
            zzZR7 zzZR72 = zzZR7Array2[i];
            zzLG2.zzo9(new zzWYr(n++, zzZR72.zzX1a(), "m/d/yyyy"));
        }
        zzLG2.zzfq(zzZR7Array.length);
        zzLG2.zzaM();
        return zzLG2;
    }

    private static zzLG zzWgE(String[] stringArray) {
        int n = 0;
        zzLG zzLG2 = new zzLG(1, false);
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray2[i];
            zzLG2.zzo9(new zzX3l(n++, string));
        }
        zzLG2.zzfq(stringArray.length);
        zzLG2.zzaM();
        return zzLG2;
    }

    public int getCount() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zz7j.zzW07().size();
    }
}

