/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.NodeChangingArgs;
import com.aspose.words.NodeCollection;
import com.aspose.words.NodeList;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SmartTag;
import com.aspose.words.internal.zzW9E;
import com.aspose.words.zzW2U;
import com.aspose.words.zzWxF;
import com.aspose.words.zzWyf;
import com.aspose.words.zzXap;
import com.aspose.words.zzY45;
import com.aspose.words.zzZ7H;
import com.aspose.words.zzZiO;
import com.aspose.words.zzgj;
import com.aspose.words.zzmd;
import java.util.Iterator;

public abstract class CompositeNode<T extends Node>
extends Node
implements zzgj,
Iterable<T> {
    private Node zzZNs;
    private Node zzX51;
    private Node zzYGt;

    protected CompositeNode() {
    }

    protected CompositeNode(DocumentBase doc) {
        super(doc);
    }

    protected void coreRemoveSelfOnly() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("This node is not attached to any document");
        }
        while (this.hasChildNodes()) {
            this.getParentNode().insertAfter(this.getLastChild(), this);
        }
        this.remove();
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    final boolean zzXBH() {
        return this.zzHl() != null;
    }

    final boolean zzY7G() {
        return this.hasChildNodes() && this.getFirstChild() == this.getLastChild();
    }

    final boolean zzW2Z() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof zzmd) {
                return true;
            }
            CompositeNode compositeNode = zzW9E.zzYMS((Object)node, CompositeNode.class);
            if (compositeNode == null || !compositeNode.zzW2Z()) continue;
            return true;
        }
        return false;
    }

    public NodeCollection getChildNodes() {
        return this.getChildNodes(0, false);
    }

    public Node getFirstChild() {
        return this.zzZNs;
    }

    public Node getLastChild() {
        return this.zzX51;
    }

    final Node zzHl() {
        return zzWxF.zzbj(this.getFirstChild(), false);
    }

    final Node zzZoh() {
        return zzWxF.zzWbG(this.getLastChild(), false);
    }

    final CompositeNode zzXYX() {
        return (CompositeNode)zzWxF.zzbj(this.getFirstChild(), true);
    }

    final CompositeNode zzWBm() {
        return (CompositeNode)zzWxF.zzWbG(this.getLastChild(), true);
    }

    final Node zzWJo() {
        Node node;
        Node node2;
        for (node2 = this.getFirstChild(); node2 != null && zzWxF.zzJn((node = node2).getNodeType()); node2 = node2.getNextSibling()) {
        }
        return node2;
    }

    final Node zzZk0() {
        Node node;
        Node node2;
        for (node2 = this.getLastChild(); node2 != null && zzWxF.zzJn((node = node2).getNodeType()); node2 = node2.getPreviousSibling()) {
        }
        return node2;
    }

    public int getCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++n;
        }
        return n;
    }

    @Override
    Node zzYMS(boolean bl, zzZ7H zzZ7H2) {
        CompositeNode compositeNode = (CompositeNode)super.zzYMS(bl, zzZ7H2);
        ((CompositeNode)super.zzYMS(bl, zzZ7H2)).zzX51 = null;
        compositeNode.zzZNs = null;
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                compositeNode.zzZKr(node.zzYMS(true, zzZ7H2));
            }
        }
        return compositeNode;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzX3S(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    final void zzX3S(StringBuilder stringBuilder) {
        this.zzWgE(stringBuilder);
        zzW9E.zzWqN(stringBuilder, this.zzXOF());
    }

    public NodeCollection getChildNodes(int nodeType, boolean isDeep) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    final NodeCollection zzWqN(int[] nArray, boolean bl) {
        return new NodeCollection(this, nArray, true);
    }

    public Node getChild(int nodeType, int index, boolean isDeep) {
        if (index >= 0 && !isDeep) {
            Node node;
            int n = index + 1;
            boolean bl = zzWxF.zzLv(nodeType);
            Node node2 = node = bl ? this.zzHl() : this.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == nodeType || nodeType == 0) {
                    --n;
                }
                if (n == 0) {
                    return node;
                }
                node = bl ? node.zzZlz() : node.getNextSibling();
            }
        } else {
            NodeCollection nodeCollection = this.getChildNodes(nodeType, isDeep);
            return nodeCollection.get(index);
        }
        return null;
    }

    public NodeList selectNodes(String xpath) {
        return zzWyf.zzWzr(this, xpath);
    }

    public Node selectSingleNode(String xpath) {
        return zzWyf.zzY2m(this, xpath);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzW2U(this);
    }

    public Node appendChild(Node newChild) {
        return this.insertAfter(newChild, this.getLastChild());
    }

    public Node prependChild(Node newChild) {
        return this.insertBefore(newChild, this.getFirstChild());
    }

    public Node insertAfter(Node newChild, Node refChild) {
        return this.zzYMS(newChild, refChild, true);
    }

    public Node insertBefore(Node newChild, Node refChild) {
        return this.zzYMS(newChild, refChild, false);
    }

    public Node removeChild(Node oldChild) {
        if (oldChild == null) {
            throw new NullPointerException("oldChild");
        }
        if (oldChild.getParentNode() != this) {
            throw new IllegalArgumentException("This node is not a parent of the oldChild node.");
        }
        DocumentBase documentBase = this.getDocument();
        NodeChangingArgs nodeChangingArgs = documentBase.zzYMS(oldChild, this, null, 1);
        if (documentBase.zzX88() && zzXap.zzZi8(oldChild)) {
            return oldChild;
        }
        if (nodeChangingArgs != null) {
            documentBase.zzYMS(nodeChangingArgs);
        }
        Node node = this.zzYbt(oldChild);
        if (nodeChangingArgs != null) {
            documentBase.zzWqN(nodeChangingArgs);
        }
        return node;
    }

    public void removeAllChildren() {
        zzZiO.zzZd6(this.getFirstChild(), null);
    }

    public void removeSmartTags() {
        for (SmartTag smartTag : this.getChildNodes(27, true)) {
            smartTag.coreRemoveSelfOnly();
        }
    }

    final Node zzZKr(Node node) {
        node.getParentNode();
        if (this.zzX51 == null) {
            node.zzWiT(null);
            node.zzZ4f(null);
            this.zzZNs = node;
        } else {
            node.zzWiT(this.zzX51);
            node.zzZ4f(null);
            this.zzX51.zzZ4f(node);
        }
        this.zzX51 = node;
        node.zzYoP(this);
        return node;
    }

    final void zzYMS(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            this.insertBefore(node4, node3);
            node4 = node5;
        }
    }

    final void zzWqN(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            node3 = this.insertAfter(node4, node3);
            node4 = node5;
        }
    }

    public int indexOf(Node child) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == child) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final int zzWqN(Node node, boolean bl) {
        int n = 0;
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Node node3 = node2;
            if (zzWxF.zzJn(node3.getNodeType())) continue;
            if (zzWxF.zzXYy(node, node2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    final int getTextLength() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return n += this.zzXOF().length();
    }

    String zzXOF() {
        return "";
    }

    final String zzi7() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzWgE(stringBuilder);
        return stringBuilder.toString();
    }

    private void zzWgE(StringBuilder stringBuilder) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            node.zzX3S(stringBuilder);
        }
    }

    protected boolean acceptCore(DocumentVisitor visitor) throws Exception {
        switch (this.zzYMS(visitor)) {
            case 0: {
                break;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            default: {
                throw new IllegalStateException("Unknown visitor action.");
            }
        }
        if (!this.acceptChildren(visitor)) {
            return false;
        }
        return CompositeNode.visitorActionToBool(this.zzWqN(visitor));
    }

    abstract int zzYMS(DocumentVisitor var1) throws Exception;

    abstract int zzWqN(DocumentVisitor var1) throws Exception;

    protected boolean acceptChildren(DocumentVisitor visitor) throws Exception {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (!node.accept(visitor)) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    abstract boolean zzWbG(Node var1);

    final Node zzYMS(Node node, Node node2, boolean bl) {
        Object object;
        if (node2 != null && node2.getParentNode() != this) {
            throw new IllegalArgumentException("The reference node is not a child of this node.");
        }
        if (node == null) {
            throw new IllegalArgumentException("Cannot insert a null node.");
        }
        if (node == this) {
            throw new IllegalArgumentException("Cannot add a node to self.");
        }
        if (this.zzae(node)) {
            throw new IllegalArgumentException("The newChild is an ancestor of this node.");
        }
        if (node == node2) {
            throw new IllegalArgumentException("Cannot add a node before/after itself.");
        }
        DocumentBase documentBase = this.getDocument();
        DocumentBase documentBase2 = node.getDocument();
        if (documentBase2 != documentBase) {
            throw new IllegalArgumentException("The newChild was created from a different document than the one that created this node.");
        }
        if (node.getNodeType() != 37 && !this.zzWbG(node)) {
            throw new IllegalArgumentException("Cannot insert a node of this type at this location.");
        }
        CompositeNode compositeNode = node.getParentNode();
        Node node3 = node.getNextSibling();
        if (compositeNode != null) {
            object = new zzY45(documentBase);
            try {
                compositeNode.removeChild(node);
            }
            finally {
                ((zzY45)object).dispose();
            }
        }
        if ((object = documentBase.zzYMS(node, null, this, 0)) != null) {
            documentBase.zzYMS((NodeChangingArgs)object);
        }
        if (this.zzX51 == null) {
            node.zzWiT(null);
            node.zzZ4f(null);
            this.zzZNs = node;
            this.zzX51 = node;
        } else if (bl) {
            if (node2 != null) {
                this.zzWqN(node, node2);
            } else {
                this.zzWzr(node, this.zzZNs);
            }
        } else if (node2 != null) {
            this.zzWzr(node, node2);
        } else {
            this.zzWqN(node, this.zzX51);
        }
        node.zzYoP(this);
        if (object != null) {
            documentBase.zzWqN((NodeChangingArgs)object);
        }
        if (documentBase.zzX88()) {
            zzXap.zzYMS(node, compositeNode, node3);
        }
        return node;
    }

    private void zzWqN(Node node, Node node2) {
        Node node3 = node2.zzXmW();
        node.zzWiT(node2);
        node.zzZ4f(node3);
        node2.zzZ4f(node);
        if (node3 == null) {
            this.zzX51 = node;
            return;
        }
        node3.zzWiT(node);
    }

    private void zzWzr(Node node, Node node2) {
        Node node3 = node2.zzWaN();
        node.zzWiT(node3);
        node.zzZ4f(node2);
        node2.zzWiT(node);
        if (node3 == null) {
            this.zzZNs = node;
            return;
        }
        node3.zzZ4f(node);
    }

    private Node zzYbt(Node node) {
        if (node == this.zzZNs) {
            if (this.zzZNs == this.zzX51) {
                this.zzZNs = null;
                this.zzX51 = null;
            } else {
                this.zzZNs = node.zzXmW();
                this.zzZNs.zzWiT(null);
            }
        } else {
            Node node2 = node.zzWaN();
            Node node3 = node.zzXmW();
            node2.zzZ4f(node3);
            if (node3 == null) {
                this.zzX51 = node2;
            } else {
                node3.zzWiT(node2);
            }
        }
        node.zzZ4f(null);
        node.zzWiT(null);
        node.zzYoP(null);
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) {
        Node node = curNode;
        this.zzYGt = curNode == this ? this.getFirstChild() : curNode.getNextSibling();
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzYGt;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this;
    }
}

