/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CertificateHolder;
import com.aspose.words.DigitalSignature;
import com.aspose.words.DigitalSignatureCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.SignOptions;
import com.aspose.words.UnsupportedFileFormatException;
import com.aspose.words.internal.zzAX;
import com.aspose.words.internal.zzMy;
import com.aspose.words.internal.zzW3N;
import com.aspose.words.internal.zzW9E;
import com.aspose.words.internal.zzWHB;
import com.aspose.words.internal.zzXBi;
import com.aspose.words.internal.zzXZj;
import com.aspose.words.internal.zzXf2;
import com.aspose.words.internal.zzY1Z;
import com.aspose.words.internal.zzYgB;
import com.aspose.words.internal.zzZM9;
import com.aspose.words.internal.zzZmq;
import com.aspose.words.zzAU;
import com.aspose.words.zzW5p;
import com.aspose.words.zzWcX;
import com.aspose.words.zzWm5;
import com.aspose.words.zzX6f;
import com.aspose.words.zzYuC;
import com.aspose.words.zzZUv;
import com.aspose.words.zzZdT;
import com.aspose.words.zzf4;
import com.aspose.words.zzpA;
import java.io.InputStream;
import java.io.OutputStream;

public class DigitalSignatureUtil {
    private DigitalSignatureUtil() {
    }

    private static void zzYMS(zzW3N zzW3N2, zzW3N zzW3N3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        zzW9E.zzWqN((Object)zzW3N2, "srcStream");
        zzW9E.zzWqN((Object)zzW3N3, "dstStream");
        zzW9E.zzWqN((Object)certificateHolder, "certHolder");
        DigitalSignatureUtil.zzWqN(zzW3N2, zzW3N3, certificateHolder, signOptions);
        zzW3N3.flush();
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        DigitalSignatureUtil.zzYMS(zzW3N.zzWqN(srcStream), (zzW3N)zzW3N.zzWzr(dstStream), certHolder, signOptions);
    }

    private static void zzWqN(zzW3N zzW3N2, zzW3N zzW3N3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        DigitalSignature digitalSignature = new DigitalSignature(certificateHolder);
        if (signOptions != null) {
            signOptions.zzWzr(digitalSignature);
        }
        if (zzZUv.zzZi2(zzW3N2)) {
            DigitalSignatureUtil.zzYMS(zzW3N2, zzW3N3, digitalSignature, true);
            return;
        }
        zzZUv zzZUv2 = new zzZUv();
        zzW3N zzW3N4 = zzW3N2;
        zzZUv zzZUv3 = zzZUv2;
        FileFormatInfo fileFormatInfo = zzZUv2.zzWqN(zzW3N4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzXBi zzXBi2 = new zzXBi(zzW3N2);
                int n = fileFormatInfo.zzYh0() == 1 ? 1 : 2;
                zzW5p.zzYMS(zzXBi2, digitalSignature, n);
                zzW3N3.zzZd6(0L);
                zzXBi2.zzYpv(zzW3N3);
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                if (fileFormatInfo.isEncrypted()) {
                    String string = signOptions != null ? signOptions.getDecryptionPassword() : null;
                    DigitalSignatureUtil.zzYMS(fileFormatInfo.zzXUJ(), zzW3N3, digitalSignature, string);
                    return;
                }
                DigitalSignatureUtil.zzYMS(zzW3N2, zzW3N3, digitalSignature, false);
                return;
            }
            case 60: {
                DigitalSignatureUtil.zzYMS(zzW3N2, zzW3N3, digitalSignature);
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        zzW9E.zzYMS(srcFileName, "srcFileName");
        zzW9E.zzYMS(dstFileName, "dstFileName");
        try (zzMy zzMy2 = zzW9E.zzWqN(srcFileName, 3, 1);){
            try (zzMy zzMy3 = zzW9E.zzWqN(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzYMS((zzW3N)zzMy2, (zzW3N)zzMy3, certHolder, signOptions);
            }
            return;
        }
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder) throws Exception {
        CertificateHolder certificateHolder = certHolder;
        zzYgB zzYgB2 = zzW3N.zzWzr(dstStream);
        zzW3N zzW3N2 = zzW3N.zzWqN(srcStream);
        DigitalSignatureUtil.zzYMS(zzW3N2, (zzW3N)zzYgB2, certificateHolder, null);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder) throws Exception {
        DigitalSignatureUtil.sign(srcFileName, dstFileName, certHolder, null);
    }

    public static void removeAllSignatures(String srcFileName, String dstFileName) throws Exception {
        try (zzMy zzMy2 = zzW9E.zzWqN(srcFileName, 3, 1);){
            try (zzMy zzMy3 = zzW9E.zzWqN(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzXYy(zzMy2, zzMy3);
            }
            return;
        }
    }

    private static void zzXYy(zzW3N zzW3N2, zzW3N zzW3N3) throws Exception {
        zzZUv zzZUv2 = new zzZUv();
        zzW3N zzW3N4 = zzW3N2;
        zzZUv zzZUv3 = zzZUv2;
        FileFormatInfo fileFormatInfo = zzZUv2.zzWqN(zzW3N4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzXBi zzXBi2 = new zzXBi(zzW3N2);
                zzXBi2.zz24().zzXgJ("_xmlsignatures");
                zzXBi2.zz24().zzXgJ("_signatures");
                zzW3N3.zzVVt(0L);
                zzXBi2.zzYpv(zzW3N3);
                zzW3N zzW3N5 = zzW3N3;
                zzW3N5.zzZd6(zzW3N5.zzY0C());
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                zzZmq zzZmq2 = new zzZmq(zzW3N2);
                zzWHB zzWHB2 = zzZmq2.zzYMS(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (zzWHB2 != null) {
                    for (zzAX zzAX2 : zzWHB2.zzXvR()) {
                        String string = zzWHB2.zzYMS(zzAX2);
                        zzZmq2.zzUY().remove(string);
                    }
                    zzZmq2.zzUY().remove(zzWHB2.getName());
                    zzAX zzAX3 = zzZmq2.zzXvR().zzWa8("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                    zzZmq2.zzXvR().remove(zzAX3.getId());
                    zzZmq2.zzYOd();
                }
                zzW3N3.zzVVt(0L);
                zzZmq2.zzYpv(zzW3N3);
                zzW3N zzW3N6 = zzW3N3;
                zzW3N6.zzZd6(zzW3N6.zzY0C());
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void removeAllSignatures(InputStream srcStream, OutputStream dstStream) throws Exception {
        DigitalSignatureUtil.zzXYy(zzW3N.zzWqN(srcStream), zzW3N.zzWzr(dstStream));
    }

    public static DigitalSignatureCollection loadSignatures(String fileName) throws Exception {
        try (zzMy zzMy2 = zzW9E.zzWqN(fileName, 3, 1);){
            DigitalSignatureCollection digitalSignatureCollection = DigitalSignatureUtil.zzYDI(zzMy2);
            return digitalSignatureCollection;
        }
    }

    private static DigitalSignatureCollection zzYDI(zzW3N zzW3N2) throws Exception {
        if (zzZUv.zzZi2(zzW3N2)) {
            return DigitalSignatureUtil.zzzf(zzW3N2);
        }
        zzZUv zzZUv2 = new zzZUv();
        zzW3N zzW3N3 = zzW3N2;
        zzZUv zzZUv3 = zzZUv2;
        FileFormatInfo fileFormatInfo = zzZUv2.zzWqN(zzW3N3, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 60: {
                Document document = new Document(zzW3N2, null, false);
                return document.getDigitalSignatures();
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static DigitalSignatureCollection loadSignatures(InputStream stream) throws Exception {
        return DigitalSignatureUtil.zzYDI(zzW3N.zzWqN(stream));
    }

    static zzXZj zzYMS(zzXBi zzXBi2, String string) throws Exception {
        zzYuC zzYuC2 = new zzYuC(zzXBi2);
        if (zzYuC2.zzWVn()) {
            zzXZj zzXZj2 = zzYuC2.zzZUp(string);
            return zzXZj2;
        }
        throw new UnsupportedFileFormatException("Unknown file format.");
    }

    static String zzWAV(int n) {
        switch (n) {
            case 1: {
                return "http://www.w3.org/2000/09/xmldsig#sha1";
            }
            case 3: {
                return "http://www.w3.org/2001/04/xmlenc#sha256";
            }
        }
        throw new IllegalStateException(zzZM9.zzWqN("Unexpected digest algorithm: {0}.", n));
    }

    static String zzY1Q(byte by) {
        int n = by == 2 ? 3 : 1;
        return DigitalSignatureUtil.zzWAV(n);
    }

    private static void zzYMS(zzW3N zzW3N2, zzW3N zzW3N3, DigitalSignature digitalSignature, boolean bl) throws Exception {
        zzZmq zzZmq2 = new zzZmq(zzW3N2);
        zzWcX zzWcX2 = bl ? new zzpA(zzZmq2) : new zzZdT(zzZmq2);
        zzWcX2.zzWqN(digitalSignature);
        zzW3N3.zzZd6(0L);
        zzZmq2.zzYpv(zzW3N3);
    }

    private static void zzYMS(zzW3N zzW3N2, zzW3N zzW3N3, DigitalSignature digitalSignature) throws Exception {
        zzAU zzAU2 = new zzAU(zzW3N2);
        zzX6f zzX6f2 = new zzX6f(zzAU2);
        zzX6f2.zzWqN(digitalSignature);
        zzW3N3.zzZd6(0L);
        String string = "application/vnd.oasis.opendocument.text";
        zzW3N zzW3N4 = zzW3N3;
        zzAU zzAU3 = zzAU2;
        zzAU3.zzYMS(zzW3N4, string, null);
    }

    private static void zzYMS(zzXBi zzXBi2, zzW3N zzW3N2, DigitalSignature digitalSignature, String string) throws Exception {
        zzXZj zzXZj2 = DigitalSignatureUtil.zzYMS(zzXBi2, string);
        zzXZj zzXZj3 = new zzXZj();
        DigitalSignatureUtil.zzYMS((zzW3N)zzXZj2, (zzW3N)zzXZj3, digitalSignature, false);
        zzXBi zzXBi3 = zzYuC.zzWzr(zzXZj3, string);
        zzXBi3.zzYpv(zzW3N2);
    }

    private static DigitalSignatureCollection zzzf(zzW3N zzW3N2) throws Exception {
        zzW3N2.zzVVt(0L);
        zzZmq zzZmq2 = new zzZmq(zzW3N2);
        DigitalSignatureCollection digitalSignatureCollection = new DigitalSignatureCollection();
        zzWHB zzWHB2 = zzZmq2.zzYMS(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        if (zzWHB2 != null) {
            for (zzAX zzAX2 : zzWHB2.zzXvR()) {
                String string = zzWHB2.zzYMS(zzAX2);
                zzWHB zzWHB3 = zzZmq2.zzWUD(string);
                zzWHB zzWHB4 = zzZmq2.zzYMS(zzWHB3, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate");
                zzY1Z zzY1Z2 = zzXf2.zzXiu(zzWHB4.zzYCP().zzW7H());
                zzf4.zzYMS(zzWHB3.zzzQ(), zzY1Z2, new zzWm5(zzZmq2), digitalSignatureCollection, null);
            }
        }
        return digitalSignatureCollection;
    }
}

