/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.Bookmark;
import com.aspose.words.BookmarkEnd;
import com.aspose.words.BookmarkStart;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.ConvertUtil;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.EditableRangeEnd;
import com.aspose.words.EditableRangeStart;
import com.aspose.words.Field;
import com.aspose.words.FieldEnd;
import com.aspose.words.FieldMergeField;
import com.aspose.words.FieldSeparator;
import com.aspose.words.FieldStart;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FormField;
import com.aspose.words.HeaderFooter;
import com.aspose.words.ImageSize;
import com.aspose.words.ImportFormatOptions;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ResourceLoadingArgs;
import com.aspose.words.Row;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.SignatureLineOptions;
import com.aspose.words.SpecialChar;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Style;
import com.aspose.words.Table;
import com.aspose.words.internal.zzGv;
import com.aspose.words.internal.zzJm;
import com.aspose.words.internal.zzQb;
import com.aspose.words.internal.zzW3D;
import com.aspose.words.internal.zzW3N;
import com.aspose.words.internal.zzW6a;
import com.aspose.words.internal.zzW9E;
import com.aspose.words.internal.zzXHg;
import com.aspose.words.internal.zzXZj;
import com.aspose.words.internal.zzXvY;
import com.aspose.words.internal.zzYC5;
import com.aspose.words.internal.zzYEo;
import com.aspose.words.internal.zzYUG;
import com.aspose.words.internal.zzZLz;
import com.aspose.words.internal.zzZM9;
import com.aspose.words.internal.zzZOO;
import com.aspose.words.internal.zzZvV;
import com.aspose.words.internal.zzum;
import com.aspose.words.zz1b;
import com.aspose.words.zz5x;
import com.aspose.words.zz6h;
import com.aspose.words.zzF1;
import com.aspose.words.zzWEP;
import com.aspose.words.zzWHu;
import com.aspose.words.zzWJW;
import com.aspose.words.zzWRZ;
import com.aspose.words.zzWwo;
import com.aspose.words.zzWxF;
import com.aspose.words.zzX01;
import com.aspose.words.zzXAj;
import com.aspose.words.zzXLK;
import com.aspose.words.zzXMo;
import com.aspose.words.zzXNA;
import com.aspose.words.zzXap;
import com.aspose.words.zzXe7;
import com.aspose.words.zzXg0;
import com.aspose.words.zzXhU;
import com.aspose.words.zzY45;
import com.aspose.words.zzYDz;
import com.aspose.words.zzYPD;
import com.aspose.words.zzYRL;
import com.aspose.words.zzYUL;
import com.aspose.words.zzYYN;
import com.aspose.words.zzYbj;
import com.aspose.words.zzYeK;
import com.aspose.words.zzYfu;
import com.aspose.words.zzYwZ;
import com.aspose.words.zzYy0;
import com.aspose.words.zzZXh;
import com.aspose.words.zzZZR;
import com.aspose.words.zzZde;
import com.aspose.words.zzZfz;
import com.aspose.words.zzZnI;
import com.aspose.words.zzZpT;
import com.aspose.words.zzZr8;
import com.aspose.words.zze4;
import com.aspose.words.zzk0;
import com.aspose.words.zzlK;
import com.aspose.words.zzme;
import java.awt.image.BufferedImage;
import java.io.InputStream;

public class DocumentBuilder
implements zzXNA,
zzYPD,
zzZXh {
    private Document zzWFy;
    private Node zzVV4;
    private Node zzI0;
    private zzWEP zzXFB;
    private Font zzZlO;
    private zzQb<zzWEP> zzYsH;
    private zzQb<zzZnI> zzVU0;
    private zzQb<zzYMS> zzZrJ;
    private zzXe7 zzZYv = zzXe7.zzXvC();
    private zzYy0 zzQn = new zzYy0();
    private RowFormat zzY5t;
    private CellFormat zzWMD;
    private zzQb<zz1b> zzXMb;
    private int zzWnA = 0;
    private int zzZdW = -1;
    private int zzWUy;

    public DocumentBuilder() throws Exception {
        this.setDocument(new Document());
    }

    public DocumentBuilder(Document doc) {
        this.setDocument(doc);
    }

    public void moveToDocumentStart() {
        this.zzY3k(0, 1, 0, 0);
    }

    public void moveToDocumentEnd() {
        this.zzY3k(-1, 1, -1, -1);
        Footnote footnote = (Footnote)this.getCurrentParagraph().getAncestor(20);
        if (footnote != null) {
            this.moveTo(footnote.getParentParagraph());
        }
    }

    public void moveToSection(int sectionIndex) {
        this.zzY3k(sectionIndex, 1, 0, 0);
    }

    public void moveToHeaderFooter(int headerFooterType) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzYMS(documentBuilder.getCurrentSection(), zzlK.zzpE(headerFooterType), 0, 0);
    }

    private void zzY3k(int n, int n2, int n3, int n4) {
        this.zzWFy.ensureMinimum();
        Section section = (Section)this.zzWFy.getChild(2, n, false);
        if (section == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: sectionIdx");
        }
        this.zzYMS(section, 1, n3, n4);
    }

    private void zzYMS(Section section, int n, int n2, int n3) {
        Story story;
        section.ensureMinimum();
        if (n == 1) {
            story = section.getBody();
        } else {
            int n4 = zzlK.zzZ9C(n);
            story = section.getHeadersFooters().getByHeaderFooterType(n4);
            if (story == null) {
                story = (HeaderFooter)section.appendChild(new HeaderFooter(this.zzWFy, n4));
            }
            if (story.getFirstParagraph() == null) {
                story.appendChild(new Paragraph(this.zzWFy));
            }
        }
        this.zzYMS(story, n2, n3);
    }

    private void zzYMS(Story story, int n, int n2) {
        Paragraph paragraph = (Paragraph)story.getChild(8, n, true);
        if (paragraph == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: paraIdx");
        }
        int n3 = n2;
        Paragraph paragraph2 = paragraph;
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzYMS(paragraph2, n3);
    }

    final void zzWzr(Paragraph paragraph, int n) {
        this.zzYMS(paragraph, n);
    }

    public boolean moveToMergeField(String fieldName) throws Exception {
        return this.moveToMergeField(fieldName, true, true);
    }

    public boolean moveToMergeField(String fieldName, boolean isAfter, boolean isDeleteField) throws Exception {
        if (fieldName == null) {
            throw new NullPointerException("fieldName");
        }
        FieldMergeField fieldMergeField = this.zzXTY().zzXz() ? zz5x.zzbj(this.zzWFy, fieldName) : zz5x.zzWbG(this.zzXTY(), fieldName);
        if (fieldMergeField == null) {
            return false;
        }
        return this.zzYMS(fieldMergeField, isAfter, isDeleteField);
    }

    public void moveToField(Field field, boolean isAfter) throws Exception {
        this.zzYMS(field, isAfter, false);
    }

    private boolean zzYMS(Field field, boolean bl, boolean bl2) throws Exception {
        Node node;
        zzXg0 zzXg02 = field.getFormat().zzbH();
        Inline inline = zzXg02.getSourceNode();
        if (bl2) {
            node = field.remove();
            if (node == null) {
                return false;
            }
        } else if (bl) {
            node = field.getEnd().getNextSibling();
            if (node == null) {
                node = field.getEnd().getParentParagraph();
            }
        } else {
            node = field.getStart();
        }
        this.moveTo(node);
        if (inline != null) {
            this.zzYMS(inline.zzZzH(), true);
        }
        return true;
    }

    public boolean moveToBookmark(String bookmarkName) throws Exception {
        return this.moveToBookmark(bookmarkName, true, true);
    }

    public boolean moveToBookmark(String bookmarkName, boolean isStart, boolean isAfter) throws Exception {
        if (bookmarkName == null) {
            throw new NullPointerException("bookmarkName");
        }
        Node node = isStart ? zzYfu.zzYMS(this.zzWFy, bookmarkName) : zzYfu.zzWqN(this.zzWFy, bookmarkName);
        if (node == null) {
            return false;
        }
        if (node.zzWyE() == 6) {
            this.zzWqN((Paragraph)node.zzZxo(), isAfter ? node.getNextSibling() : node);
        } else {
            Paragraph paragraph = zzWxF.zzYPI(node);
            if (paragraph == null) {
                return false;
            }
            Paragraph paragraph2 = paragraph;
            this.zzWqN(paragraph2, paragraph2.getFirstChild());
        }
        return true;
    }

    public void moveToParagraph(int paragraphIndex, int characterIndex) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzYMS(documentBuilder.getCurrentStory(), paragraphIndex, characterIndex);
    }

    public void moveToCell(int tableIndex, int rowIndex, int columnIndex, int characterIndex) {
        Row row = this.zzYGs(tableIndex, rowIndex);
        Cell cell = (Cell)row.getChild(7, columnIndex, false);
        if (cell == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: columnIndex");
        }
        cell.ensureMinimum();
        this.zzYMS(cell, characterIndex);
    }

    private void zzWqN(Paragraph paragraph, Node node) {
        if (node != null) {
            this.moveTo(node);
            return;
        }
        this.moveTo(paragraph);
    }

    public void moveTo(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        if (node.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("The node belongs to a different document.");
        }
        if (node.getParentNode() == null) {
            throw new IllegalArgumentException("Parent cannot be null.");
        }
        if (node.getNodeType() == 8 || node.zzWyE() == 6) {
            this.zzWUv(node);
        } else {
            Node node2 = node;
            if (zzWxF.zzJn(node2.getNodeType())) {
                Paragraph paragraph = zzWxF.zzYPI(node);
                if (paragraph == null) {
                    throw new IllegalStateException("There is no paragraph next to the specified node.");
                }
                this.zzWUv(paragraph.hasChildNodes() ? paragraph.getFirstChild() : paragraph);
            } else if (node.isComposite() && node.zzWyE() == 3) {
                Node node3 = ((CompositeNode)node).getChild(8, 0, true);
                if (node3 == null) {
                    throw new IllegalStateException("The block level node doesn't contain paragraph.");
                }
                this.zzWUv(node3);
            } else {
                throw new IllegalStateException("The node must be a block or an inline.");
            }
        }
        this.zzWUy = 0;
        if (this.isAtEndOfParagraph()) {
            this.zzZuF();
            return;
        }
        if (!this.zzpf()) {
            this.zzZuF();
        }
    }

    private boolean zzpf() {
        Node node = this.zzXTY();
        if (!(node instanceof Inline)) {
            while (node != null && !(node instanceof Inline)) {
                node = node.getPreviousSibling();
            }
        }
        if (node == null) {
            for (node = this.zzXTY(); node != null && !(node instanceof Inline); node = node.getNextSibling()) {
            }
        }
        if (node != null) {
            Inline inline = (Inline)node;
            this.zzYMS(inline.zzZzH(), true);
            return true;
        }
        return false;
    }

    private void zzZuF() {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzYMS(documentBuilder.getCurrentParagraph().zztA(), true);
    }

    public Row deleteRow(int tableIndex, int rowIndex) {
        Row row = this.zzYGs(tableIndex, rowIndex);
        Table table = row.getParentTable();
        if (this.zzZY7() != null) {
            throw new IllegalStateException("Cannot delete a table row while building a table.");
        }
        if (this.zzXTY().zzae(row)) {
            boolean bl = row == table.getLastRow();
            if (!bl) {
                this.moveToCell(tableIndex, rowIndex + 1, 0, 0);
            } else {
                Paragraph paragraph = (Paragraph)table.zzZpo();
                int n = 0;
                Paragraph paragraph2 = paragraph;
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzYMS(paragraph2, n);
            }
        }
        row.remove();
        if (table.getFirstRow() == null) {
            table.remove();
        }
        return row;
    }

    public void write(String text) {
        this.zzVWG(text, false);
    }

    public void writeln(String text) {
        this.zzVWG(text, true);
    }

    public void writeln() {
        this.insertParagraph();
    }

    public Paragraph insertParagraph() {
        this.zzZtO();
        Paragraph paragraph = this.getCurrentParagraph();
        zzY45 zzY452 = new zzY45(this.getDocument());
        try {
            Paragraph paragraph2 = new Paragraph(this.zzWFy, this.zzX2w(), this.zzqG());
            this.getCurrentParagraph().getParentNode().insertAfter(paragraph2, this.getCurrentParagraph());
            if (this.isAtEndOfParagraph()) {
                this.moveTo(paragraph2);
            } else {
                paragraph2.zzWqN(this.zzXTY(), null, paragraph2.getLastChild());
            }
        }
        finally {
            zzY452.dispose();
        }
        if (this.getDocument().zzX88()) {
            zzXap.zzWzr(paragraph, this.getDocument().zzWod());
        }
        return this.getCurrentParagraph();
    }

    final Paragraph zzWqk() {
        zzWEP zzWEP2;
        Run run;
        Run run2;
        zzYPD zzYPD2;
        this.zzZtO();
        Node node = this.zzXTY();
        Paragraph paragraph = this.getCurrentParagraph();
        if (this.isAtEndOfParagraph()) {
            zzYPD2 = paragraph;
            run2 = zzYPD2.zzWBW(false);
        } else {
            run2 = run = (Run)node.zzXwg(21);
        }
        if (run2 == null && zzW9E.zzWgE(node, paragraph.zzXnw())) {
            run = paragraph.zzXnw();
        }
        if (run != null) {
            zzYPD2 = run.zzZzH();
            zzWEP2 = (zzWEP)((zzWJW)((Object)zzYPD2)).zzYlz();
        } else {
            zzYPD2 = paragraph.zztA();
            zzWEP2 = (zzWEP)((zzWJW)((Object)zzYPD2)).zzYlz();
        }
        zzWEP zzWEP3 = zzWEP2;
        Paragraph paragraph2 = new Paragraph(this.zzWFy, this.zzX2w(), zzWEP3);
        paragraph.getParentNode().insertBefore(paragraph2, paragraph);
        zzY45 zzY452 = new zzY45(this.zzWFy);
        try {
            Node node2 = this.isAtEndOfParagraph() ? null : node;
            paragraph2.zzWqN(paragraph.getFirstChild(), node2, paragraph2.getLastChild());
        }
        finally {
            zzY452.dispose();
        }
        return paragraph2;
    }

    public void insertStyleSeparator() {
        zzme.zzbj(this);
    }

    public void insertBreak(int breakType) {
        this.zzYPI(breakType, true);
    }

    final void zzYPI(int n, boolean bl) {
        switch (n) {
            case 0: {
                this.insertParagraph();
                return;
            }
            case 1: {
                if (this.zzWSq(bl)) {
                    this.zzWu6(ControlChar.PAGE_BREAK);
                }
                return;
            }
            case 2: {
                if (this.zzWSq(bl)) {
                    this.zzWu6(ControlChar.COLUMN_BREAK);
                }
                return;
            }
            case 4: {
                if (this.zzWSq(bl)) {
                    this.zzYpX(1);
                }
                return;
            }
            case 5: {
                if (this.zzWSq(bl)) {
                    this.zzYpX(2);
                }
                return;
            }
            case 3: {
                if (this.zzWSq(bl)) {
                    this.zzYpX(0);
                }
                return;
            }
            case 6: {
                if (this.zzWSq(bl)) {
                    this.zzYpX(3);
                }
                return;
            }
            case 7: {
                if (this.zzWSq(bl)) {
                    this.zzYpX(4);
                }
                return;
            }
            case 8: {
                this.zzWu6(ControlChar.LINE_BREAK);
                return;
            }
        }
        if (bl) {
            throw new IllegalStateException("Unknown break type.");
        }
    }

    public Field insertTableOfContents(String switches) {
        if (!zzJm.zzXeY(switches)) {
            throw new IllegalArgumentException("switches is required.");
        }
        return this.insertField(zzZM9.zzWqN("TOC {0}", switches), "");
    }

    public Field insertField(int fieldType, boolean updateField) throws Exception {
        this.zzZtO();
        return zzWxF.zzYMS(fieldType, updateField, this.zzqG(), this.zzXTY(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode) throws Exception {
        this.zzZtO();
        return zzWxF.zzYMS(fieldCode, this.zzqG(), this.zzXTY(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode, String fieldValue) {
        this.zzZtO();
        return zzWxF.zzYMS(fieldCode, fieldValue, this.zzqG(), this.zzXTY(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertHyperlink(String displayText, String urlOrBookmark, boolean isBookmark) {
        zzW9E.zzWqN((Object)displayText, "displayText");
        zzW9E.zzWqN((Object)urlOrBookmark, "hrefOrBookmark");
        zze4 zze42 = this.zzWqN(urlOrBookmark, isBookmark, "", "");
        this.write(displayText);
        DocumentBuilder documentBuilder = this;
        zze42.zzWqN(documentBuilder.zzM7(88, true));
        return zzWxF.zzYMS(zze42.getStart(), zze42.getSeparator(), zze42.getEnd());
    }

    public FormField insertTextInput(String name, int type, String format, String fieldValue, int maxLength) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (format == null) {
            throw new NullPointerException("format");
        }
        if (fieldValue == null) {
            throw new NullPointerException("fieldValue");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: maxLength");
        }
        this.zzY9f(70);
        if (zzJm.zzXeY(name)) {
            this.startBookmark(name);
        }
        this.zzYiF(" FORMTEXT ");
        FieldSeparator fieldSeparator = this.zzZOP(70);
        String string = zzJm.zzXeY(fieldValue) ? fieldValue : FormField.zzWyE;
        Run run = new Run(this.zzWFy, string, this.zzqG());
        this.insertNode(run);
        Node node = this.zzM7(70, true);
        if (zzJm.zzXeY(name)) {
            node = this.endBookmark(name);
        }
        FormField formField = this.zzrj(fieldSeparator);
        formField.setName(name);
        formField.setTextInputType(type);
        formField.setTextInputFormat(format);
        formField.setResult(fieldValue);
        formField.setMaxLength(maxLength);
        this.zzWqN((Paragraph)node.zzZxo(), node.getNextSibling());
        return formField;
    }

    public FormField insertCheckBox(String name, boolean checkedValue, int size) throws Exception {
        boolean bl = checkedValue;
        return this.insertCheckBox(name, bl, bl, size);
    }

    public FormField insertCheckBox(String name, boolean defaultValue, boolean checkedValue, int size) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: size");
        }
        this.zzY9f(71);
        if (zzJm.zzXeY(name)) {
            this.startBookmark(name);
        }
        this.zzYiF(" FORMCHECKBOX ");
        FieldEnd fieldEnd = this.zzM7(71, false);
        if (zzJm.zzXeY(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzrj(fieldEnd);
        formField.setName(name);
        formField.setDefault(defaultValue);
        formField.setChecked(checkedValue);
        if (size != 0) {
            formField.isCheckBoxExactSize(true);
            formField.setCheckBoxSize(size);
        } else {
            formField.isCheckBoxExactSize(false);
            formField.setCheckBoxSize(10.0);
        }
        return formField;
    }

    public FormField insertComboBox(String name, String[] items, int selectedIndex) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (items == null) {
            throw new NullPointerException("items");
        }
        if (items.length > 25) {
            throw new IllegalArgumentException("items");
        }
        if (selectedIndex < 0 || selectedIndex >= items.length) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: selectedIndex");
        }
        this.zzY9f(83);
        if (zzJm.zzXeY(name)) {
            this.startBookmark(name);
        }
        this.zzYiF(" FORMDROPDOWN ");
        FieldEnd fieldEnd = this.zzM7(83, false);
        if (zzJm.zzXeY(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzrj(fieldEnd);
        formField.setName(name);
        formField.setDropDownSelectedIndex(selectedIndex);
        for (int i = 0; i < items.length; ++i) {
            formField.getDropDownItems().add(items[i]);
        }
        return formField;
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText) {
        return this.insertFootnote(footnoteType, footnoteText, null);
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText, String referenceMark) {
        Footnote footnote = new Footnote(this.zzWFy, footnoteType, !zzJm.zzXeY(referenceMark), referenceMark, this.zzqG());
        Style style = this.getDocument().getStyles().zzZZp(zzWxF.zzZKo(footnoteType));
        footnote.zzZzH().set(50, style.zzZKJ());
        this.insertNode(footnote);
        Paragraph paragraph = new Paragraph(this.zzWFy);
        Style style2 = this.getDocument().getStyles().zzZZp(zzWxF.zzZFQ(footnoteType));
        paragraph.zzWOm().set(1000, style2.zzZKJ());
        footnote.getParagraphs().add(paragraph);
        Inline inline = footnote.isAuto() ? new SpecialChar(this.zzWFy, '\u0002', new zzWEP()) : new Run(this.zzWFy, footnote.getReferenceMark(), new zzWEP());
        inline.zzZzH().set(50, style.zzZKJ());
        paragraph.appendChild(inline);
        if (zzJm.zzXeY(footnoteText)) {
            Node node = this.zzXTY();
            this.moveTo(paragraph);
            this.write(" ");
            this.write(footnoteText);
            this.zzWUv(node);
        }
        return footnote;
    }

    public Shape insertImage(BufferedImage image) throws Exception {
        return this.insertImage(image, -1.0, -1.0);
    }

    public Shape insertImage(String fileName) throws Exception {
        return this.insertImage(fileName, -1.0, -1.0);
    }

    final Shape zzYQF(zzW3N zzW3N2) throws Exception {
        return this.zzYMS(zzW3N2, -1.0, -1.0);
    }

    public Shape insertImage(InputStream stream) throws Exception {
        return this.zzYQF(zzW3N.zzWqN(stream));
    }

    public Shape insertImage(byte[] imageBytes) throws Exception {
        return this.insertImage(imageBytes, -1.0, -1.0);
    }

    public Shape insertImage(BufferedImage image, double width, double height) throws Exception {
        return this.insertImage(image, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(String fileName, double width, double height) throws Exception {
        return this.insertImage(fileName, 2, 0.0, 2, 0.0, width, height, 0);
    }

    private Shape zzYMS(zzW3N zzW3N2, double d, double d2) throws Exception {
        return this.zzYMS(zzW3N2, 2, 0.0, 2, 0.0, d, d2, 0);
    }

    public Shape insertImage(InputStream stream, double width, double height) throws Exception {
        return this.zzYMS(zzW3N.zzWqN(stream), width, height);
    }

    public Shape insertImage(byte[] imageBytes, double width, double height) throws Exception {
        return this.insertImage(imageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(BufferedImage image, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (image == null) {
            throw new NullPointerException("image");
        }
        try (zzXZj zzXZj2 = new zzXZj();){
            zzYEo.zzYMS(image, zzXZj2);
            Shape shape = this.zzYMS(zzXZj2, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
    }

    public Shape insertImage(String fileName, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        zzW9E.zzYMS(fileName, "fileName");
        if (this.getDocument().getResourceLoadingCallback() != null) {
            object = new ResourceLoadingArgs("", fileName, 0);
            switch (this.getDocument().getResourceLoadingCallback().resourceLoading((ResourceLoadingArgs)object)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.insertImage(((ResourceLoadingArgs)object).getData(), horzPos, left, vertPos, top, width, height, wrapType);
                }
                default: {
                    return null;
                }
            }
        }
        object = zzZLz.zzZo7(fileName);
        try {
            Shape shape = this.zzYMS((zzW3N)object, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (object != null) {
                ((zzW3N)object).close();
            }
        }
    }

    private Shape zzYMS(zzW3N zzW3N2, int n, double d, int n2, double d2, double d3, double d4, int n3) throws Exception {
        if (zzW3N2 == null) {
            throw new NullPointerException("stream");
        }
        byte[] byArray = zzW9E.zzWbG(zzW3N2);
        return this.insertImage(byArray, n, d, n2, d2, d3, d4, n3);
    }

    public Shape insertImage(InputStream stream, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzYMS(zzW3N.zzWqN(stream), horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertImage(byte[] imageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzYMS(imageBytes, horzPos, left, vertPos, top, width, height, wrapType, false);
    }

    final Shape zzWTW(byte[] byArray) throws Exception {
        Shape shape = this.zzYMS(byArray, 2, 0.0, 2, 0.0, -1.0, -1.0, 0, true);
        return shape;
    }

    private Shape zzYMS(byte[] byArray, int n, double d, int n2, double d2, double d3, double d4, int n3, boolean bl) throws Exception {
        Object object;
        Shape shape;
        Object object2;
        if (byArray == null) {
            throw new NullPointerException("imageBytes");
        }
        boolean bl2 = zzZOO.zzzz(byArray);
        boolean bl3 = false;
        if (zzZOO.zzZvz(byArray)) {
            object2 = new zzYEo(byArray);
            bl3 = true;
            ((zzYUG)object2).dispose();
        }
        object2 = null;
        boolean bl4 = this.zzWFy.getCompatibilityOptions().getMswVersion() > 12 || this.zzWFy.getCompatibilityOptions().getMswVersion() == 0;
        if (bl4) {
            shape = new Shape((DocumentBase)this.zzWFy, 0);
            object = new zzYUL();
            ((zzZde)object).zzYMS(zzWRZ.zzla("rect"));
            ((zzYUL)object).zzYMS(new zzXLK());
            ((zzYUL)object).zzY4c().zzZvj().zzY2m(this.zzWFy);
            zzYRL zzYRL2 = new zzYRL();
            zzYRL2.zzWqN(new zzZpT(this.zzWFy.zzWCH(), ""));
            zzYRL2.zzYMS(new zzX01());
            ((zzYwZ)object).zzYMS(zzYRL2);
            shape.zzWVH(75);
            shape.zzXGh((zzYwZ)object);
            if (bl2) {
                ((zzYUL)object).zzY4c().zzZvj().setExtensions(new zzW6a<zzWwo>());
                zzWwo zzWwo2 = zzWwo.zzYMS(byArray, this.zzWFy);
                ((zzYUL)object).zzY4c().zzZvj().getExtensions().zzXYy(zzWwo2.getUri(), zzWwo2);
            }
        } else {
            shape = new Shape((DocumentBase)this.zzWFy, 75);
        }
        shape.zzYMS(this.zzqG());
        if (bl2) {
            byArray = shape.getImageData().zzYMS(byArray, new zzXhU(this.getPageSetup().getPageWidth(), this.getPageSetup().getPageHeight()), bl4 ? 6 : 2);
        }
        if (bl4 && bl3) {
            ((zzYUL)shape.zzZ0Y()).zzY4c().zzZvj().zzYPK(byArray);
            object = zzZOO.zzZBR(byArray);
            object2 = new zzXhU(((zzXHg)object).getWidthPoints(), ((zzXHg)object).getHeightPoints());
        } else {
            shape.getImageData().setImageBytes(byArray);
        }
        shape.setRelativeHorizontalPosition(n);
        shape.setLeft(d);
        shape.setRelativeVerticalPosition(n2);
        shape.setTop(d2);
        shape.setWrapType(n3);
        shape.setAspectRatioLocked(true);
        this.insertNode(shape);
        double d5 = 0.0;
        if (!bl && bl4 && zzZOO.zzYDI(byArray)) {
            d5 = DocumentBuilder.zzYMS(shape, byArray);
        }
        shape.zzYMS(d3, d4, (zzXhU)object2, d5);
        if (d5 > 0.0) {
            shape.setRotation(d5);
        }
        return shape;
    }

    private static double zzYMS(Shape shape, byte[] byArray) throws Exception {
        int n = zzZOO.zzWyi(byArray);
        if (n == 1) {
            return 0.0;
        }
        int n2 = zzWxF.zzX5x(n);
        if (n2 != 0) {
            shape.setFlipOrientation(n2);
        }
        double d = zzWxF.zzg1(n);
        return d;
    }

    private Shape zzYMS(zzW3N zzW3N2, String string, boolean bl, zzW3N zzW3N3) throws Exception {
        zzWHu zzWHu2 = zzWHu.zzQb(string);
        Shape shape = this.zzYMS(zzW3N3, bl, zzWHu2, null);
        zzYDz zzYDz2 = zzYeK.zzYMS(zzW3N2, string, bl);
        return DocumentBuilder.zzYMS(null, false, shape, zzWHu2.zzWIt, zzYDz2);
    }

    public Shape insertOleObject(InputStream stream, String progId, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzYMS(zzW3N.zzWqN(stream), progId, asIcon, zzW3N.zzWqN(presentation));
    }

    private Shape zzYMS(String string, boolean bl, boolean bl2, zzW3N zzW3N2) throws Exception {
        zzWHu zzWHu2 = zzWHu.zzXNK(zzZvV.zzZJ2(string));
        return this.zzYMS(string, bl, bl2, zzW3N2, zzWHu2);
    }

    public Shape insertOleObject(String fileName, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzYMS(fileName, isLinked, asIcon, zzW3N.zzWqN(presentation));
    }

    private Shape zzYMS(String string, String string2, boolean bl, boolean bl2, zzW3N zzW3N2) throws Exception {
        zzWHu zzWHu2 = zzWHu.zzQb(string2);
        return this.zzYMS(string, bl, bl2, zzW3N2, zzWHu2);
    }

    public Shape insertOleObject(String fileName, String progId, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzYMS(fileName, progId, isLinked, asIcon, zzW3N.zzWqN(presentation));
    }

    public Shape insertOleObjectAsIcon(String fileName, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzWHu zzWHu2 = zzWHu.zzXNK(zzZvV.zzZJ2(fileName));
        return this.zzYMS(fileName, isLinked, iconFile, iconCaption, zzWHu2);
    }

    public Shape insertOleObjectAsIcon(String fileName, String progId, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzWHu zzWHu2 = zzWHu.zzQb(progId);
        return this.zzYMS(fileName, isLinked, iconFile, iconCaption, zzWHu2);
    }

    private Shape zzYMS(zzW3N zzW3N2, String string, String string2, String string3) throws Exception {
        zzWHu zzWHu2 = zzWHu.zzQb(string);
        Shape shape = this.zzYMS(string2, string3, zzWHu2);
        zzYDz zzYDz2 = zzYeK.zzYMS(zzW3N2, string, true);
        return DocumentBuilder.zzYMS(null, false, shape, zzWHu2.zzWIt, zzYDz2);
    }

    public Shape insertOleObjectAsIcon(InputStream stream, String progId, String iconFile, String iconCaption) throws Exception {
        return this.zzYMS(zzW3N.zzWqN(stream), progId, iconFile, iconCaption);
    }

    final Shape zzYMS(zzZr8 zzZr82, zzW3N zzW3N2) throws Exception {
        Shape shape = this.zzYFc(zzW3N2);
        shape.zzWVH(201);
        shape.getOleFormat().zzWqN(zzZr82.zzWqx());
        return shape;
    }

    public void insertHtml(String html) throws Exception {
        this.insertHtml(html, 0);
    }

    public void insertHtml(String html, boolean useBuilderFormatting) throws Exception {
        int n = useBuilderFormatting ? 1 : 0;
        this.insertHtml(html, n);
    }

    public void insertHtml(String html, int options) throws Exception {
        this.zzZtO();
        if (this.zzWxy()) {
            DocumentBuilder documentBuilder = new DocumentBuilder();
            documentBuilder.insertHtml(html);
            this.write(DocumentBuilder.zzWEA(documentBuilder.getDocument().toString(70)));
            return;
        }
        zzXAj zzXAj2 = zzWxF.zzYMS(html, options, this);
        zzXAj2.zzWcy();
    }

    public Shape insertShape(int shapeType, double width, double height) throws Exception {
        this.zzZtO();
        return zzWxF.zzYMS(this, shapeType, width, height, 0);
    }

    public Shape insertShape(int shapeType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        this.zzZtO();
        return zzWxF.zzYMS(this, shapeType, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertChart(int chartType, double width, double height) throws Exception {
        return this.insertChart(chartType, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertChart(int chartType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        zzYYN zzYYN2 = new zzYYN();
        return zzYYN2.zzYMS(chartType, horzPos, left, vertPos, top, width, height, wrapType, this);
    }

    public Shape insertOnlineVideo(String videoUrl, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzZZR(this).zzYMS(videoUrl, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, videoEmbedCode, thumbnailImageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzZZR(this).zzYMS(videoUrl, videoEmbedCode, thumbnailImageBytes, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions) throws Exception {
        return this.insertSignatureLine(signatureLineOptions, 2, 0.0, 2, 0.0, 0);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions, int horzPos, double left, int vertPos, double top, int wrapType) throws Exception {
        if (signatureLineOptions == null) {
            throw new NullPointerException("signatureLineOptions");
        }
        Shape shape = new Shape((DocumentBase)this.zzWFy, 75);
        shape.zzYMS(this.zzqG());
        shape.zzXIg(true);
        shape.getSignatureLine().zzYMS(signatureLineOptions);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzWyk(ConvertUtil.pixelToPoint(imageSize.getWidthPixels(), 96.0), ConvertUtil.pixelToPoint(imageSize.getHeightPixels(), 96.0));
        return shape;
    }

    public Shape insertHorizontalRule() throws Exception {
        Shape shape = Shape.zzXLN(this.zzWFy);
        this.insertNode(shape);
        return shape;
    }

    private boolean zzWxy() {
        boolean bl = false;
        if (this.zzXTY().getParentNode().getNodeType() == 28) {
            StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.zzXTY().getParentNode();
            switch (structuredDocumentTag.getSdtType()) {
                case 5: 
                case 6: 
                case 12: {
                    bl = true;
                    break;
                }
                case 10: {
                    break;
                }
                case 4: 
                case 13: {
                    throw new IllegalStateException("Can not insert text into this StructuredDocumentTag.");
                }
            }
        }
        return bl;
    }

    private static String zzWEA(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u000b' || c == '\n' || c == '\f' || c == '\r' || c == '\f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Cell insertCell() {
        this.zzZtO();
        if (this.zzZY7() == null) {
            this.startTable();
        }
        if (this.zzZY7().zzYT9() == 1) {
            this.zzZY7().zzZd8();
        }
        if (this.zzZY7().zzYT9() == 3) {
            this.zzZY7().zzYhC();
        }
        return this.zzZY7().zzW5l();
    }

    public Table startTable() {
        this.zzXMb.push(new zz1b(this));
        return this.zzZY7().startTable();
    }

    public Table endTable() {
        if (this.zzZY7() == null) {
            throw new IllegalStateException("Cannot end a table while not building a table.");
        }
        Table table = this.zzZY7().endTable();
        this.zzXMb.pop();
        return table;
    }

    public Row endRow() {
        if (this.zzZY7() == null) {
            throw new IllegalStateException("Cannot end a row while not building a table.");
        }
        Row row = this.zzZY7().endRow();
        if (this.zzZlO != null && this.zzZlO.getHidden()) {
            row.zzXBN().setHidden(true);
        }
        return row;
    }

    public BookmarkStart startBookmark(String bookmarkName) {
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzWFy, bookmarkName, 0);
        this.insertNode(bookmarkStart);
        return bookmarkStart;
    }

    public BookmarkEnd endBookmark(String bookmarkName) {
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzWFy, bookmarkName);
        this.insertNode(bookmarkEnd);
        return bookmarkEnd;
    }

    public BookmarkStart startColumnBookmark(String bookmarkName) {
        Cell cell = this.zzWjR();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be started in a table cell.");
        }
        Cell cell2 = cell.getParentRow().getFirstCell();
        cell2.ensureMinimum();
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzWFy, bookmarkName);
        cell2.getFirstParagraph().insertAfter(bookmarkStart, null);
        int n = cell.zzZRj();
        bookmarkStart.zzZKs(n);
        return bookmarkStart;
    }

    public BookmarkEnd endColumnBookmark(String bookmarkName) {
        Cell cell = this.zzWjR();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be ended in a table cell.");
        }
        Cell cell2 = cell;
        Bookmark bookmark = cell2.getParentRow().getParentTable().getRange().getBookmarks().get(bookmarkName);
        if (bookmark == null) {
            throw new IllegalStateException("The corresponding bookmark start must be in the same table.");
        }
        int n = cell.zzZRj();
        if (bookmark.getBookmarkStart().getFirstColumn() > n) {
            throw new IllegalStateException("The end column index must be greater than or equal to the start column index.");
        }
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzWFy, bookmarkName);
        cell2 = cell;
        cell2.getParentRow().getParentTable().insertAfter(bookmarkEnd, cell.getParentRow());
        bookmark.getBookmarkStart().zzYtP(n);
        return bookmarkEnd;
    }

    public EditableRangeStart startEditableRange() {
        EditableRangeStart editableRangeStart = new EditableRangeStart(this.zzWFy);
        this.zzZdW = editableRangeStart.getId();
        this.insertNode(editableRangeStart);
        return editableRangeStart;
    }

    public EditableRangeEnd endEditableRange() {
        if (this.zzZdW == -1) {
            throw new IllegalStateException("EndEditableRange can not be called before StartEditableRange.");
        }
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzWFy, this.zzZdW);
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public EditableRangeEnd endEditableRange(EditableRangeStart start) {
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzWFy, start.getId());
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public Node insertDocument(Document srcDoc, int importFormatMode) {
        return this.insertDocument(srcDoc, importFormatMode, new ImportFormatOptions());
    }

    public Node insertDocument(Document srcDoc, int importFormatMode, ImportFormatOptions importFormatOptions) {
        zzW9E.zzWqN((Object)importFormatOptions, "ImportFormatOptions");
        this.zzZtO();
        return zzYbj.zzYMS(this, srcDoc, importFormatMode, importFormatOptions);
    }

    public Document getDocument() {
        return this.zzWFy;
    }

    public void setDocument(Document value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value == this.zzWFy) {
            return;
        }
        this.zzWFy = value;
        this.zzWUv(null);
        this.zzXFB = new zzWEP();
        this.zzYsH = null;
        this.zzVU0 = null;
        this.zzZlO = null;
        this.zzXMb = new zzQb();
        this.moveToDocumentStart();
    }

    public Font getFont() {
        if (this.zzZlO == null) {
            DocumentBuilder documentBuilder = this;
            this.zzZlO = new Font(documentBuilder, documentBuilder.getDocument());
        }
        return this.zzZlO;
    }

    public boolean getBold() {
        return this.getFont().getBold();
    }

    public void setBold(boolean value) {
        this.getFont().setBold(value);
    }

    public boolean getItalic() {
        return this.getFont().getItalic();
    }

    public void setItalic(boolean value) {
        this.getFont().setItalic(value);
    }

    public int getUnderline() {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int value) {
        this.getFont().setUnderline(value);
    }

    public ParagraphFormat getParagraphFormat() {
        return this.getCurrentParagraph().getParagraphFormat();
    }

    public ListFormat getListFormat() {
        return this.getCurrentParagraph().getListFormat();
    }

    public PageSetup getPageSetup() {
        return this.getCurrentSection().getPageSetup();
    }

    public RowFormat getRowFormat() {
        if (this.zzY5t == null) {
            this.zzY5t = new RowFormat(this);
        }
        return this.zzY5t;
    }

    public CellFormat getCellFormat() {
        if (this.zzWMD == null) {
            this.zzWMD = new CellFormat(this);
        }
        return this.zzWMD;
    }

    final void zzXbm(Node node) {
        this.getCurrentParagraph().getParentNode().insertBefore(node, this.getCurrentParagraph());
    }

    public void pushFont() {
        zzWEP zzWEP2 = this.getCurrentParagraph().zztA();
        this.zzWCC().push(new zzYMS(this.zzqG(), (zzWEP)zzWEP2.zzYlz()));
    }

    public void popFont() {
        zzQb<zzYMS> zzQb2 = this.zzWCC();
        if (zzQb2.size() > 0) {
            zzYMS zzYMS2 = (zzYMS)this.zzWCC().pop();
            this.zzYMS(zzYMS2.zzZzH(), false);
            this.getCurrentParagraph().zz6g(zzYMS2.zzt());
        }
    }

    final void zzYXM() {
        this.zzWDd().push(this.zzqG());
    }

    final void zzWlN() {
        zzQb<zzWEP> zzQb2 = this.zzWDd();
        if (zzQb2.size() > 0) {
            DocumentBuilder documentBuilder = this;
            documentBuilder.zzYMS((zzWEP)documentBuilder.zzWDd().pop(), false);
        }
    }

    final void zzWpB() {
        this.zz6r().push(this.zzX2w());
    }

    final void zzYc7() {
        zzQb<zzZnI> zzQb2 = this.zz6r();
        if (zzQb2.size() > 0) {
            this.getCurrentParagraph().zzYMS((zzZnI)this.zz6r().pop());
        }
    }

    final zze4 zzWqN(String string, boolean bl, String string2, String string3) {
        FieldStart fieldStart = this.zzY9f(88);
        zzXMo zzXMo2 = new zzXMo();
        zzXMo2.setTarget(string2);
        zzXMo2.setScreenTip(string3);
        if (bl) {
            zzXMo2.setSubAddress(string);
        } else {
            zzXMo2.setAddress(zzum.zzXkM(string));
            zzXMo2.setSubAddress(zzum.zzXf2(string));
        }
        this.zzYiF(zzXMo2.toString());
        FieldSeparator fieldSeparator = this.zzZOP(88);
        return new zze4(fieldStart, fieldSeparator, null);
    }

    final zze4 zzZjh(String string, String string2, String string3) {
        boolean bl = zzum.zzXxN(string);
        String string4 = bl ? zzum.zzXf2(string) : string;
        return this.zzWqN(string4, bl, string2, string3);
    }

    final FieldEnd zzZTa() {
        return this.zzM7(88, true);
    }

    final zzWEP zzqG() {
        zzWEP zzWEP2 = this.zzXFB;
        return (zzWEP)zzWEP2.zzYlz();
    }

    final zzZnI zzX2w() {
        zzZnI zzZnI2 = this.getCurrentParagraph().zzWOm();
        return (zzZnI)zzZnI2.zzYlz();
    }

    final zzXe7 zzX8() {
        zzXe7 zzXe72 = this.zzXBN();
        return (zzXe7)zzXe72.zzYlz();
    }

    final zzYy0 zzff() {
        zzYy0 zzYy02 = this.zzZeq();
        return (zzYy0)zzYy02.zzYlz();
    }

    public boolean isAtStartOfParagraph() {
        for (Node node = this.getCurrentParagraph().getFirstChild(); node != null && node != this.zzXTY(); node = node.getNextSibling()) {
            if (node.getNodeType() == 9 || node.getNodeType() == 10) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAtEndOfParagraph() {
        return this.zzXTY().getNodeType() == 8;
    }

    private void zzVWG(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        String string2 = zzlK.zzX3n(string);
        int n = 0;
        while (n <= string2.length()) {
            int n2;
            int n3 = string2.indexOf(13, n);
            if (n3 != -1) {
                n2 = n3 - n;
                if (n2 > 0) {
                    int n4 = n;
                    this.zz6Z(string2.substring(n4, n4 + n2));
                }
                switch (this.zzWnA) {
                    case 0: {
                        this.insertParagraph();
                        break;
                    }
                    case 1: {
                        this.zzWu6(ControlChar.PARAGRAPH_BREAK);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                n = n3 + 1;
                continue;
            }
            n2 = string2.length() - n;
            if (n2 > 0) {
                int n5 = n;
                this.zz6Z(string2.substring(n5, n5 + n2));
            }
            if (!bl) break;
            this.insertParagraph();
            return;
        }
    }

    public void insertNode(Node node) {
        this.zzZtO();
        if (this.zzZY7() != null && this.zzZY7().zzYT9() == 1) {
            this.endTable();
        }
        if (this.isAtEndOfParagraph()) {
            this.getCurrentParagraph().appendChild(node);
            return;
        }
        this.zzXTY().getParentNode().insertBefore(node, this.zzXTY());
    }

    final void zzWaP(int n) {
        this.zzWSq(true);
        this.zzYpX(n);
    }

    private void zzYpX(int n) {
        this.insertParagraph();
        zzY45 zzY452 = new zzY45(this.getDocument());
        try {
            zzZfz zzZfz2 = this.getCurrentSection().zzZ0v();
            zzZfz zzZfz3 = (zzZfz)zzZfz2.zzYlz();
            Section section = new Section(this.zzWFy, zzZfz3);
            section.getPageSetup().setSectionStart(n);
            section.appendChild(new Body(this.zzWFy));
            this.zzWFy.insertAfter(section, this.getCurrentSection());
            section.getBody().zzWqN(this.getCurrentParagraph(), null, section.getBody().getLastChild());
            return;
        }
        finally {
            zzY452.dispose();
        }
    }

    final FieldStart zzY9f(int n) {
        this.zzZtO();
        return zzWxF.zzYMS(n, this.zzqG(), this.zzXTY(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final Run zzYiF(String string) {
        return zzWxF.zzWqN(string, this.zzqG(), this.zzXTY(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final FieldEnd zzM7(int n, boolean bl) {
        return zzWxF.zzWqN(n, bl, this.zzqG(), this.zzXTY(), this.getCurrentParagraph(), null, true);
    }

    final FieldSeparator zzZOP(int n) {
        return zzWxF.zzWqN(n, this.zzqG(), this.zzXTY(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    private FormField zzrj(Node node) {
        FormField formField = new FormField((DocumentBase)this.zzWFy, new zzF1(), this.zzqG());
        CompositeNode compositeNode = node == null ? this.getCurrentParagraph() : node.getParentNode();
        compositeNode.insertBefore(formField, node);
        return formField;
    }

    private boolean zzWSq(boolean bl) {
        boolean bl2;
        boolean bl3 = this.getCurrentParagraph().getParentStory().getStoryType() != 1;
        boolean bl4 = bl2 = this.zzZY7() != null;
        if (bl) {
            if (bl3) {
                throw new IllegalStateException("Cannot insert the requested break outside of the main story.");
            }
            if (bl2) {
                throw new IllegalStateException("Cannot insert the requested break inside a table.");
            }
        }
        return bl || !bl3 && !bl2;
    }

    private Row zzYGs(int n, int n2) {
        NodeCollection nodeCollection = this.getCurrentStory().getChildNodes(5, true);
        Table table = (Table)nodeCollection.get(n);
        if (table == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: tableIndex");
        }
        Row row = (Row)table.getChild(6, n2, false);
        if (row == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: rowIndex");
        }
        return row;
    }

    private void zz6Z(String string) {
        if (this.zzYD0(string)) {
            zzW3D zzW3D2 = new zzW3D(string, this.getParagraphFormat().getBidi() ? 1 : 0, null);
            for (zzXvY zzXvY2 : zzW3D2.zzrs(this.getParagraphFormat().getBidi())) {
                zzk0 zzk02 = zzk0.zzZJd(zzXvY2.zzXvt());
                zzWEP zzWEP2 = this.zzqG();
                zzWEP2.zzZjh(265, zzk02);
                if (zzXvY2.zz8R()) {
                    zzWEP2.setLocaleIdBi(1037);
                }
                Run run = new Run(this.zzWFy, zzXvY2.getText(), zzWEP2);
                this.insertNode(run);
            }
            return;
        }
        this.zzWu6(string);
    }

    private boolean zzYD0(String string) {
        boolean bl = this.getFont().getBidi();
        for (int i = 0; i < string.length(); ++i) {
            boolean bl2;
            char c = string.charAt(i);
            int n = zzGv.zzZ5Z(c);
            boolean bl3 = n == 0;
            boolean bl4 = bl2 = n == 1 || n == 2;
            if ((!bl || !bl3) && (bl || !bl2)) continue;
            return true;
        }
        return false;
    }

    final void zzYMS(zzWEP zzWEP2, boolean bl) {
        zzWEP zzWEP3;
        if (bl) {
            zzWEP zzWEP4 = zzWEP2;
            zzWEP3 = (zzWEP)zzWEP4.zzYlz();
        } else {
            zzWEP3 = zzWEP2;
        }
        this.zzXFB = zzWEP3;
    }

    final void zzZwl() {
        this.zzXFB.clear();
    }

    final void zzZCg() {
        if (this.zzWjR() != null) {
            zzYy0 zzYy02;
            zzYy0 zzYy03 = zzYy02 = this.zzWjR().zzZeq();
            this.zzQn = (zzYy0)zzYy03.zzYlz();
            zzYy02.zzWqN(this.zzQn);
        }
    }

    private Shape zzYMS(String string, boolean bl, boolean bl2, zzW3N zzW3N2, zzWHu zzWHu2) throws Exception {
        if (zzWHu2 == null) {
            throw new NullPointerException("oleInfo");
        }
        Shape shape = this.zzYMS(zzW3N2, bl2, zzWHu2, string);
        zzYDz zzYDz2 = zzYeK.zzYMS(string, bl, bl2, zzWHu2);
        return DocumentBuilder.zzYMS(string, bl, shape, zzWHu2.zzWIt, zzYDz2);
    }

    private Shape zzYMS(String string, boolean bl, String string2, String string3, zzWHu zzWHu2) throws Exception {
        if (zzWHu2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (string3 == null) {
            string3 = zzZvV.zzPC(string);
        }
        Shape shape = string2 != null ? this.zzYy0(string2, string3) : this.zzYMS(null, string3, zzWHu2);
        zzYDz zzYDz2 = zzYeK.zzYMS(string, bl, true, zzWHu2);
        return DocumentBuilder.zzYMS(string, bl, shape, zzWHu2.zzWIt, zzYDz2);
    }

    private static Shape zzYMS(String string, boolean bl, Shape shape, String string2, zzYDz zzYDz2) {
        if (shape == null) {
            throw new NullPointerException("insertedOleImage");
        }
        shape.zzWVH(-2);
        shape.getOleFormat().setProgId(string2);
        shape.getOleFormat().zzWqN(zzYDz2);
        if (bl) {
            shape.getOleFormat().setSourceFullName(string);
        }
        return shape;
    }

    private Shape zzYMS(zzW3N zzW3N2, boolean bl, zzWHu zzWHu2, String string) throws Exception {
        if (zzWHu2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (zzW3N2 != null) {
            return this.zzYFc(zzW3N2);
        }
        if (!bl) {
            return this.zzYF2(zzYeK.zzX2J().get("normal"));
        }
        String string2 = string != null ? zzZvV.zzPC(string) : zzYeK.zzY0a(zzWHu2.zzWV1);
        return this.zzYMS(zzWHu2, string2);
    }

    private Shape zzYMS(String string, String string2, zzWHu zzWHu2) throws Exception {
        if (zzWHu2 == null) {
            throw new NullPointerException("oleInfo");
        }
        if (string2 == null) {
            string2 = zzYeK.zzY0a(zzWHu2.zzWV1);
        }
        if (string != null) {
            return this.zzYy0(string, string2);
        }
        return this.zzYMS(zzWHu2, string2);
    }

    private Shape zzYMS(zzWHu zzWHu2, String string) throws Exception {
        if (zzWHu2 == null) {
            throw new NullPointerException("oleInfo");
        }
        byte[] byArray = zzYeK.zzYv6(zzWHu2.zzWV1);
        zzYC5 zzYC52 = new zzYC5(byArray, null, string, this.getDocument().zzWlr());
        return this.zzYF2(zzYC52.zzZjQ());
    }

    private Shape zzYy0(String string, String string2) throws Exception {
        zzYC5 zzYC52 = new zzYC5(string, string2, this.getDocument().zzWlr());
        return this.zzYF2(zzYC52.zzZjQ());
    }

    private Shape zzYFc(zzW3N zzW3N2) throws Exception {
        byte[] byArray = zzW9E.zzWbG(zzW3N2);
        return this.zzYF2(byArray);
    }

    private Shape zzYF2(byte[] byArray) throws Exception {
        if (byArray == null) {
            throw new NullPointerException("imageBytes");
        }
        Shape shape = new Shape((DocumentBase)this.zzWFy, 1);
        shape.zzWVH(75);
        shape.zzYMS(this.zzqG());
        shape.getImageData().setImageBytes(byArray);
        shape.setRelativeHorizontalPosition(2);
        shape.setLeft(0.0);
        shape.setRelativeVerticalPosition(2);
        shape.setTop(0.0);
        shape.setWrapType(0);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzWyk(imageSize.getWidthPoints(), imageSize.getHeightPoints());
        return shape;
    }

    private void zzYMS(CompositeNode compositeNode, int n) {
        if (n >= 0) {
            this.zzWqN(compositeNode, n);
            return;
        }
        this.zzWzr(compositeNode, n);
    }

    private void zzWqN(CompositeNode compositeNode, int n) {
        zz6h zz6h2 = zz6h.zzXNH(compositeNode);
        Node node = null;
        while (node != compositeNode) {
            zz6h2.zzYMS(null, true, true, true, false, true);
            node = zz6h2.getNode();
            if (zz6h2.zzXe5() && (!node.isComposite() || node.zzWyE() != 6 || n != 0)) continue;
            int n2 = node.isComposite() ? ((CompositeNode)node).zzXOF().length() : node.getTextLength();
            int n3 = n;
            if (n3 != 0 && (n -= n2) >= 0) continue;
            this.zzWqN(null, node);
            this.zzWUy = n3;
            return;
        }
        throw new IllegalStateException("The character index is too large.");
    }

    private void zzWzr(CompositeNode compositeNode, int n) {
        zz6h zz6h2 = zz6h.zzZJk(compositeNode);
        while (zz6h2.getNode() != compositeNode || !zz6h2.zzXe5()) {
            int n2;
            Node node = zz6h2.getNode();
            int n3 = n2 = node.isComposite() ? ((CompositeNode)node).zzXOF().length() : node.getTextLength();
            if ((n += n2) >= 0) {
                this.zzWqN(null, node);
                this.zzWUy = n;
                return;
            }
            while (zz6h2.zzYMS(null, false, true, true, false, true) && zz6h2.zzXe5() && zz6h2.getNode() != compositeNode) {
            }
        }
        throw new IllegalStateException("The character index is too small.");
    }

    private void zzZtO() {
        int n = this.zzWUy;
        if (n == 0) {
            return;
        }
        this.zzWUy = 0;
        Run run = zzW9E.zzYMS((Object)this.getCurrentNode(), Run.class);
        if (run != null) {
            run.zzW3v(n);
        }
    }

    private Run zzWu6(String string) {
        Run run = new Run(this.zzWFy, string, this.zzqG());
        this.insertNode(run);
        return run;
    }

    final boolean zzWR1() {
        return !this.isAtEndOfParagraph() && this.getCurrentNode().getParentNode().getNodeType() == 17;
    }

    final int zzY34() {
        return this.zzWnA;
    }

    final void zzWyf(int n) {
        this.zzWnA = n;
    }

    public Node getCurrentNode() {
        if (this.isAtEndOfParagraph()) {
            return null;
        }
        return this.zzXTY();
    }

    public Paragraph getCurrentParagraph() {
        if (this.isAtEndOfParagraph()) {
            return (Paragraph)this.zzXTY();
        }
        return (Paragraph)this.zzXTY().getAncestor(8);
    }

    public Story getCurrentStory() {
        return this.getCurrentParagraph().getParentStory();
    }

    public Section getCurrentSection() {
        return (Section)this.getCurrentStory().getParentNode();
    }

    private zz1b zzZY7() {
        zzQb<zz1b> zzQb2 = this.zzXMb;
        if (zzQb2.size() > 0) {
            return (zz1b)this.zzXMb.peek();
        }
        return null;
    }

    private Cell zzWjR() {
        if (this.getCurrentParagraph() == null) {
            return null;
        }
        return this.getCurrentParagraph().zz3C();
    }

    private zzQb<zzWEP> zzWDd() {
        if (this.zzYsH == null) {
            this.zzYsH = new zzQb();
        }
        return this.zzYsH;
    }

    private zzQb<zzZnI> zz6r() {
        if (this.zzVU0 == null) {
            this.zzVU0 = new zzQb();
        }
        return this.zzVU0;
    }

    private zzQb<zzYMS> zzWCC() {
        if (this.zzZrJ == null) {
            this.zzZrJ = new zzQb();
        }
        return this.zzZrJ;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int fontAttr) {
        return this.zzXFB.zzXWJ(fontAttr);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int fontAttr) {
        Object object = this.getFont().getStyle().zzu1(fontAttr, false);
        if (object != null) {
            return object;
        }
        return this.getParagraphFormat().getStyle().zzu1(fontAttr, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int fontAttr, Object value) {
        this.zzXFB.zzZjh(fontAttr, value);
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zz5X()) {
            this.getCurrentParagraph().zztA().zzZjh(fontAttr, value);
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zzXFB.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zzXFB.clear();
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zz5X()) {
            this.getCurrentParagraph().zztA().clear();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRowAttr(int key) {
        return this.zzXBN().zzXWJ(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchRowAttr(int key) {
        return this.zzXBN().zz5A(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRowAttr(int key) {
        return this.zzXBN().zzXXL(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRowAttr(int key, Object value) {
        this.zzXBN().zzZjh(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRowAttrs() {
        this.zzXBN().clearRowAttrs();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void resetToDefaultAttrs() {
        this.zzXBN().clear();
        zzXe7.zzXvC().zzWqN(this.zzXBN());
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzZeq().zzXWJ(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        return this.zzZeq().zz5A(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        return this.zzZeq().zzXXL(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        Border border = zzW9E.zzYMS(value, Border.class);
        if (border != null) {
            CellFormat cellFormat = this.zzWjR() != null ? this.zzWjR().getCellFormat() : this.getCellFormat();
            border.zzYMS(cellFormat);
        }
        this.zzZeq().zzZjh(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzZeq().clear();
    }

    private Node zzXTY() {
        Node node = this.zzVV4 != null && this.zzVV4.getParentNode() == null ? this.zzI0 : this.zzVV4;
        if (node != null && node.zzWyE() == 2) {
            Paragraph paragraph = ((Story)node).getFirstParagraph();
            node = paragraph == null ? ((Section)node.getAncestor(2)).getBody().getFirstParagraph() : paragraph;
        }
        if (node == null) {
            node = this.getDocument().getFirstSection().getBody().getFirstParagraph();
        }
        return node;
    }

    private void zzWUv(Node node) {
        this.zzVV4 = node;
        if (this.zzVV4 != null) {
            this.zzI0 = this.zzVV4.getParentNode();
        }
    }

    private zzXe7 zzXBN() {
        if (this.zzZY7() != null && this.zzZY7().zzYT9() == 1) {
            return this.zzZYv;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().getParentRow().zzXBN();
        }
        return this.zzZYv;
    }

    private zzYy0 zzZeq() {
        if (this.zzZY7() != null && this.zzZY7().zzYT9() != 3) {
            return this.zzQn;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().zz3C().zzZeq();
        }
        return this.zzQn;
    }

    static final class zzYMS {
        private zzWEP zzXFB;
        private zzWEP zzWFf;

        public zzYMS(zzWEP zzWEP2, zzWEP zzWEP3) {
            this.zzXFB = zzWEP2;
            this.zzWFf = zzWEP3;
        }

        public final zzWEP zzZzH() {
            return this.zzXFB;
        }

        public final zzWEP zzt() {
            return this.zzWFf;
        }
    }
}

