/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.internal.zzJm;
import com.aspose.words.internal.zzMy;
import com.aspose.words.internal.zzW3N;
import com.aspose.words.internal.zzW9E;
import com.aspose.words.internal.zzZoK;
import com.aspose.words.internal.zzZpl;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzZUv;
import java.io.EOFException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static HashMap<Integer, Integer> zzWAu = new HashMap();
    private static HashMap<Integer, Integer> zzY7l = new HashMap();
    private static HashMap<Integer, Integer> zzEh = new HashMap();
    private static HashMap<Integer, Integer> zzWS1 = new HashMap();
    private static HashMap<Integer, Integer> zzZ7o = new HashMap();
    private static HashMap<Integer, Integer> zzXy2 = new HashMap();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzW9E.zzYMS(fileName, "fileName");
        try (zzMy zzMy2 = zzW9E.zzX3S(fileName);){
            FileFormatInfo fileFormatInfo = FileFormatUtil.zzYy0(zzMy2);
            return fileFormatInfo;
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zzYy0(zzZoK.zzYMS(stream));
    }

    static FileFormatInfo zzYy0(zzW3N zzW3N2) throws Exception {
        if (zzW3N2 == null) {
            throw new NullPointerException("stream");
        }
        try {
            zzZUv zzZUv2 = new zzZUv();
            zzW3N zzW3N3 = zzW3N2;
            zzZUv zzZUv3 = zzZUv2;
            return zzZUv2.zzWqN(zzW3N3, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzWzr(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzVZ2(zzZpl.zzYbr(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzZ3R(zzZpl.zzYbr(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string;
        if (loadFormat == 12) {
            loadFormat = 10;
        }
        if (zzJm.zzXeY(string = zzZpl.zzZ9r(FileFormatUtil.zzWiU(loadFormat)))) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzVZ2(FileFormatUtil.zzYlY(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzZ3R(FileFormatUtil.zzWiU(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzZpl.zzZ9r(FileFormatUtil.zzYlY(saveFormat));
        if (zzJm.zzXeY(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("extension");
        }
        return FileFormatUtil.zzZ3R(zzZpl.zzWtu(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        return "." + zzZpl.zzZ9r(FileFormatUtil.zzX25(imageType));
    }

    static Exception zzWzr(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzYJw(int n) {
        return zzZpl.toString(FileFormatUtil.zzYlY(n));
    }

    static int zzZ3R(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzW9E.zzYMS(zzZ7o, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 0;
    }

    static int zzY54(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzW9E.zzYMS(zzXy2, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 1;
    }

    static boolean zzWLh(int n) {
        return n == 20 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 31;
    }

    private static int zzWiU(int n) {
        return zzW9E.zzYMS(zzWAu, Integer.valueOf(n), Integer.valueOf(0));
    }

    static int zzYlY(int n) {
        return zzW9E.zzYMS(zzY7l, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzX25(int n) {
        return zzW9E.zzYMS(zzEh, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzVZ2(int n) {
        return zzW9E.zzYMS(zzWS1, Integer.valueOf(n), Integer.valueOf(255));
    }

    private static void zzZjh(int n, int n2, int n3, int n4) {
        if (n2 != 0) {
            zzW9E.zzWqN(zzZ7o, Integer.valueOf(n), Integer.valueOf(n2));
            zzW9E.zzWqN(zzY7l, Integer.valueOf(n2), Integer.valueOf(n));
        }
        if (n3 != 255) {
            if (!zzWS1.containsKey(n)) {
                zzW9E.zzWqN(zzWS1, Integer.valueOf(n), Integer.valueOf(n3));
            }
            zzW9E.zzWqN(zzWAu, Integer.valueOf(n3), Integer.valueOf(n));
        }
        if (n4 != 1) {
            zzW9E.zzWqN(zzXy2, Integer.valueOf(n), Integer.valueOf(n4));
            zzW9E.zzWqN(zzEh, Integer.valueOf(n4), Integer.valueOf(n));
        }
    }

    static {
        FileFormatUtil.zzZjh(11, 10, 10, 1);
        FileFormatUtil.zzZjh(11, 0, 0, 1);
        FileFormatUtil.zzZjh(12, 11, 11, 1);
        FileFormatUtil.zzZjh(13, 20, 20, 1);
        FileFormatUtil.zzZjh(13, 0, 254, 1);
        FileFormatUtil.zzZjh(14, 21, 21, 1);
        FileFormatUtil.zzZjh(15, 22, 22, 1);
        FileFormatUtil.zzZjh(16, 23, 23, 1);
        FileFormatUtil.zzZjh(18, 24, 24, 1);
        FileFormatUtil.zzZjh(19, 25, 25, 1);
        FileFormatUtil.zzZjh(20, 26, 26, 1);
        FileFormatUtil.zzZjh(21, 27, 27, 1);
        FileFormatUtil.zzZjh(24, 30, 30, 1);
        FileFormatUtil.zzZjh(17, 31, 31, 1);
        FileFormatUtil.zzZjh(25, 50, 50, 1);
        FileFormatUtil.zzZjh(26, 45, 255, 1);
        FileFormatUtil.zzZjh(27, 51, 51, 1);
        FileFormatUtil.zzZjh(28, 0, 52, 1);
        FileFormatUtil.zzZjh(29, 0, 53, 1);
        FileFormatUtil.zzZjh(22, 60, 60, 1);
        FileFormatUtil.zzZjh(23, 61, 61, 1);
        FileFormatUtil.zzZjh(33, 40, 64, 1);
        FileFormatUtil.zzZjh(40, 47, 255, 1);
        FileFormatUtil.zzZjh(41, 48, 255, 1);
        FileFormatUtil.zzZjh(34, 41, 255, 1);
        FileFormatUtil.zzZjh(35, 46, 255, 1);
        FileFormatUtil.zzZjh(37, 42, 255, 1);
        FileFormatUtil.zzZjh(36, 44, 255, 1);
        FileFormatUtil.zzZjh(30, 52, 255, 1);
        FileFormatUtil.zzZjh(31, 70, 62, 1);
        FileFormatUtil.zzZjh(32, 73, 63, 1);
        FileFormatUtil.zzZjh(38, 71, 255, 1);
        FileFormatUtil.zzZjh(8, 100, 255, 1);
        FileFormatUtil.zzZjh(9, 105, 255, 1);
        FileFormatUtil.zzZjh(6, 101, 255, 6);
        FileFormatUtil.zzZjh(7, 102, 255, 7);
        FileFormatUtil.zzZjh(5, 104, 255, 5);
        FileFormatUtil.zzZjh(4, 0, 255, 4);
        FileFormatUtil.zzZjh(3, 0, 255, 3);
        FileFormatUtil.zzZjh(39, 72, 255, 1);
        FileFormatUtil.zzZjh(2, 103, 255, 2);
    }
}

