/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.GlossaryDocument;
import com.aspose.words.Range;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zzQb;
import com.aspose.words.internal.zzW9E;
import com.aspose.words.zz6h;
import com.aspose.words.zzWxF;
import com.aspose.words.zzYWj;
import com.aspose.words.zzZ7H;

public abstract class Node
implements Cloneable {
    private Node zzWU1;
    private Node zzXGB;
    private Node zzXQq;
    private int zzZFg;

    protected Node() {
    }

    protected Node(DocumentBase doc) {
        this();
        this.zzY2m(doc);
    }

    public abstract int getNodeType();

    public CompositeNode getParentNode() {
        if (this.zzWU1 == null) {
            return null;
        }
        if (this.zzWU1.getNodeType() == 38) {
            return null;
        }
        return (CompositeNode)this.zzWU1;
    }

    final CompositeNode zzZxo() {
        if (zzWxF.zzXYn(this.getParentNode())) {
            return this.getParentNode().zzZxo();
        }
        return this.getParentNode();
    }

    final CompositeNode zzcX() {
        if (zzWxF.zzXYn(this.getParentNode()) || zzWxF.zzcm(this.getParentNode())) {
            return this.getParentNode().zzcX();
        }
        return this.getParentNode();
    }

    public DocumentBase getDocument() {
        if (this.zzWU1 != null) {
            return this.zzWU1.getDocument();
        }
        return null;
    }

    final Document zz28() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        throw new IllegalStateException("This operation requires the node to be inside the main document.");
    }

    final Document zzXfG() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        return ((GlossaryDocument)documentBase).zz1M();
    }

    public Node getPreviousSibling() {
        Node node = this;
        return node.zzXQq;
    }

    final Node zzZWZ() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getPreviousSibling()) != null && zzWxF.zzJn((node = node2).getNodeType())) {
        }
        return node2;
    }

    final Node zzZ1b() {
        Node node = zzWxF.zzWbG(this.getPreviousSibling(), false);
        if (node == null && zzWxF.zzXYn(this.getParentNode())) {
            node = this.getParentNode().zzZ1b();
        }
        return node;
    }

    final Node zzZlz() {
        Node node = zzWxF.zzbj(this.getNextSibling(), false);
        if (node == null && zzWxF.zzXYn(this.getParentNode())) {
            node = this.getParentNode().zzZlz();
        }
        return node;
    }

    final CompositeNode zzW9i() {
        Node node = this;
        while ((node = node.zzZ1b()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    final CompositeNode zzZpo() {
        Node node = this;
        while ((node = node.zzZlz()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    public Node getNextSibling() {
        Node node = this;
        return node.zzXGB;
    }

    final Node zzab() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getNextSibling()) != null && zzWxF.zzJn((node = node2).getNodeType())) {
        }
        return node2;
    }

    public boolean isComposite() {
        return false;
    }

    public Range getRange() {
        return new Range(this);
    }

    final boolean zzYYn() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getLastChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzY9a() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getFirstChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzmy() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (zzWxF.zzZXy(node)) continue;
            return false;
        }
        return true;
    }

    final Node zzXmW() {
        return this.zzXGB;
    }

    final void zzZ4f(Node node) {
        this.zzXGB = node;
    }

    final Node zzWaN() {
        return this.zzXQq;
    }

    final void zzWiT(Node node) {
        this.zzXQq = node;
    }

    final Node zzYRX() {
        Node node = this;
        if (node.zzXGB != null) {
            node = this;
            return node.zzXGB;
        }
        return this.getParentNode();
    }

    final int zzWyE() {
        int n;
        switch (this.getNodeType()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
        }
        boolean bl = zzWxF.zzoL(this);
        boolean bl2 = zzWxF.zzZd6(this);
        boolean bl3 = zzWxF.zzZJS(this);
        boolean bl4 = zzWxF.zzVVt(this);
        CompositeNode compositeNode = this.getParentNode();
        int n2 = compositeNode != null && compositeNode.getNodeType() == 28 ? this.getParentNode().zzWyE() : 7;
        int n3 = n = compositeNode != null ? compositeNode.getNodeType() : 38;
        if (bl4 && (!bl && !bl2 && !bl3 || n2 == 4 || n == 5)) {
            return 4;
        }
        if (bl3 && (!bl && !bl2 || n2 == 5 || n == 6)) {
            return 5;
        }
        if (bl2 && (!bl || n2 == 3 || compositeNode != null && compositeNode.zzWyE() != 3 && n2 != 6 && n != 27 && n != 35)) {
            return 3;
        }
        if (bl) {
            return 6;
        }
        return 7;
    }

    public Node deepClone(boolean isCloneChildren) {
        return this.zzYMS(isCloneChildren, null);
    }

    Node zzYMS(boolean bl, zzZ7H zzZ7H2) {
        Node node = (Node)this.memberwiseClone();
        if (this.zzWU1 != null) {
            node.zzWU1 = this.getDocument().zz1R();
        }
        node.zzXGB = null;
        node.zzXQq = null;
        if (zzZ7H2 != null) {
            zzZ7H2.zzY2m(this, node);
        }
        return node;
    }

    public abstract boolean accept(DocumentVisitor var1) throws Exception;

    protected static boolean visitorActionToBool(int action) {
        switch (action) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown visitor action.");
    }

    public String getText() {
        return "";
    }

    void zzX3S(StringBuilder stringBuilder) {
        zzW9E.zzWqN(stringBuilder, this.getText());
    }

    public CompositeNode getAncestor(Class ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (!ancestorType.isInstance(compositeNode)) continue;
            return compositeNode;
        }
        return null;
    }

    public CompositeNode getAncestor(int ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() != ancestorType) continue;
            return compositeNode;
        }
        return null;
    }

    public void remove() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("Cannot remove because there is no parent.");
        }
        this.getParentNode().removeChild(this);
    }

    final void zzYoP(Node node) {
        this.zzWU1 = node != null ? node : this.getDocument().zz1R();
    }

    final void zzY2m(DocumentBase documentBase) {
        this.zzWU1 = documentBase != null ? documentBase.zz1R() : null;
    }

    final boolean zzae(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null && compositeNode != this; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode != node) continue;
            return true;
        }
        return false;
    }

    final Node zzVUY() {
        if (this.getParentNode() == null) {
            return this.getDocument();
        }
        Node node = this;
        while (node.getParentNode() != null) {
            node = node.getParentNode();
        }
        return node;
    }

    int getTextLength() {
        return this.getText().length();
    }

    public Node nextPreOrder(Node rootNode) {
        Node node = this.isComposite() ? ((CompositeNode)this).getFirstChild() : null;
        if (node == null) {
            for (node = this; node != null && node != rootNode && node.getNextSibling() == null; node = node.getParentNode()) {
            }
            if (node != null && node != rootNode) {
                node = node.getNextSibling();
            }
        }
        if (node == rootNode) {
            node = null;
        }
        return node;
    }

    public Node previousPreOrder(Node rootNode) {
        Node node;
        Node node2 = this.getPreviousSibling();
        while (node2 != null && (node = node2.isComposite() ? ((CompositeNode)node2).getLastChild() : null) != null) {
            node2 = node;
        }
        if (node2 == null) {
            node2 = this.getParentNode();
        }
        if (node2 == rootNode) {
            node2 = null;
        }
        return node2;
    }

    final Node zzYe(int n) {
        Node node;
        for (node = this.getNextSibling(); node != null && n != node.getNodeType(); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzXwg(int n) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && n != node.getNodeType(); node = node.getPreviousSibling()) {
        }
        return node;
    }

    final Node zzWgE(Node node, int n) {
        Node node2;
        for (node2 = this.previousPreOrder(node); node2 != null && node2.getNodeType() != n; node2 = node2.previousPreOrder(node)) {
        }
        return node2;
    }

    final Node zzW9s(boolean bl) {
        if (bl) {
            return this.getNextSibling();
        }
        return this.getPreviousSibling();
    }

    public String toString(int saveFormat) throws Exception {
        zzYWj zzYWj2 = zzWxF.zzZmq(saveFormat);
        return zzYWj2.zzuL(this);
    }

    public String toString(SaveOptions saveOptions) throws Exception {
        zzYWj zzYWj2 = zzWxF.zzYMS(saveOptions);
        return zzYWj2.zzuL(this);
    }

    final Node zzY0B(int n) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() == n) {
                return compositeNode;
            }
            if (!zzWxF.zzWyk(compositeNode)) continue;
            if (n != 0) break;
            return compositeNode;
        }
        return null;
    }

    final zz6h zzPJ() {
        Node node = this.getPreviousSibling();
        if (node != null) {
            return zz6h.zzZJk(node);
        }
        return zz6h.zzXNH(this.getParentNode());
    }

    final zz6h zzWUO() {
        Node node = this.getNextSibling();
        if (node != null) {
            return zz6h.zzXNH(node);
        }
        return zz6h.zzZJk(this.getParentNode());
    }

    final boolean zzWfT(Node node) {
        return Node.zzWBM(this, node);
    }

    final boolean zzXz() {
        return this.getAncestor(1) == null;
    }

    static Node zzYbt(Node node, Node node2) {
        if (node == node2) {
            return node;
        }
        if (node == null || node2 == null) {
            return null;
        }
        zzQb<Node> zzQb2 = Node.zzYhf(node);
        zzQb<Node> zzQb3 = Node.zzYhf(node2);
        return Node.zzYMS(zzQb2, zzQb3);
    }

    static boolean zzWBM(Node node, Node node2) {
        zzQb<Node> zzQb2;
        if (node == null || node2 == null) {
            return false;
        }
        zzQb<Node> zzQb3 = Node.zzYhf(node);
        Node node3 = Node.zzYMS(zzQb3, zzQb2 = Node.zzYhf(node2));
        if (node3 == null) {
            return false;
        }
        zzQb<Node> zzQb4 = zzQb3;
        if (zzQb4.size() == 0 || (zzQb4 = zzQb2).size() == 0) {
            zzQb4 = zzQb2;
            boolean bl = zzQb4.size() > 0;
            return bl;
        }
        Object e = zzQb3.peek();
        Object e2 = zzQb2.peek();
        for (Node node4 : ((CompositeNode)node3).getChildNodes()) {
            if (node4 == e) {
                return true;
            }
            if (node4 != e2) continue;
            return false;
        }
        return false;
    }

    private static zzQb<Node> zzYhf(Node node) {
        zzQb<Node> zzQb2 = new zzQb<Node>();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            zzQb2.push(node2);
        }
        return zzQb2;
    }

    private static Node zzYMS(zzQb<Node> zzQb2, zzQb<Node> zzQb3) {
        Node node = null;
        while (zzQb2.peek() == zzQb3.peek()) {
            node = (Node)zzQb2.pop();
            zzQb3.pop();
            zzQb<Node> zzQb4 = zzQb2;
            if (zzQb4.size() != 0 && (zzQb4 = zzQb3).size() != 0) continue;
        }
        return node;
    }

    public static String nodeTypeToString(int nodeType) {
        switch (nodeType) {
            case 0: {
                return "Any";
            }
            case 1: {
                return "Document";
            }
            case 2: {
                return "Section";
            }
            case 3: {
                return "Body";
            }
            case 4: {
                return "HeaderFooter";
            }
            case 5: {
                return "Table";
            }
            case 6: {
                return "Row";
            }
            case 7: {
                return "Cell";
            }
            case 8: {
                return "Paragraph";
            }
            case 9: {
                return "BookmarkStart";
            }
            case 10: {
                return "BookmarkEnd";
            }
            case 17: {
                return "GroupShape";
            }
            case 18: {
                return "Shape";
            }
            case 19: {
                return "Comment";
            }
            case 20: {
                return "Footnote";
            }
            case 21: {
                return "Run";
            }
            case 22: {
                return "FieldStart";
            }
            case 23: {
                return "FieldSeparator";
            }
            case 24: {
                return "FieldEnd";
            }
            case 25: {
                return "FormField";
            }
            case 26: {
                return "SpecialChar";
            }
            case 27: {
                return "SmartTag";
            }
            case 28: {
                return "StructuredDocumentTag";
            }
            case 29: {
                return "StructuredDocumentTagRangeStart";
            }
            case 30: {
                return "StructuredDocumentTagRangeEnd";
            }
            case 31: {
                return "GlossaryDocument";
            }
            case 32: {
                return "BuildingBlock";
            }
            case 33: {
                return "CommentRangeStart";
            }
            case 34: {
                return "CommentRangeEnd";
            }
            case 13: {
                return "MoveFromRangeStart";
            }
            case 14: {
                return "MoveFromRangeEnd";
            }
            case 15: {
                return "MoveToRangeStart";
            }
            case 16: {
                return "MoveToRangeEnd";
            }
            case 11: {
                return "EditableRangeStart";
            }
            case 12: {
                return "EditableRangeEnd";
            }
            case 35: {
                return "OfficeMath";
            }
            case 36: {
                return "SubDocument";
            }
            case 37: {
                return "System";
            }
            case 38: {
                return "Null";
            }
        }
        return "Unknown node type.";
    }

    public int getCustomNodeId() {
        return this.zzZFg;
    }

    public void setCustomNodeId(int value) {
        this.zzZFg = value;
    }

    public String toString() {
        return super.toString();
    }

    public void dd() {
    }

    final Node zzYfu(int ... nArray) {
        Node node;
        for (node = this.getNextSibling(); node != null && !node.zzXKr(nArray); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzfp(int ... nArray) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && !node.zzXKr(nArray); node = node.getPreviousSibling()) {
        }
        return node;
    }

    private boolean zzXKr(int ... nArray) {
        int[] nArray2 = nArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[i];
            if (this.getNodeType() != n2) continue;
            return true;
        }
        return false;
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }
}

