/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.Node;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.internal.zzW9E;
import com.aspose.words.zzVRL;
import com.aspose.words.zzW2U;
import com.aspose.words.zzXhZ;
import com.aspose.words.zzgj;
import java.util.ArrayList;
import java.util.Iterator;

public class NodeCollection<T extends Node>
implements zzgj,
Iterable<T> {
    private Node zzYGt;
    private CompositeNode zzZDH;
    private DocumentBase zzYtE;
    private boolean zzWU;
    private int zzZ9b;
    private int zzX6X;
    private Node zzVTO;
    private int zzZjl;
    private zzXhZ zzY7z;

    NodeCollection(CompositeNode container, int nodeType, boolean isDeep) {
        this(container, zzVRL.zzW0s(nodeType), isDeep);
    }

    NodeCollection(CompositeNode container, int[] nodeTypes, boolean isDeep) {
        this(container, new zzVRL(nodeTypes), isDeep);
    }

    NodeCollection(CompositeNode container, zzXhZ matcher, boolean isDeep) {
        if (container == null) {
            throw new NullPointerException("container");
        }
        if (matcher == null) {
            throw new NullPointerException("matcher");
        }
        this.zzZDH = container;
        this.zzYtE = container.getDocument();
        this.zzY7z = matcher;
        this.zzWU = isDeep;
        this.zzXtu();
    }

    public Node get(int index) {
        try {
            this.zzXOf();
            if (index < 0 && (index = this.getCount() + index) < 0) {
                return null;
            }
            if (this.zzX6X == index) {
                return this.zzVTO;
            }
            int n = index - this.zzX6X;
            NodeCollection nodeCollection = this;
            Node node = nodeCollection.zzX9W(nodeCollection.zzVTO, n);
            if (node != null) {
                this.zzX6X = index;
                this.zzVTO = node;
            }
            return node;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void add(Node node) {
        if (this.zzWU) {
            throw new UnsupportedOperationException("Adding nodes is not yet supported for deep node collections.");
        }
        this.zzZDH.appendChild(node);
    }

    public void insert(int index, Node node) {
        if (this.zzWU) {
            throw new UnsupportedOperationException("Inserting nodes is not yet supported for deep node collections.");
        }
        this.zzZDH.insertBefore(node, this.get(index));
    }

    public void remove(Node node) {
        node.remove();
    }

    public void removeAt(int index) {
        this.get(index).remove();
    }

    public void clear() {
        for (Node node : this) {
            node.remove();
        }
    }

    public boolean contains(Node node) {
        return this.indexOf(node) != -1;
    }

    public int indexOf(Node node) {
        int n = 0;
        for (Node node2 : this) {
            if (node == node2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Node[] toArray() {
        Node[] nodeArray = new Node[]{};
        ArrayList arrayList = this.zz4x();
        return arrayList.toArray(nodeArray);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzW2U(this);
    }

    final <TNode extends Node> zzW2U<TNode> zzZI() {
        return new zzW2U(this);
    }

    final <TValue extends Node> ArrayList<TValue> zz4x() {
        ArrayList arrayList = new ArrayList();
        for (Node node : this) {
            zzW9E.zzYMS(arrayList, node);
        }
        return arrayList;
    }

    private Node zzX9W(Node node, int n) throws Exception {
        boolean bl;
        boolean bl2 = bl = n > 0;
        if (n < 0) {
            n = -n;
        }
        Node node2 = node;
        for (int i = 0; i < n; ++i) {
            if ((node2 = this.zzZKr(node2, bl)) != null) continue;
            return null;
        }
        return node2;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) throws Exception {
        return this.zzZZk(curNode, true);
    }

    private Node zzZZk(Node node, boolean bl) throws Exception {
        Node node2;
        this.zzYGt = node;
        do {
            node2 = this.zzYGt;
            Node node3 = this.zzWU ? this.zzYMS(true, this.zzYGt) : (this.zzYGt = this.zzY7z.zzWWD() ? this.zzWzr(true, this.zzYGt) : this.zzWqN(true, this.zzYGt));
        } while (this.zzYGt != null && !this.zzY7z.zzX9W(this.zzYGt));
        return node2;
    }

    private Node zzZKr(Node node, boolean bl) throws Exception {
        while ((this.zzWU ? this.zzYMS(bl, node) : (node = this.zzY7z.zzWWD() ? this.zzWzr(bl, node) : this.zzWqN(bl, node))) != null && !this.zzY7z.zzX9W(node)) {
        }
        return node;
    }

    private Node zzYMS(boolean bl, Node node) {
        if (bl) {
            return node.nextPreOrder(this.zzZDH);
        }
        return node.previousPreOrder(this.zzZDH);
    }

    private Node zzWqN(boolean bl, Node node) {
        if (bl) {
            if (node == this.zzZDH) {
                return this.zzZDH.getFirstChild();
            }
            return node.getNextSibling();
        }
        if (node == this.zzZDH) {
            return this.zzZDH.getLastChild();
        }
        return node.getPreviousSibling();
    }

    private Node zzWzr(boolean bl, Node node) {
        Node node2;
        if (bl) {
            node2 = node == this.zzZDH ? this.zzZDH.zzHl() : node.zzZlz();
        } else {
            Node node3 = node2 = node == this.zzZDH ? this.zzZDH.zzZoh() : node.zzZ1b();
        }
        if (node2 == this.zzZDH.getNextSibling() || node2 == this.zzZDH.getPreviousSibling()) {
            node2 = null;
        }
        return node2;
    }

    private void zzXOf() {
        if (this.zzZ9b != this.zzYJ8()) {
            this.zzXtu();
        }
    }

    private void zzXtu() {
        this.zzZ9b = this.zzYJ8();
        this.zzX6X = -1;
        this.zzVTO = this.zzZDH;
        this.zzZjl = -1;
    }

    private int zzYJ8() {
        if (this.zzYtE != null) {
            return this.zzYtE.zzXoD();
        }
        return 0;
    }

    public int getCount() {
        this.zzXOf();
        if (this.zzZjl == -1) {
            this.zzZjl = zzW2U.zzYMS(this);
        }
        return this.zzZjl;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzYGt;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this.zzZDH;
    }
}

