/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.MarkdownSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PclSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XpsSaveOptions;
import com.aspose.words.internal.zzZpl;
import com.aspose.words.internal.zzZvV;

public abstract class SaveOptions {
    private boolean zzWqL;
    private boolean zzX43 = true;
    private boolean zzXKi = false;
    private boolean zzXiB = true;
    private boolean zzXMU;
    private String zz0F;
    private boolean zzXV1;
    private boolean zzWKV = false;
    private boolean zzWl = true;
    private int zzXw9 = 1;
    private int zzyZ = 1;
    private int zzZXM = 0;
    private String zzWtr = "";
    private boolean zzXfe = true;
    private boolean zzZWq = true;
    private boolean zzXV;
    private boolean zzo4;
    private int zztw = 0;
    private boolean zzWZz = true;
    private boolean zzZWh = false;
    private boolean zzXQM = true;

    protected SaveOptions() {
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzW0Z() {
        return false;
    }

    boolean zzZmw() {
        return true;
    }

    public boolean getExportGeneratorName() {
        return this.zzXiB;
    }

    public void setExportGeneratorName(boolean value) {
        this.zzXiB = value;
    }

    public String getTempFolder() {
        return this.zz0F;
    }

    public void setTempFolder(String value) {
        this.zz0F = value;
    }

    public boolean getPrettyFormat() {
        return this.zzXMU;
    }

    public void setPrettyFormat(boolean value) {
        this.zzXMU = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzXV1;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzXV1 = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzWKV;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzWKV = value;
    }

    public boolean getUpdateSdtContent() {
        return this.zzWl;
    }

    public void setUpdateSdtContent(boolean value) {
        this.zzWl = value;
    }

    public int getDmlRenderingMode() {
        return this.zzXw9;
    }

    public void setDmlRenderingMode(int value) {
        this.zzXw9 = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzZXM;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzZXM = value;
    }

    public int getImlRenderingMode() {
        return this.zzyZ;
    }

    public void setImlRenderingMode(int value) {
        this.zzyZ = value;
    }

    public String getDefaultTemplate() {
        return this.zzWtr;
    }

    public void setDefaultTemplate(String value) {
        this.zzWtr = value;
    }

    public boolean getUpdateFields() {
        return this.zzXfe;
    }

    public void setUpdateFields(boolean value) {
        this.zzXfe = value;
    }

    public boolean getUpdateLastSavedTimeProperty() {
        return this.zzXV;
    }

    public void setUpdateLastSavedTimeProperty(boolean value) {
        this.zzXV = value;
    }

    public boolean getUpdateLastPrintedProperty() {
        return this.zzo4;
    }

    public void setUpdateLastPrintedProperty(boolean value) {
        this.zzo4 = value;
    }

    public boolean getUpdateCreatedTimeProperty() {
        return this.zzZWh;
    }

    public void setUpdateCreatedTimeProperty(boolean value) {
        this.zzZWh = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzXKi;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzXKi = value;
    }

    final boolean zzSh() {
        return this.zzZWq;
    }

    final boolean zzZ39() {
        return this.zzWZz;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 48: {
                return new PclSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 73: {
                return new MarkdownSaveOptions();
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return new ImageSaveOptions(saveFormat);
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzZ3R(zzZpl.zzWtu(zzZvV.zzZJ2(fileName))));
    }

    public int getDml3DEffectsRenderingMode() {
        return this.zztw;
    }

    public void setDml3DEffectsRenderingMode(int value) {
        this.zztw = value;
    }

    public boolean getAllowEmbeddingPostScriptFonts() {
        return this.zzWqL;
    }

    public void setAllowEmbeddingPostScriptFonts(boolean value) {
        this.zzWqL = value;
    }

    public boolean getFlatOpcXmlMappingOnly() {
        return this.zzXQM;
    }

    public void setFlatOpcXmlMappingOnly(boolean value) {
        this.zzXQM = value;
    }

    final boolean zzXug() {
        return this.zzX43;
    }
}

