/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.HeaderFooter;
import com.aspose.words.HeaderFooterCollection;
import com.aspose.words.Node;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Shape;
import com.aspose.words.Story;
import com.aspose.words.internal.zzW9E;
import com.aspose.words.zzOB;
import com.aspose.words.zzZ7H;
import com.aspose.words.zzZfz;

public final class Section
extends CompositeNode<Node>
implements zzOB {
    private zzZfz zzWSG;
    private PageSetup zzZur;
    private HeaderFooterCollection zzWhQ;

    public Section(DocumentBase doc) {
        this(doc, new zzZfz());
    }

    Section(DocumentBase doc, zzZfz sectPr) {
        super(doc);
        this.zzWSG = sectPr;
    }

    @Override
    public final int getNodeType() {
        return 2;
    }

    public final Body getBody() {
        return (Body)this.getChild(3, 0, false);
    }

    public final HeaderFooterCollection getHeadersFooters() {
        if (this.zzWhQ == null) {
            this.zzWhQ = new HeaderFooterCollection(this);
        }
        return this.zzWhQ;
    }

    public final PageSetup getPageSetup() {
        if (this.zzZur == null) {
            Section section = this;
            this.zzZur = new PageSetup(section, section.getDocument().zzXB9(), this.getDocument().getStyles(), new zzYMS(this));
        }
        return this.zzZur;
    }

    public final boolean getProtectedForForms() {
        return !this.getPageSetup().zzZY();
    }

    public final void setProtectedForForms(boolean value) {
        this.getPageSetup().zzXLK(!value);
    }

    final zzZfz zzZ0v() {
        return this.zzWSG;
    }

    final void zzWzr(zzZfz zzZfz2) {
        this.zzWSG = zzZfz2;
    }

    public final Section deepClone() {
        return (Section)this.deepClone(true);
    }

    @Override
    final Node zzYMS(boolean bl, zzZ7H zzZ7H2) {
        zzZfz zzZfz2;
        Section section = (Section)super.zzYMS(bl, zzZ7H2);
        zzZfz zzZfz3 = this.zzWSG;
        section.zzWSG = zzZfz2 = (zzZfz)zzZfz3.zzYlz();
        section.zzZur = null;
        section.zzWhQ = null;
        return section;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzYMS(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionStart(this);
    }

    @Override
    final int zzWqN(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitSectionEnd(this);
    }

    public final void prependContent(Section sourceSection) {
        this.zzY2m(sourceSection, false);
    }

    public final void appendContent(Section sourceSection) {
        this.zzY2m(sourceSection, true);
    }

    public final void clearContent() {
        this.clearHeadersFooters();
        this.getBody().removeAllChildren();
        this.getBody().ensureMinimum();
    }

    public final void clearHeadersFooters() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).removeAllChildren();
        }
    }

    public final void deleteHeaderFooterShapes() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).deleteShapes();
        }
    }

    public final void ensureMinimum() {
        Body body = this.getBody();
        if (body == null) {
            body = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body.ensureMinimum();
    }

    final Story zzWUS(int n) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (((Story)node).getStoryType() != n) continue;
            return (Story)node;
        }
        return null;
    }

    @Override
    final boolean zzWbG(Node node) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                int n = ((Story)node).getStoryType();
                return this.zzWUS(n) == null;
            }
        }
        return false;
    }

    final void zzWzr(Shape shape, boolean bl) {
        this.zzYMS(shape, 4, bl);
        this.zzYMS(shape, 0, bl);
        this.zzYMS(shape, 1, bl);
    }

    private void zzYMS(Shape shape, int n, boolean bl) {
        HeaderFooter headerFooter = this.getHeadersFooters().getByHeaderFooterType(n);
        if (headerFooter == null) {
            if (!bl) {
                return;
            }
            headerFooter = new HeaderFooter(this.getDocument(), n);
            this.getHeadersFooters().add(headerFooter);
        }
        if (headerFooter.getParagraphs().getCount() == 0) {
            headerFooter.appendChild(new Paragraph(this.getDocument()));
        }
        headerFooter.getFirstParagraph().appendChild(shape.deepClone(true));
    }

    final void zzYyG() {
        for (HeaderFooter headerFooter : this.getHeadersFooters()) {
            if (!headerFooter.isHeader()) continue;
            for (Shape shape : headerFooter.zzZcj()) {
                if (!shape.zzTp()) continue;
                shape.remove();
            }
        }
    }

    private void zzY2m(Section section, boolean bl) {
        Paragraph paragraph;
        if (section == null) {
            throw new NullPointerException("sourceSection");
        }
        Body body = section.getBody();
        if (body == null) {
            return;
        }
        Body body2 = this.getBody();
        if (body2 == null) {
            body2 = (Body)this.appendChild(new Body(this.getDocument()));
        }
        body = (Body)this.getDocument().importNode(body, true);
        CompositeNode compositeNode = paragraph = bl ? body2.getLastParagraph() : null;
        while (compositeNode != null && paragraph.getParentNode() != body2) {
            compositeNode = paragraph.getParentNode();
        }
        body2.zzWqN(body.getFirstChild(), null, paragraph);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object getDirectSectionAttr(int key) {
        return this.zzWSG.zzXWJ(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchInheritedSectionAttr(int key) {
        if (key == 2600) {
            return this.getDocument().zzXB9().zzXGK.zz5A(key);
        }
        return zzZfz.zzXLJ(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchSectionAttr(int key) {
        Object object = this.getDirectSectionAttr(key);
        if (object != null) {
            return object;
        }
        return this.fetchInheritedSectionAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setSectionAttr(int key, Object value) {
        if (key == 2260 || key == 2270) {
            this.zzWSG.remove(2090);
        }
        if (key == 2600) {
            this.getDocument().zzXB9().zzXGK.zzZjh(key, value);
            return;
        }
        this.zzWSG.zzZjh(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void clearSectionAttrs() {
        this.zzWSG.clear();
    }

    final boolean zzW5Y() {
        return this.getParentNode().getFirstChild() == this;
    }

    final boolean zzYCR() {
        return this.getParentNode().getLastChild() == this;
    }

    @Override
    public final String toString() {
        return super.toString();
    }

    static final class zzYMS
    implements zzOB {
        private Section zzYH8;

        zzYMS(Section section) {
            this.zzYH8 = section;
        }

        @Override
        public final Object getDirectSectionAttr(int key) {
            return this.zzWc2().getDirectSectionAttr(key);
        }

        @Override
        public final Object fetchInheritedSectionAttr(int key) {
            return this.zzWc2().fetchInheritedSectionAttr(key);
        }

        @Override
        public final Object fetchSectionAttr(int key) {
            return this.zzWc2().fetchSectionAttr(key);
        }

        @Override
        public final void setSectionAttr(int key, Object value) {
        }

        @Override
        public final void clearSectionAttrs() {
        }

        private zzOB zzWc2() {
            Document document = zzW9E.zzYMS((Object)this.zzYH8.getDocument(), Document.class);
            if (document != null && document.getFirstSection() != null) {
                return document.getFirstSection();
            }
            return this.zzYH8;
        }
    }
}

