/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.ImageWatermarkOptions;
import com.aspose.words.PageSetup;
import com.aspose.words.Shape;
import com.aspose.words.TextWatermarkOptions;
import com.aspose.words.internal.zzJm;
import com.aspose.words.internal.zzW3D;
import com.aspose.words.internal.zzW9E;
import com.aspose.words.internal.zzWPN;
import com.aspose.words.internal.zzY8V;
import com.aspose.words.internal.zzZM9;
import com.aspose.words.internal.zzZld;
import com.aspose.words.zzZte;
import java.awt.image.BufferedImage;

public final class Watermark {
    private Document zzWFy;
    private zzZte zzX0f;

    Watermark(Document doc, zzZte watermarkProvider) {
        this.zzWFy = doc;
        this.zzX0f = watermarkProvider;
    }

    public final void setText(String text) throws Exception {
        this.setText(text, new TextWatermarkOptions());
    }

    public final void setText(String text, TextWatermarkOptions options) throws Exception {
        Watermark.zzYQ3(text);
        TextWatermarkOptions textWatermarkOptions = options == null ? new TextWatermarkOptions() : options;
        Shape shape = this.zzYMS(text, textWatermarkOptions, this.zzWFy);
        this.add(shape);
    }

    public final void setImage(BufferedImage image) throws Exception {
        this.setImage(image, new ImageWatermarkOptions());
    }

    public final void setImage(BufferedImage image, ImageWatermarkOptions options) throws Exception {
        zzW9E.zzWqN((Object)image, "image");
        Shape shape = new Shape((DocumentBase)this.zzWFy, 75);
        shape.getImageData().setImage(image);
        this.zzYMS(shape, options, this.zzWFy);
    }

    public final void setImage(String imagePath, ImageWatermarkOptions options) throws Exception {
        zzW9E.zzWqN((Object)imagePath, "imagePath");
        Shape shape = new Shape((DocumentBase)this.zzWFy, 75);
        shape.getImageData().setImage(imagePath);
        this.zzYMS(shape, options, this.zzWFy);
    }

    public final int getType() {
        Shape shape = this.zzX0f.get();
        if (shape == null) {
            return 2;
        }
        shape.zzTp();
        if (shape.zzWQu()) {
            return 0;
        }
        if (shape.zzXVs()) {
            return 1;
        }
        return 2;
    }

    private void add(Shape shape) throws Exception {
        this.remove();
        this.zzX0f.add(shape);
    }

    public final void remove() {
        this.zzX0f.remove();
    }

    private static void zzYQ3(String string) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        if (zzJm.zzdj(string)) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: text");
        }
        zzW9E.zzYMS(string.length(), 0.0, 0.0, 200.0, 200.0, true, "text");
    }

    private void zzYMS(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        if (imageWatermarkOptions == null) {
            imageWatermarkOptions = new ImageWatermarkOptions();
        }
        Watermark.zzWqN(shape, imageWatermarkOptions, document);
        if (imageWatermarkOptions.isWashout()) {
            shape.getImageData().setContrast(0.15);
            shape.getImageData().setBrightness(0.85);
        }
        Watermark.zzXYy(shape, "WordPictureWatermark");
        this.add(shape);
    }

    private static void zzWqN(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        float f;
        PageSetup pageSetup;
        float f2;
        double d = imageWatermarkOptions.getScale();
        double d2 = shape.getImageData().getImageSize().getWidthPoints();
        double d3 = shape.getImageData().getImageSize().getHeightPoints();
        if (imageWatermarkOptions.zzXfL() && d3 * (d = (double)(f2 = (pageSetup = document.getFirstSection().getPageSetup()).zzZIc()) / d2) > (double)(f = pageSetup.zzZl0())) {
            d = (double)f / d3;
        }
        shape.zzXxN(zzY8V.zzWzr(d2 * d, 2, zzWPN.zzxe));
        shape.zzYxa(zzY8V.zzWzr(d3 * d, 2, zzWPN.zzxe));
    }

    private Shape zzYMS(String string, TextWatermarkOptions textWatermarkOptions, Document document) {
        Shape shape = new Shape((DocumentBase)document, 136);
        shape.getTextPath().setText(string);
        shape.getTextPath().setFontFamily(textWatermarkOptions.getFontFamily());
        shape.setRotation(textWatermarkOptions.getLayout());
        if (textWatermarkOptions.isSemitrasparent()) {
            shape.getFill().setOpacity(0.5);
        }
        this.zzYMS(shape, textWatermarkOptions, document);
        shape.getFill().setForeColor(textWatermarkOptions.getColor());
        shape.setStrokeColor(textWatermarkOptions.getColor());
        shape.getFont().setSize(1.0);
        Watermark.zzXYy(shape, "PowerPlusWaterMarkObject");
        return shape;
    }

    private void zzYMS(Shape shape, TextWatermarkOptions textWatermarkOptions, Document document) {
        float f = textWatermarkOptions.zzZjU() ? 1.0f : textWatermarkOptions.getFontSize();
        zzZld zzZld2 = document.zzWlr().zzWzr(shape.getTextPath().getFontFamily(), f, 0);
        long l = zzZld2.zzYPI(shape.getTextPath().getText());
        if (textWatermarkOptions.zzZjU()) {
            l = Watermark.zzYMS(l, textWatermarkOptions, document);
        }
        long l2 = l;
        int n = (int)l2;
        shape.zzXxN(zzY8V.zzWzr(Float.intBitsToFloat(n), 2, zzWPN.zzxe));
        shape.zzYxa(zzY8V.zzWzr(zzW3D.zzU0(l), 2, zzWPN.zzxe));
    }

    private static long zzYMS(long l, TextWatermarkOptions textWatermarkOptions, Document document) {
        int n;
        PageSetup pageSetup = document.getFirstSection().getPageSetup();
        float f = pageSetup.zzZIc();
        float f2 = pageSetup.zzZl0();
        long l2 = l;
        int n2 = (int)l2;
        float f3 = zzW3D.zzU0(l) / Float.intBitsToFloat(n2);
        if (textWatermarkOptions.getLayout() == 315) {
            float f4 = Math.min(f2, f);
            float f5 = f4 * (float)Math.sqrt(2.0) / (f3 + 1.0f);
            return zzW3D.zzW8o(f5, f5 * f3);
        }
        l2 = l;
        n2 = (int)l2;
        if (zzW3D.zzU0(l) >= Float.intBitsToFloat(n)) {
            return zzW3D.zzW8o(f2 / f3, f2);
        }
        float f6 = f;
        return zzW3D.zzW8o(f6, f6 * f3);
    }

    private static void zzXYy(Shape shape, String string) {
        shape.setName(zzZM9.zzWqN("{0}{1}", string, shape.getId()));
        shape.setRelativeHorizontalPosition(0);
        shape.setRelativeVerticalPosition(0);
        shape.setWrapType(3);
        shape.setVerticalAlignment(2);
        shape.setHorizontalAlignment(2);
    }
}

