/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zzW9w;
import com.aspose.words.internal.zzWo8;
import com.aspose.words.internal.zzXkG;
import com.aspose.words.internal.zzYNB;
import com.aspose.words.internal.zzYcX;
import com.aspose.words.internal.zzYkW;
import com.aspose.words.internal.zzZ6k;
import com.aspose.words.internal.zzZPW;
import com.aspose.words.internal.zzwH;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

final class zzHk
extends CertPathBuilderSpi {
    private final zzwH zzYtF;
    private zzYcX zzVPB;

    zzHk(zzwH zzwH2) {
        this.zzYtF = zzwH2;
    }

    @Override
    public final CertPathBuilderResult engineBuild(CertPathParameters params) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        Collection collection;
        zzW9w pkixParams;
        if (params instanceof zzW9w) {
            pkixParams = (zzW9w)params;
        } else if (params instanceof PKIXBuilderParameters) {
            pkixParams = new zzW9w.zzYMS((PKIXBuilderParameters)params).zzWc0();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be an instance of " + PKIXBuilderParameters.class.getName() + " or " + zzW9w.class.getName() + ".");
        }
        ArrayList arrayList = new ArrayList();
        zzZPW zzZPW2 = pkixParams.zzYfJ().zzPA();
        try {
            collection = zzXkG.zzYMS(zzZPW2, pkixParams.zzYfJ().zzXUF());
            collection.addAll(zzXkG.zzYMS(zzZPW2, pkixParams.zzYfJ().zzY37()));
        }
        catch (zzYcX zzYcX2) {
            throw new CertPathBuilderException("Error finding target certificate.", zzYcX2);
        }
        if (collection.isEmpty()) {
            throw new CertPathBuilderException("No certificate found matching targetContraints.");
        }
        CertPathBuilderResult certPathBuilderResult = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && certPathBuilderResult == null) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            certPathBuilderResult = this.zzYMS(x509Certificate, pkixParams, arrayList);
        }
        if (certPathBuilderResult == null && this.zzVPB != null) {
            throw new CertPathBuilderException(this.zzVPB.getMessage(), this.zzVPB.getCause());
        }
        if (certPathBuilderResult == null) {
            throw new CertPathBuilderException("Unable to find certificate chain.");
        }
        return certPathBuilderResult;
    }

    private CertPathBuilderResult zzYMS(X509Certificate x509Certificate, zzW9w zzW9w2, List list) throws CertPathBuilderException {
        zzZ6k zzZ6k2;
        zzYNB zzYNB2;
        if (list.contains(x509Certificate)) {
            return null;
        }
        if (zzW9w2.zzVSh().contains(x509Certificate)) {
            return null;
        }
        if (zzW9w2.zzYCA() != -1 && list.size() - 1 > zzW9w2.zzYCA()) {
            return null;
        }
        list.add(x509Certificate);
        CertPathBuilderResult certPathBuilderResult = null;
        try {
            zzYNB2 = new zzYNB(this.zzYtF);
            zzZ6k2 = new zzZ6k(this.zzYtF);
        }
        catch (Exception exception) {
            throw new CertPathBuilderException("Exception creating support classes: " + exception.getMessage(), exception);
        }
        try {
            if (zzXkG.zzYMS(x509Certificate, zzW9w2.zzYfJ().zzGg(), zzW9w2.zzYfJ().zzZ8g()) != null) {
                PKIXCertPathValidatorResult pKIXCertPathValidatorResult;
                CertPath certPath;
                try {
                    certPath = zzYNB2.engineGenerateCertPath(list);
                }
                catch (Exception exception) {
                    throw new zzYcX("Certification path could not be constructed from certificate list.", exception);
                }
                try {
                    pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)zzZ6k2.engineValidate(certPath, zzW9w2);
                }
                catch (Exception exception) {
                    throw new zzYcX("Certification path could not be validated.", exception);
                }
                return new PKIXCertPathBuilderResult(certPath, pKIXCertPathValidatorResult.getTrustAnchor(), pKIXCertPathValidatorResult.getPolicyTree(), pKIXCertPathValidatorResult.getPublicKey());
            }
            ArrayList<zzYkW> arrayList = new ArrayList<zzYkW>();
            arrayList.addAll(zzW9w2.zzYfJ().zzXUF());
            try {
                arrayList.addAll(zzXkG.zzYMS(x509Certificate.getExtensionValue(zzWo8.zzR3.getId()), zzW9w2.zzYfJ().zzWp2()));
            }
            catch (CertificateParsingException certificateParsingException) {
                throw new zzYcX("No additional X.509 stores can be added from certificate locations.", certificateParsingException);
            }
            HashSet hashSet = new HashSet();
            try {
                hashSet.addAll(zzXkG.zzYMS(x509Certificate, zzW9w2.zzYfJ().zzY37(), arrayList));
            }
            catch (zzYcX zzYcX2) {
                throw new zzYcX("Cannot find issuer certificate for certificate in certification path.", zzYcX2);
            }
            if (hashSet.isEmpty()) {
                throw new zzYcX("No issuer certificate for certificate in certification path found.");
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext() && certPathBuilderResult == null) {
                X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
                certPathBuilderResult = this.zzYMS(x509Certificate2, zzW9w2, list);
            }
        }
        catch (zzYcX zzYcX3) {
            this.zzVPB = zzYcX3;
        }
        if (certPathBuilderResult == null) {
            list.remove(x509Certificate);
        }
        return certPathBuilderResult;
    }
}

