/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzZM9;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataColumnCollection
implements Iterable<DataColumn> {
    private final ArrayList<DataColumn> zzYFL = new ArrayList();
    private final Map<String, DataColumn> zzVV0 = new HashMap<String, DataColumn>();
    private DataTable zzbe;

    DataColumnCollection(DataTable table) {
        this.zzbe = table;
    }

    public void add(DataColumn column) {
        if (zzZM9.zzY0C(column.getColumnName())) {
            throw new IllegalArgumentException("Column name cannot be null or empty");
        }
        String string = DataColumnCollection.zz6g(column.getColumnName());
        if (this.zzVV0.containsKey(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        column.zzY2m(this.zzbe);
        column.setOrdinal(this.zzYFL.size());
        this.zzYFL.add(column);
        this.zzVV0.put(string, column);
        this.zzbe.onDataColumnInserted(column);
    }

    public void add(String columnName) {
        this.add(columnName, String.class);
    }

    public DataColumn add(String columnName, Class type) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzbe);
        this.add(dataColumn);
        return dataColumn;
    }

    public DataColumn add(String columnName, Class type, int columnMapping, boolean allowAutoIncrement, boolean allowDBNull) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzbe);
        dataColumn.setColumnMapping(columnMapping);
        dataColumn.setAutoIncrement(allowAutoIncrement);
        dataColumn.setAllowDBNull(allowDBNull);
        this.add(dataColumn);
        return dataColumn;
    }

    public int indexOf(String columnName) {
        if (zzZM9.zzY0C(columnName)) {
            return -1;
        }
        String string = DataColumnCollection.zz6g(columnName);
        DataColumn dataColumn = this.zzVV0.get(string);
        if (dataColumn != null) {
            int n = this.zzYFL.size();
            for (int i = 0; i < n; ++i) {
                if (this.zzYFL.get(i) != dataColumn) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(DataColumn column) {
        if (column == null) {
            return -1;
        }
        return this.indexOf(column.getColumnName());
    }

    public DataColumn get(int index) {
        return this.zzYFL.get(index);
    }

    public DataColumn get(String columnName) {
        int n = this.indexOf(columnName);
        if (n >= 0) {
            return this.get(n);
        }
        return null;
    }

    public boolean contains(String name) {
        return this.indexOf(name) >= 0;
    }

    public void remove(String name) {
        int n = this.indexOf(name);
        if (n >= 0) {
            DataColumn dataColumn = this.zzYFL.remove(n);
            this.zzVV0.remove(DataColumnCollection.zz6g(dataColumn.getColumnName()));
            for (DataRow dataRow : this.zzbe.getRows()) {
                dataRow.remove(n);
            }
            this.zzbe.onDataColumnDeleted(dataColumn);
        }
    }

    public void remove(DataColumn column) {
        this.remove(column.getColumnName());
    }

    public int getCount() {
        return this.zzYFL.size();
    }

    @Override
    public Iterator<DataColumn> iterator() {
        return this.zzYFL.iterator();
    }

    public void clear() {
        this.zzVV0.clear();
        this.zzYFL.clear();
    }

    final DataColumn[] zzY5c() {
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>(this.zzYFL);
        return arrayList.toArray(new DataColumn[arrayList.size()]);
    }

    final void zzYMS(String string, DataColumn dataColumn) {
        if (this.contains(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        int n = this.zzYFL.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzYFL.get(i) != dataColumn) continue;
            String string2 = DataColumnCollection.zz6g(string);
            String string3 = DataColumnCollection.zz6g(dataColumn.getColumnName());
            this.zzVV0.remove(string3);
            this.zzVV0.put(string2, dataColumn);
            return;
        }
    }

    private static String zz6g(String string) {
        return Normalizer.normalize(string.toLowerCase(), Normalizer.Form.NFD);
    }
}

