/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzYCP;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTableEventListener;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzWqN;
import com.aspose.words.net.System.Data.zzWzr;
import com.aspose.words.net.System.Data.zzXGh;
import com.aspose.words.net.System.Data.zzbj;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTable
implements DataTableEventListener {
    private final DataRowCollection zzZw4;
    private final DataColumnCollection zzYqO;
    private final ConstraintCollection zzro;
    private final zzbj zzZcN;
    private ResultSet zzXC4;
    private String zzXCB;
    private DataSet zzXTt;
    private String zzZsH;
    private UniqueConstraint zzYVg;
    private boolean zzY8w;
    private final List<DataTableEventListener> zzIf;
    private final Set<DataRow> zzWCo;
    private DataRelationCollection zzg8;

    public DataTable() {
        this.zzZw4 = new DataRowCollection(this);
        this.zzYqO = new DataColumnCollection(this);
        this.zzro = new ConstraintCollection(this);
        this.zzZcN = new zzbj(this);
        this.zzZsH = "";
        this.zzY8w = true;
        this.zzIf = new ArrayList<DataTableEventListener>();
        this.zzWCo = new HashSet<DataRow>();
        this.zzg8 = new DataRelationCollection();
    }

    public DataTable(String tableName) {
        this.zzZw4 = new DataRowCollection(this);
        this.zzYqO = new DataColumnCollection(this);
        this.zzro = new ConstraintCollection(this);
        this.zzZcN = new zzbj(this);
        this.zzZsH = "";
        this.zzY8w = true;
        this.zzIf = new ArrayList<DataTableEventListener>();
        this.zzWCo = new HashSet<DataRow>();
        this.zzg8 = new DataRelationCollection();
        this.zzXCB = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        ResultSet resultSet2 = resultSet;
        this(resultSet2, zzWqN.zzYMS(resultSet2));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        this.zzZw4 = new DataRowCollection(this);
        this.zzYqO = new DataColumnCollection(this);
        this.zzro = new ConstraintCollection(this);
        this.zzZcN = new zzbj(this);
        this.zzZsH = "";
        this.zzY8w = true;
        this.zzIf = new ArrayList<DataTableEventListener>();
        this.zzWCo = new HashSet<DataRow>();
        this.zzg8 = new DataRelationCollection();
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zzXC4 = resultSet;
        this.zzXCB = tableName;
        this.refresh();
    }

    public void close() throws Exception {
        if (this.zzXC4 != null) {
            if (this.zzXC4.getStatement() != null) {
                this.zzXC4.getStatement().getConnection().close();
            }
            this.zzXC4 = null;
            this.clearEventListneers();
        }
    }

    public String getTableName() {
        return this.zzXCB;
    }

    public void setTableName(String tableName) {
        this.zzXCB = tableName;
    }

    @Deprecated
    public boolean containsColumn(String columnName) {
        return this.getColumns().contains(columnName);
    }

    public int getColumnsCount() {
        return this.zzYqO.getCount();
    }

    public String getColumnName(int index) {
        return this.zzYqO.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zzXC4;
    }

    public DataSet getDataSet() {
        return this.zzXTt;
    }

    final void zzY2m(DataSet dataSet) {
        this.zzXTt = dataSet;
    }

    public DataRelationCollection getChildRelations() {
        for (DataRelation dataRelation : this.zzXTt.getRelations()) {
            if (dataRelation.getParentTable() != this) continue;
            this.zzg8.add(dataRelation);
        }
        return this.zzg8;
    }

    public DataRelationCollection getParentRelations() {
        DataRelationCollection dataRelationCollection = new DataRelationCollection();
        for (DataRelation dataRelation : this.zzXTt.getRelations()) {
            if (dataRelation.getChildTable() != this) continue;
            dataRelationCollection.add(dataRelation);
        }
        return dataRelationCollection;
    }

    public DataRowCollection getRows() {
        return this.zzZw4;
    }

    public DataColumnCollection getColumns() {
        return this.zzYqO;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public ConstraintCollection getConstraints() {
        return this.zzro;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zzYVg == null) {
            return new DataColumn[0];
        }
        return this.zzYVg.getColumns();
    }

    final void zzbj(List<String> list) {
        DataColumn[] dataColumnArray = new DataColumn[list.size()];
        for (int i = 0; i < dataColumnArray.length; ++i) {
            dataColumnArray[i] = this.getColumns().get(list.get(i));
        }
        this.setPrimaryKey(dataColumnArray);
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zzYVg != null) {
                this.zzYVg.zzWeb(false);
                this.getConstraints().remove(this.zzYVg);
                this.zzYVg = null;
            }
            return;
        }
        if (this.zzYVg != null && DataColumn.areColumnSetsTheSame(value, this.zzYVg.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zzYMS(this.getConstraints(), value);
        if (uniqueConstraint == null) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zzYVg != null) {
            this.zzYVg.zzWeb(false);
            this.getConstraints().remove(this.zzYVg);
            this.zzYVg = null;
        }
        UniqueConstraint.zzYMS(this.getConstraints(), uniqueConstraint);
        this.zzYVg = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zzZsH;
    }

    public void setNamespace(String namespace) {
        this.zzZsH = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zzY8w;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzY8w = enforceConstraints;
    }

    public void refresh() {
        if (this.getResultSet() == null) {
            return;
        }
        try {
            this.zzWCo.clear();
            this.getRows().clear();
            this.getColumns().clear();
            zzWqN.zzYMS(this.getResultSet(), this);
            zzWqN.zzWqN(this.getResultSet(), this);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            zzYCP.zzY2m(sQLException);
            return;
        }
    }

    public void acceptChanges() throws SQLException {
        zzWqN.zzXYy(this);
    }

    public synchronized void addEventListener(DataTableEventListener listener) {
        if (!this.zzIf.contains(listener)) {
            this.zzIf.add(listener);
        }
    }

    public void removeEventListener(zzWzr listener) {
        if (this.zzIf.contains(listener)) {
            this.zzIf.remove(listener);
        }
    }

    public synchronized void clearEventListneers() {
        this.zzIf.clear();
    }

    @Override
    public void onDataRowChanged(DataRow row) {
        row.setRowState(16);
        this.zzWCo.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzIf) {
            dataTableEventListener.onDataRowChanged(row);
        }
    }

    @Override
    public void onDataRowInserted(DataRow row) {
        if (row.getRowState() == 4) {
            return;
        }
        row.setRowState(1);
        this.zzWCo.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzIf) {
            dataTableEventListener.onDataRowInserted(row);
        }
    }

    @Override
    public void onDataRowDeleted(DataRow row) {
        row.setRowState(8);
        this.zzWCo.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzIf) {
            dataTableEventListener.onDataRowDeleted(row);
        }
    }

    @Override
    public void onDataColumnInserted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzIf) {
            dataTableEventListener.onDataColumnInserted(column);
        }
    }

    @Override
    public void onDataColumnDeleted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzIf) {
            dataTableEventListener.onDataColumnDeleted(column);
        }
    }

    final zzXGh zzYMS(zzWqN[] zzWqNArray) {
        DataColumn[] dataColumnArray = new DataColumn[zzWqNArray.length];
        for (int i = 0; i < zzWqNArray.length; ++i) {
            dataColumnArray[i] = zzWqNArray[i].zzY2g();
        }
        DataTable dataTable = this;
        zzXGh zzXGh2 = dataTable.zzZcN.zzY2m(dataColumnArray);
        if (zzXGh2 == null) {
            throw new IllegalStateException("Index not found");
        }
        return zzXGh2;
    }

    final zzbj zzYBj() {
        return this.zzZcN;
    }

    final Set<DataRow> zzZXS() {
        return this.zzWCo;
    }
}

