/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zz1G;
import asposewobfuscated.zz40;
import com.aspose.words.Document;
import com.aspose.words.PageInfo;
import com.aspose.words.PageSetup;
import com.aspose.words.PrintHelper;
import com.aspose.words.zzZU;
import com.aspose.words.zzZV;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.PageRanges;

public class AsposeWordsPrintDocument
implements Pageable,
Printable {
    private final Document zz7g;
    private int zz7f;
    private zzZU[] zz7e;
    private PageInfo zz7d;
    private zz40 zz7c;
    private String zz7b;
    private boolean zz7a = true;
    private MediaTray[] zz79;

    public AsposeWordsPrintDocument(Document document) {
        if (document == null) {
            throw new IllegalArgumentException("Document cannot be null");
        }
        this.zz7g = document;
        try {
            if (this.zzmt()) {
                PageSetup pageSetup = this.zz7g.getFirstSection().getPageSetup();
                this.zz7e = zzZV.zzL(this.zz7g.getPageCount(), pageSetup.getSheetsPerBooklet(), pageSetup.getMultiplePages());
                this.zz7f = this.zz7e.length;
            } else {
                this.zz7f = document.getPageCount();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void zzmu() {
    }

    private boolean zzmt() {
        return this.zz7g.zz9L().zzbi();
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex >= this.zz7f) {
            return 1;
        }
        try {
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.zzmt()) {
                if (pageIndex < 0 || pageIndex >= this.zz7e.length) {
                    throw new IllegalStateException("Unexpected Booklet signature index.");
                }
                zzZU zzZU10 = this.zz7e[pageIndex];
                this.zz7g.zzZ(zzZU10, this.zzms().zzZy1(), this.zzms().getPaperTray(), graphics2D, (float)pageFormat.getImageableX(), (float)pageFormat.getImageableY(), (float)pageFormat.getWidth(), (float)pageFormat.getHeight());
            } else {
                this.zz7g.renderToSize(pageIndex, graphics2D, (float)pageFormat.getImageableX(), (float)pageFormat.getImageableY(), (float)pageFormat.getWidth(), (float)pageFormat.getHeight());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    @Override
    public int getNumberOfPages() {
        return this.zz7f;
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        PageFormat pageFormat = new PageFormat();
        try {
            PageInfo pageInfo = this.zzmt() ? this.zzms() : this.zz7g.getPageInfo(pageIndex);
            Paper paper = new Paper();
            float f = pageInfo.getWidthInPoints();
            float f2 = pageInfo.getHeightInPoints();
            if (pageInfo.getLandscape() && this.zz7a) {
                paper.setImageableArea(0.0, 0.0, f2, f);
                paper.setSize(f2, f);
                pageFormat.setOrientation(0);
            } else {
                paper.setImageableArea(0.0, 0.0, f, f2);
                paper.setSize(f, f2);
                pageFormat.setOrientation(1);
            }
            pageFormat.setPaper(paper);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return pageFormat;
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        return this;
    }

    void zzZ(zz40 zz402) {
        this.zz7c = zz402;
    }

    void zzVh(String string) {
        this.zz7b = string;
    }

    void print() {
        PrintService printService = this.getPrintService();
        if (printService == null) {
            throw new IllegalStateException("There are no available print Services.");
        }
        try {
            int n;
            int n2;
            this.zz79 = PrintHelper.getTrays(printService);
            this.zz7a = this.zzZ(printService);
            if (this.zz7f == 0) {
                return;
            }
            if (this.zzmt()) {
                n2 = 1;
                n = this.zz7f;
            } else {
                n2 = this.zz7c.getFromPage() == 0 ? 1 : this.zz7c.getFromPage();
                n = this.zz7c.getToPage() == 0 ? this.zz7f : this.zz7c.getToPage();
            }
            PageInfo pageInfo = this.zz7g.getPageInfo(n2 - 1);
            int n3 = n2 - 1;
            int n4 = pageInfo.getPaperTray();
            for (int i = n2; i < n; ++i) {
                pageInfo = this.zz7g.getPageInfo(i);
                int n5 = pageInfo.getPaperTray();
                if (n5 == n4) continue;
                this.zzZ(printService, n3 + 1, i, n4);
                n4 = n5;
                n3 = i;
            }
            this.zzZ(printService, n3 + 1, n, n4);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void zzZ(PrintService printService, int n, int n2, int n3) throws PrinterException, NoSuchFieldException, IllegalAccessException {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintService(printService);
        printerJob.setPageable(this);
        PrintRequestAttributeSet printRequestAttributeSet = this.zz7c.zzqY();
        if (this.zz7b != null && this.zz7b.length() > 0) {
            printRequestAttributeSet.add(new JobName(this.zz7b, zz1G.getDefault()));
        }
        printRequestAttributeSet.add(new PageRanges(n, n2));
        MediaTray mediaTray = this.zzC(n3);
        if (mediaTray != null) {
            printRequestAttributeSet.add(mediaTray);
        }
        printerJob.print(printRequestAttributeSet);
    }

    MediaTray zzC(Object object) throws NoSuchFieldException, IllegalAccessException {
        for (MediaTray mediaTray : this.zz79) {
            int n = PrintHelper.getTrayID(mediaTray);
            if (!object.equals(n)) continue;
            return mediaTray;
        }
        return null;
    }

    private PrintService getPrintService() {
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(null, this.zz7c.zzqX());
        PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
        if (printServiceArray.length == 0) {
            return printService;
        }
        if (printService != null) {
            for (PrintService printService2 : printServiceArray) {
                if (printService2 != printService) continue;
                return printService2;
            }
        }
        return printServiceArray[0];
    }

    private boolean zzZ(PrintService printService) throws PrinterException {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintService(printService);
        PageFormat pageFormat = printerJob.defaultPage();
        Paper paper = new Paper();
        paper.setImageableArea(0.0, 0.0, Double.MAX_VALUE, Double.MAX_VALUE);
        pageFormat.setPaper(paper);
        PageFormat pageFormat2 = printerJob.validatePage(pageFormat);
        return pageFormat.getHeight() != pageFormat2.getImageableHeight() || pageFormat.getWidth() != pageFormat2.getImageableWidth();
    }

    private PageInfo zzms() {
        if (this.zz7d == null) {
            this.zz7d = this.zz7g.zzms();
        }
        return this.zz7d;
    }
}

