/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zz2R;
import asposewobfuscated.zz3A;
import asposewobfuscated.zz3D;
import asposewobfuscated.zz3F;
import asposewobfuscated.zz46;
import asposewobfuscated.zzDR;
import asposewobfuscated.zzDT;
import asposewobfuscated.zzDV;
import asposewobfuscated.zzE9;
import asposewobfuscated.zzKS;
import com.aspose.words.DigitalSignature;
import com.aspose.words.DigitalSignatureCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.X509Certificate2;
import com.aspose.words.zzDX;
import com.aspose.words.zzZAT;
import com.aspose.words.zzZI0;
import com.aspose.words.zzZR7;
import com.aspose.words.zzZR8;
import com.aspose.words.zzZR9;
import com.aspose.words.zzZRA;
import java.io.InputStream;
import java.util.Date;

public class DigitalSignatureUtil {
    public static void sign(String srcFileName, String dstFileName, X509Certificate2 certificate, String comments, Date signTime) throws Exception {
        DigitalSignatureUtil.zzZ(srcFileName, dstFileName, certificate.zzZbw(), comments, zz46.zzZ(signTime));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void zzZ(String string, String string2, zz2R zz2R2, String string3, zz46 zz462) throws Exception {
        zzE9.zzL(string, "srcFileName");
        zzE9.zzL(string2, "dstFileName");
        zz3D zz3D2 = zz3F.zzZ(string, 3, 1, 3);
        try {
            zz3D zz3D3 = zz3F.zzZ(string2, 4, 2, 1);
            try {
                DigitalSignatureUtil.zzZ(zz3D2, zz3D3, zz2R2, string3, zz462);
            }
            finally {
                if (zz3D3 != null) {
                    zz3D3.close();
                }
            }
        }
        finally {
            if (zz3D2 != null) {
                zz3D2.close();
            }
        }
    }

    public static void sign(InputStream srcStream, InputStream dstStream, X509Certificate2 certificate, String comments, Date signTime) throws Exception {
        DigitalSignatureUtil.zzZ(zz3A.zzZ(srcStream), zz3A.zzZ(dstStream), certificate.zzZbw(), comments, zz46.zzZ(signTime));
    }

    static void zzZ(zz3A zz3A2, zz3A zz3A3, zz2R zz2R2, String string, zz46 zz462) throws Exception {
        if (!zz2R2.zzpb()) {
            throw new IllegalStateException("Certificate must contain private key.");
        }
        DigitalSignature digitalSignature = new DigitalSignature(zz2R2, string, zz462);
        if (zzDX.zzZW(zz3A2)) {
            DigitalSignatureUtil.zzZ(zz3A2, zz3A3, digitalSignature, true);
            return;
        }
        zzDX zzDX2 = new zzDX();
        FileFormatInfo fileFormatInfo = zzDX2.zzZX(zz3A2);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzKS zzKS2 = new zzKS(zz3A2);
                int n = fileFormatInfo.zzZXi() == 1 ? 1 : 2;
                zzZI0.zzZ(zzKS2, digitalSignature, n);
                zz3A3.setLength(0L);
                zzKS2.zzV(zz3A3);
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                DigitalSignatureUtil.zzZ(zz3A2, zz3A3, digitalSignature, false);
                break;
            }
            default: {
                throw new IllegalStateException("Signing feature is not supported by this file format.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAllSignatures(String srcFileName, String dstFileName) throws Exception {
        zz3D zz3D2 = zz3F.zzZ(srcFileName, 3, 1, 3);
        try {
            zz3D zz3D3 = zz3F.zzZ(dstFileName, 4, 2, 1);
            try {
                DigitalSignatureUtil.zzX(zz3D2, zz3D3);
            }
            finally {
                if (zz3D3 != null) {
                    zz3D3.close();
                }
            }
        }
        finally {
            if (zz3D2 != null) {
                zz3D2.close();
            }
        }
    }

    static void zzX(zz3A zz3A2, zz3A zz3A3) throws Exception {
        zzDX zzDX2 = new zzDX();
        FileFormatInfo fileFormatInfo = zzDX2.zzZX(zz3A2);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzKS zzKS2 = new zzKS(zz3A2);
                zzKS2.zzD1().remove("_xmlsignatures");
                zzKS2.zzD1().remove("_signatures");
                zz3A3.zzZF(0L);
                zzKS2.zzV(zz3A3);
                zz3A3.setLength(zz3A3.zzXm());
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                zzDV zzDV2 = new zzDV(zz3A2);
                zzDT zzDT2 = zzDV2.zzZ(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (zzDT2 != null) {
                    for (zzDR zzDR2 : zzDT2.zzye()) {
                        String string = zzDT2.zzZ(zzDR2);
                        zzDV2.zzyf().remove(string);
                    }
                    zzDV2.zzyi();
                }
                zz3A3.zzZF(0L);
                zzDV2.zzV(zz3A3);
                zz3A3.setLength(zz3A3.zzXm());
                break;
            }
            default: {
                throw new IllegalStateException("Signing feature is not supported by this file format.");
            }
        }
    }

    public static void removeAllSignatures(InputStream srcStream, InputStream dstStream) throws Exception {
        DigitalSignatureUtil.zzX(zz3A.zzZ(srcStream), zz3A.zzZ(dstStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DigitalSignatureCollection loadSignatures(String fileName) throws Exception {
        zz3D zz3D2 = zz3F.zzZ(fileName, 3, 1, 1);
        try {
            DigitalSignatureCollection digitalSignatureCollection = DigitalSignatureUtil.zz5(zz3D2);
            return digitalSignatureCollection;
        }
        finally {
            if (zz3D2 != null) {
                zz3D2.close();
            }
        }
    }

    static DigitalSignatureCollection zz5(zz3A zz3A2) throws Exception {
        if (zzDX.zzZW(zz3A2)) {
            return DigitalSignatureUtil.zz4(zz3A2);
        }
        zzDX zzDX2 = new zzDX();
        FileFormatInfo fileFormatInfo = zzDX2.zzZX(zz3A2);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 60: {
                Document document = new Document(zz3A2);
                return document.getDigitalSignatures();
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static DigitalSignatureCollection loadSignatures(InputStream stream) throws Exception {
        return DigitalSignatureUtil.zz5(zz3A.zzZ(stream));
    }

    private static void zzZ(zz3A zz3A2, zz3A zz3A3, DigitalSignature digitalSignature, boolean bl) throws Exception {
        zzDV zzDV2 = new zzDV(zz3A2);
        zzZR9 zzZR92 = bl ? new zzZR7(zzDV2) : new zzZR8(zzDV2);
        zzZR92.zzY(digitalSignature);
        zz3A3.setLength(0L);
        zzDV2.zzV(zz3A3);
    }

    private static DigitalSignatureCollection zz4(zz3A zz3A2) throws Exception {
        zz3A2.zzZF(0L);
        zzDV zzDV2 = new zzDV(zz3A2);
        DigitalSignatureCollection digitalSignatureCollection = new DigitalSignatureCollection();
        zzDT zzDT2 = zzDV2.zzZ(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        if (zzDT2 != null) {
            for (zzDR zzDR2 : zzDT2.zzye()) {
                String string = zzDT2.zzZ(zzDR2);
                zzDT zzDT3 = zzDV2.zzZ5(string);
                zzDT zzDT4 = zzDV2.zzZ(zzDT3, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate");
                zz2R zz2R2 = new zz2R(zzDT4.zzyc().toArray());
                zzZAT.zzZ(zzDT3.zzzy(), zz2R2, new zzZRA(zzDV2), digitalSignatureCollection, null);
            }
        }
        return digitalSignatureCollection;
    }
}

