/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zz14;
import asposewobfuscated.zz1P;
import asposewobfuscated.zz46;
import asposewobfuscated.zz47;
import asposewobfuscated.zzD8;
import asposewobfuscated.zzE9;
import asposewobfuscated.zzXG;
import asposewobfuscated.zzZXT;
import com.aspose.words.BookmarkStart;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentBuilder;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.DropDownItemCollection;
import com.aspose.words.Field;
import com.aspose.words.FieldStart;
import com.aspose.words.Node;
import com.aspose.words.SpecialChar;
import com.aspose.words.zz5O;
import com.aspose.words.zzD1;
import com.aspose.words.zzZB9;
import com.aspose.words.zzZK7;
import com.aspose.words.zzZXB;

public class FormField
extends SpecialChar {
    private zzD1 zzZBl;
    private Field zzZBk;
    static String zzZBj = zz1P.zzW('\u2002', 5);
    private static final zz14 zzV4 = new zz14("uppercase", "lowercase", "first capital", "title case");

    FormField(DocumentBase doc, zzD1 formFieldPr, zzZK7 runPr) {
        super(doc, '\u0001', runPr);
        this.zzZBl = formFieldPr;
    }

    @Override
    Node zzZ(boolean bl, zz5O zz5O2) throws Exception {
        FormField formField = (FormField)super.zzZ(bl, zz5O2);
        formField.zzZBl = (zzD1)this.zzZBl.zzmm();
        formField.zzZBk = null;
        return formField;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return FormField.visitorActionToBool(visitor.visitFormField(this));
    }

    void zzZVF() throws Exception {
        if (this.getField() == null) {
            return;
        }
        BookmarkStart bookmarkStart = zzZXT.zzZ(this.getField().getStart().getNextSibling(), BookmarkStart.class);
        if (bookmarkStart != null) {
            bookmarkStart.remove();
            this.getField().getStart().zzZER().insertBefore(bookmarkStart, this.getField().getStart());
        }
        this.getField().remove();
    }

    public void setTextInputValue(Object newValue) throws Exception {
        if (newValue == null) {
            throw new IllegalArgumentException("newValue");
        }
        if (this.getType() != 70) {
            throw new IllegalStateException("The form field is not a text form field.");
        }
        switch (this.getTextInputType()) {
            case 0: {
                int n = FormField.zzRD(this.getTextInputFormat());
                this.setResult(zzZB9.zzZM((String)newValue, n));
                break;
            }
            case 1: {
                this.setResult(zzD8.zzZ(zz47.zzH(newValue), this.getTextInputFormat(), true));
                break;
            }
            case 2: {
                this.setResult(zzZB9.zzY((zz46)newValue, this.getTextInputFormat()));
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                throw new IllegalStateException("Cannot set the form field value because it is calculated.");
            }
            default: {
                throw new IllegalStateException("Unknown form field type.");
            }
        }
    }

    private static int zzRD(String string) {
        string = string.toLowerCase();
        switch (zzV4.zzW2(string)) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 3;
            }
        }
        return 0;
    }

    private FieldStart zzZVE() {
        int n = 0;
        block4: for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            switch (node.getNodeType()) {
                case 22: {
                    if (n-- != 0) continue block4;
                    return (FieldStart)node;
                }
                case 24: {
                    ++n;
                }
            }
        }
        return null;
    }

    @Override
    public int getNodeType() {
        return 25;
    }

    public String getName() {
        return this.zzZBl.getName();
    }

    public void setName(String value) throws Exception {
        zzE9.zzY(value, "value");
        BookmarkStart bookmarkStart = this.getBookmarkStart();
        if (bookmarkStart != null) {
            bookmarkStart.getBookmark().setName(value);
        }
        this.zzZBl.setName(value);
    }

    public int getType() throws Exception {
        return this.getField() != null ? this.getField().getType() : 0;
    }

    int zzZVD() throws Exception {
        switch (this.getType()) {
            case 70: {
                return 0;
            }
            case 71: {
                return 1;
            }
            case 83: {
                return 2;
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    Field getField() throws Exception {
        FieldStart fieldStart;
        if (this.zzZBk == null && (fieldStart = this.zzZVE()) != null) {
            this.zzZBk = fieldStart.getField();
        }
        return this.zzZBk;
    }

    public String getResult() throws Exception {
        switch (this.getType()) {
            case 70: {
                if (this.getField() == null) {
                    return "";
                }
                String string = this.getField().getResult();
                return zz1P.equals(string, zzZBj) ? "" : string;
            }
            case 71: {
                return this.getChecked() ? "1" : "0";
            }
            case 83: {
                return this.zzZVC();
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    public void setResult(String value) throws Exception {
        zzE9.zzY(value, "value");
        switch (this.getType()) {
            case 70: {
                this.getField().setResult(value);
                break;
            }
            case 71: {
                this.setChecked(zzD8.parseInt(value) != 0);
                break;
            }
            case 83: {
                this.zzRC(value);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown form field type.");
            }
        }
    }

    public String getStatusText() {
        return this.zzZBl.getStatusText();
    }

    public void setStatusText(String value) {
        this.zzZBl.setStatusText(value);
    }

    public boolean getOwnStatus() {
        return this.zzZBl.zzZVy();
    }

    public void setOwnStatus(boolean value) {
        this.zzZBl.zzX9(value);
    }

    public String getHelpText() {
        return this.zzZBl.getHelpText();
    }

    public void setHelpText(String value) {
        this.zzZBl.setHelpText(value);
    }

    public boolean getOwnHelp() {
        return this.zzZBl.zzZVz();
    }

    public void setOwnHelp(boolean value) {
        this.zzZBl.zzXa(value);
    }

    public boolean getCalculateOnExit() {
        return this.zzZBl.zzZVA();
    }

    public void setCalculateOnExit(boolean value) {
        this.zzZBl.zzXb(value);
    }

    public String getEntryMacro() {
        return this.zzZBl.getEntryMacro();
    }

    public void setEntryMacro(String value) {
        this.zzZBl.setEntryMacro(value);
    }

    public String getExitMacro() {
        return this.zzZBl.getExitMacro();
    }

    public void setExitMacro(String value) {
        this.zzZBl.setExitMacro(value);
    }

    public boolean getEnabled() {
        return this.zzZBl.getEnabled();
    }

    public void setEnabled(boolean value) {
        this.zzZBl.setEnabled(value);
    }

    public String getTextInputFormat() {
        return this.zzZBl.getTextInputFormat();
    }

    public void setTextInputFormat(String value) {
        this.zzZBl.setTextInputFormat(value);
    }

    public int getTextInputType() {
        return this.zzZBl.getTextInputType();
    }

    public void setTextInputType(int value) {
        this.zzZBl.setTextInputType(value);
    }

    public String getTextInputDefault() {
        return this.zzZBl.getTextInputDefault();
    }

    public void setTextInputDefault(String value) throws Exception {
        this.zzZBl.setTextInputDefault(value);
        if (this.getTextInputType() == 5) {
            Node node = this.getField().getStart().zzHc(21);
            zzZXB.zzZ(node, false, this, false);
            DocumentBuilder documentBuilder = new DocumentBuilder(this.zz2D());
            documentBuilder.moveTo(this);
            documentBuilder.insertField(value, "");
            this.getField().update();
        }
    }

    public int getMaxLength() {
        return this.zzZBl.zzZVx();
    }

    public void setMaxLength(int value) {
        this.zzZBl.zzLx(value);
    }

    public DropDownItemCollection getDropDownItems() {
        return this.zzZBl.getDropDownItems();
    }

    public int getDropDownSelectedIndex() {
        if (this.zzZBl.zzZVp()) {
            return this.zzZBl.zzZVq();
        }
        return this.zzZBl.zzZVr();
    }

    public void setDropDownSelectedIndex(int value) {
        this.zzZBl.zzLu(value);
    }

    String zzZVC() {
        int n = this.getDropDownSelectedIndex();
        if (n < 0 || n >= this.getDropDownItems().getCount()) {
            return "";
        }
        return this.getDropDownItems().get(n);
    }

    void zzRC(String string) {
        for (int i = 0; i < this.getDropDownItems().getCount(); ++i) {
            if (!zzE9.zzK(this.getDropDownItems().get(i), string)) continue;
            this.setDropDownSelectedIndex(i);
            return;
        }
    }

    public boolean getChecked() {
        if (this.zzZBl.zzZVs()) {
            return this.zzZBl.zzZVt();
        }
        return this.zzZBl.zzZVu();
    }

    public void setChecked(boolean value) {
        this.zzZBl.zzX6(value);
    }

    public boolean isCheckBoxExactSize() {
        return !this.zzZBl.zzZVw();
    }

    public void isCheckBoxExactSize(boolean value) {
        this.zzZBl.zzX8(!value);
    }

    public double getCheckBoxSize() {
        return zzXG.zzZK(this.zzZBl.zzZVv());
    }

    public void setCheckBoxSize(double value) {
        this.zzZBl.zzLw(zzXG.zzv(value));
    }

    BookmarkStart getBookmarkStart() throws Exception {
        if (this.getField() == null) {
            return null;
        }
        BookmarkStart bookmarkStart = zzZXT.zzZ(this.getField().getStart().getNextSibling(), BookmarkStart.class);
        if (bookmarkStart == null) {
            bookmarkStart = zzZXT.zzZ(this.getField().getStart().getPreviousSibling(), BookmarkStart.class);
        }
        return bookmarkStart;
    }

    zzD1 zzZVB() {
        return this.zzZBl;
    }
}

