/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zz48;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Range;
import com.aspose.words.SaveOptions;
import com.aspose.words.zz5O;
import com.aspose.words.zz6N;
import com.aspose.words.zzCS;
import com.aspose.words.zzNY;
import com.aspose.words.zzZX7;

public abstract class Node
implements Cloneable {
    private Node zzZeq;
    private Node zzZep;
    private Node zzZeo;

    protected Node() {
    }

    protected Node(DocumentBase doc) {
        this.zzO(doc);
    }

    public abstract int getNodeType();

    public CompositeNode getParentNode() {
        if (this.zzZeq == null) {
            return null;
        }
        if (this.zzZeq.getNodeType() == 38) {
            return null;
        }
        return (CompositeNode)this.zzZeq;
    }

    CompositeNode zzZER() {
        return zzZX7.zzZI(this.getParentNode()) ? this.getParentNode().zzZER() : this.getParentNode();
    }

    public DocumentBase getDocument() {
        if (this instanceof DocumentBase) {
            return (DocumentBase)this;
        }
        if (this.zzZeq == null) {
            return null;
        }
        return this.zzZeq.getDocument();
    }

    Document zz2D() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        throw new IllegalStateException("This operation requires the node to be inside the main document.");
    }

    public Node getPreviousSibling() {
        CompositeNode compositeNode = this.getParentNode();
        if (compositeNode != null && this != compositeNode.getFirstChild()) {
            return this.zzZEL();
        }
        return null;
    }

    Node zzZEQ() {
        Node node = zzZX7.zzZG(this.getPreviousSibling());
        if (node == null && zzZX7.zzZI(this.getParentNode())) {
            node = this.getParentNode().zzZEQ();
        }
        return node;
    }

    Node zzZEP() {
        Node node = zzZX7.zzZH(this.getNextSibling());
        if (node == null && zzZX7.zzZI(this.getParentNode())) {
            node = this.getParentNode().zzZEP();
        }
        return node;
    }

    public Node getNextSibling() {
        CompositeNode compositeNode = this.getParentNode();
        if (compositeNode != null && this != compositeNode.getLastChild()) {
            return this.zzZEM();
        }
        return null;
    }

    public boolean isComposite() {
        return false;
    }

    public Range getRange() {
        return new Range(this);
    }

    boolean zzZEO() {
        return this.getParentNode() == null || this == this.getParentNode().getLastChild();
    }

    boolean isFirstChild() {
        return this.getParentNode() == null || this == this.getParentNode().getFirstChild();
    }

    boolean zzZEN() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (zzZX7.zzZR(node)) continue;
            return false;
        }
        return true;
    }

    Node zzZEM() {
        return this.zzZep;
    }

    void zzb(Node node) {
        this.zzZep = node;
    }

    Node zzZEL() {
        return this.zzZeo;
    }

    void zza(Node node) {
        this.zzZeo = node;
    }

    int zzZEK() {
        switch (this.getNodeType()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
        }
        if (zzZX7.zzZN(this)) {
            return 3;
        }
        if (zzZX7.zzZM(this)) {
            return 4;
        }
        if (zzZX7.zzZL(this)) {
            return 5;
        }
        if (zzZX7.zzZK(this)) {
            return 6;
        }
        return 7;
    }

    public Node deepClone(boolean isCloneChildren) throws Exception {
        return this.zzZ(isCloneChildren, null);
    }

    Node zzZ(boolean bl, zz5O zz5O2) throws Exception {
        Node node = (Node)this.memberwiseClone();
        if (this.zzZeq != null) {
            node.zzZeq = this.getDocument().zz9Q();
        }
        node.zzZep = null;
        node.zzZeo = null;
        if (zz5O2 != null) {
            zz5O2.zzW(this, node);
        }
        return node;
    }

    public abstract boolean accept(DocumentVisitor var1) throws Exception;

    protected static boolean visitorActionToBool(int action) {
        switch (action) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown visitor action.");
    }

    public String getText() {
        return "";
    }

    public Node getAncestor(Class ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (!ancestorType.isAssignableFrom(compositeNode.getClass())) continue;
            return compositeNode;
        }
        return null;
    }

    public Node getAncestor(int ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() != ancestorType) continue;
            return compositeNode;
        }
        return null;
    }

    public void remove() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("Cannot remove because there is no parent.");
        }
        this.getParentNode().removeChild(this);
    }

    void zz9(Node node) {
        this.zzZeq = node != null ? node : this.getDocument().zz9Q();
    }

    void zzO(DocumentBase documentBase) {
        this.zzZeq = documentBase != null ? documentBase.zz9Q() : null;
    }

    boolean zz8(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("node");
        }
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null && compositeNode != this; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode != node) continue;
            return true;
        }
        return false;
    }

    int getTextLength() {
        return this.getText().length();
    }

    public Node nextPreOrder(Node rootNode) {
        Node node;
        Node node2 = node = this.isComposite() ? ((CompositeNode)this).getFirstChild() : null;
        if (node == null) {
            for (node = this; node != null && node != rootNode && node.getNextSibling() == null; node = node.getParentNode()) {
            }
            if (node != null && node != rootNode) {
                node = node.getNextSibling();
            }
        }
        if (node == rootNode) {
            node = null;
        }
        return node;
    }

    public Node previousPreOrder(Node rootNode) {
        Node node = this.getPreviousSibling();
        while (node != null) {
            Node node2;
            Node node3 = node2 = node.isComposite() ? ((CompositeNode)node).getLastChild() : null;
            if (node2 == null) break;
            node = node2;
        }
        if (node == null) {
            node = this.getParentNode();
        }
        if (node == rootNode) {
            node = null;
        }
        return node;
    }

    Node zzHc(int n) {
        Node node;
        for (node = this.getNextSibling(); null != node && n != node.getNodeType(); node = node.getNextSibling()) {
        }
        return node;
    }

    Node zzHb(int n) {
        Node node;
        for (node = this.getPreviousSibling(); null != node && n != node.getNodeType(); node = node.getPreviousSibling()) {
        }
        return node;
    }

    Node zzUD(boolean bl) {
        return bl ? this.getNextSibling() : this.getPreviousSibling();
    }

    @Deprecated
    public String toTxt() throws Exception {
        return this.toString(70);
    }

    public String toString(int saveFormat) throws Exception {
        zz6N zz6N2 = zzCS.zzLp(saveFormat);
        return zz6N2.zzl(this);
    }

    public String toString(SaveOptions saveOptions) throws Exception {
        zz6N zz6N2 = zzCS.zzX(saveOptions);
        return zz6N2.zzl(this);
    }

    Node zzHa(int n) {
        for (CompositeNode compositeNode = this.getParentNode(); null != compositeNode; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() == n) {
                return compositeNode;
            }
            if (!zzZX7.zzZO(compositeNode)) continue;
            if (n != 0) break;
            return compositeNode;
        }
        return null;
    }

    zzNY zzZEJ() {
        Node node = this.getPreviousSibling();
        return node != null ? zzNY.zzJ(node) : zzNY.zzK(this.getParentNode());
    }

    zzNY zzZEI() {
        Node node = this.getNextSibling();
        return node != null ? zzNY.zzK(node) : zzNY.zzJ(this.getParentNode());
    }

    boolean zz7(Node node) {
        return Node.zzQ(this, node);
    }

    static boolean zzQ(Node node, Node node2) {
        zz48 zz482;
        if (node == null || node2 == null) {
            return false;
        }
        zz48 zz483 = Node.zz6(node);
        Node node3 = (Node)Node.zzZ(zz483, zz482 = Node.zz6(node2));
        if (node3 == null) {
            return false;
        }
        if (zz483.getCount() == 0 || zz482.getCount() == 0) {
            boolean bl = zz482.getCount() > 0;
            return bl;
        }
        Object e = zz483.peek();
        Object e2 = zz482.peek();
        for (Node node4 : ((CompositeNode)node3).getChildNodes()) {
            if (node4 == e) {
                return true;
            }
            if (node4 != e2) continue;
            return false;
        }
        return false;
    }

    private static zz48 zz6(Node node) {
        zz48 zz482 = new zz48();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            zz482.push(node2);
        }
        return zz482;
    }

    private static Object zzZ(zz48 zz482, zz48 zz483) {
        Object var2_2 = null;
        while (zz482.peek() == zz483.peek()) {
            var2_2 = zz482.pop();
            zz483.pop();
            if (zz482.getCount() != 0 && zz483.getCount() != 0) continue;
            break;
        }
        return var2_2;
    }

    public static String nodeTypeToString(int nodeType) {
        switch (nodeType) {
            case 0: {
                return "Any";
            }
            case 1: {
                return "Document";
            }
            case 2: {
                return "Section";
            }
            case 3: {
                return "Body";
            }
            case 4: {
                return "HeaderFooter";
            }
            case 5: {
                return "Table";
            }
            case 6: {
                return "Row";
            }
            case 7: {
                return "Cell";
            }
            case 8: {
                return "Paragraph";
            }
            case 9: {
                return "BookmarkStart";
            }
            case 10: {
                return "BookmarkEnd";
            }
            case 17: {
                return "GroupShape";
            }
            case 18: {
                return "Shape";
            }
            case 19: {
                return "Comment";
            }
            case 20: {
                return "Footnote";
            }
            case 21: {
                return "Run";
            }
            case 22: {
                return "FieldStart";
            }
            case 23: {
                return "FieldSeparator";
            }
            case 24: {
                return "FieldEnd";
            }
            case 25: {
                return "FormField";
            }
            case 26: {
                return "SpecialChar";
            }
            case 27: {
                return "SmartTag";
            }
            case 28: {
                return "CustomXmlMarkup";
            }
            case 29: {
                return "StructuredDocumentTag";
            }
            case 30: {
                return "GlossaryDocument";
            }
            case 31: {
                return "BuildingBlock";
            }
            case 32: {
                return "CommentRangeStart";
            }
            case 33: {
                return "CommentRangeEnd";
            }
            case 11: {
                return "EditableRangeStart";
            }
            case 12: {
                return "EditableRangeEnd";
            }
            case 34: {
                return "DrawingML";
            }
            case 35: {
                return "OfficeMath";
            }
            case 36: {
                return "SubDocument";
            }
            case 37: {
                return "System";
            }
            case 38: {
                return "Null";
            }
        }
        return "Unknown node type.";
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }
}

