/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zz49;
import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.Node;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.zz5N;
import com.aspose.words.zzZX8;
import com.aspose.words.zzZXI;
import com.aspose.words.zzZXM;
import java.util.ArrayList;
import java.util.Iterator;

public class NodeCollection<T extends Node>
implements zz5N,
Iterable<T> {
    private CompositeNode zzZef;
    private DocumentBase zzZwP;
    private boolean zzZGc;
    private int zzZee;
    private int zzZed;
    private Node zzZec;
    private int zzZT;
    private zzZXI zzZeb;

    NodeCollection(CompositeNode container, int nodeType, boolean isDeep) {
        this(container, new zzZX8(nodeType), isDeep);
    }

    NodeCollection(CompositeNode container, zzZXI matcher, boolean isDeep) {
        if (container == null) {
            throw new IllegalArgumentException("container");
        }
        if (matcher == null) {
            throw new IllegalArgumentException("matcher");
        }
        this.zzZef = container;
        this.zzZwP = container.getDocument();
        this.zzZeb = matcher;
        this.zzZGc = isDeep;
        this.invalidate();
    }

    public Node get(int index) {
        try {
            this.zzZED();
            if (index < 0 && (index = this.getCount() + index) < 0) {
                return null;
            }
            if (this.zzZed == index) {
                return this.zzZec;
            }
            int n = index - this.zzZed;
            Node node = this.zzV(this.zzZec, n);
            if (node != null) {
                this.zzZed = index;
                this.zzZec = node;
            }
            return node;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void add(Node node) {
        if (this.zzZGc) {
            throw new UnsupportedOperationException("Adding nodes is not yet supported for deep node collections.");
        }
        this.zzZef.appendChild(node);
    }

    public void insert(int index, Node node) {
        if (this.zzZGc) {
            throw new UnsupportedOperationException("Inserting nodes is not yet supported for deep node collections.");
        }
        this.zzZef.insertBefore(node, this.get(index));
    }

    public void remove(Node node) {
        node.remove();
    }

    public void removeAt(int index) {
        this.get(index).remove();
    }

    public void clear() {
        for (Node node : this) {
            node.remove();
        }
    }

    public boolean contains(Node node) {
        return this.indexOf(node) != -1;
    }

    public int indexOf(Node node) {
        int n = 0;
        for (Node node2 : this) {
            if (node == node2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Node[] toArray() {
        return (Node[])zz49.zzZ(this.zzZEE(), Node.class);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzZXM(this);
    }

    ArrayList zzZEE() {
        ArrayList arrayList = new ArrayList();
        for (Node node : this) {
            zz49.zzZ(arrayList, node);
        }
        return arrayList;
    }

    private Node zzV(Node node, int n) {
        boolean bl;
        boolean bl2 = bl = n > 0;
        if (n < 0) {
            n = -n;
        }
        Node node2 = node;
        for (int i = 0; i < n; ++i) {
            Node[] nodeArray = new Node[]{node2};
            this.zzZ(nodeArray, bl);
            node2 = nodeArray[0];
            if (node2 != null) continue;
            return null;
        }
        return node2;
    }

    @Override
    @ReservedForInternalUse
    public Node getNextMatchingNode(Node[] curNode) {
        return this.zzZ(curNode, true);
    }

    private Node zzZ(Node[] nodeArray, boolean bl) {
        Node node;
        do {
            node = nodeArray[0];
            Node node2 = this.zzZGc ? this.zzZ(bl, nodeArray[0]) : (nodeArray[0] = this.zzZeb.zzZEh() ? this.zzX(bl, nodeArray[0]) : this.zzY(bl, nodeArray[0]));
        } while (nodeArray[0] != null && !this.zzZeb.zzk(nodeArray[0]));
        return node;
    }

    private Node zzZ(boolean bl, Node node) {
        return bl ? node.nextPreOrder(this.zzZef) : node.previousPreOrder(this.zzZef);
    }

    private Node zzY(boolean bl, Node node) {
        if (bl) {
            return node == this.zzZef ? this.zzZef.getFirstChild() : node.getNextSibling();
        }
        return node == this.zzZef ? this.zzZef.getLastChild() : node.getPreviousSibling();
    }

    private Node zzX(boolean bl, Node node) {
        if (bl) {
            return node == this.zzZef ? this.zzZef.zzgz() : node.zzZEP();
        }
        return node == this.zzZef ? this.zzZef.zzgy() : node.zzZEQ();
    }

    private void zzZED() {
        if (this.zzZee != this.zzZEC()) {
            this.invalidate();
        }
    }

    private void invalidate() {
        this.zzZee = this.zzZEC();
        this.zzZed = -1;
        this.zzZec = this.zzZef;
        this.zzZT = -1;
    }

    private int zzZEC() {
        return this.zzZwP != null ? this.zzZwP.zz9R() : 0;
    }

    public int getCount() {
        this.zzZED();
        if (this.zzZT == -1) {
            this.zzZT = zzZXM.zzZ(this);
        }
        return this.zzZT;
    }

    @Override
    @ReservedForInternalUse
    public CompositeNode getContainer() {
        return this.zzZef;
    }
}

