/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.config;

import com.atomikos.datasource.RecoverableResource;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TransactionServicePlugin;
import com.atomikos.icatch.admin.LogAdministrator;
import com.atomikos.icatch.config.Configuration;
import com.atomikos.icatch.config.UserTransactionService;
import com.atomikos.icatch.provider.ConfigProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public final class UserTransactionServiceImp
implements Serializable,
UserTransactionService {
    private static final long serialVersionUID = -3374591336514451887L;
    private Properties properties_;
    private List<TransactionServicePlugin> tsListeners_ = new ArrayList<TransactionServicePlugin>();
    private List<LogAdministrator> logAdministrators_ = new ArrayList<LogAdministrator>();
    private List<RecoverableResource> resources_ = new ArrayList<RecoverableResource>();

    public UserTransactionServiceImp() {
        this.properties_ = new Properties();
    }

    public UserTransactionServiceImp(Properties properties) {
        this();
        this.properties_ = properties;
    }

    @Override
    public void shutdown(boolean force) throws IllegalStateException {
        Configuration.shutdown(force);
    }

    private void initialize() {
        for (RecoverableResource resource : this.resources_) {
            Configuration.addResource(resource);
        }
        for (LogAdministrator logAdministrator : this.logAdministrators_) {
            Configuration.addLogAdministrator(logAdministrator);
        }
        for (TransactionServicePlugin nxt : this.tsListeners_) {
            Configuration.registerTransactionServicePlugin(nxt);
        }
        ConfigProperties configProps = Configuration.getConfigProperties();
        configProps.applyUserSpecificProperties(this.properties_);
        Configuration.init();
    }

    @Override
    public CompositeTransactionManager getCompositeTransactionManager() {
        return Configuration.getCompositeTransactionManager();
    }

    @Override
    public void registerResource(RecoverableResource res) {
        Configuration.addResource(res);
    }

    @Override
    public void registerLogAdministrator(LogAdministrator admin) {
        Configuration.addLogAdministrator(admin);
    }

    @Override
    public void removeResource(RecoverableResource res) {
        Configuration.removeResource(res.getName());
    }

    @Override
    public void removeLogAdministrator(LogAdministrator admin) {
        Configuration.removeLogAdministrator(admin);
    }

    @Override
    public void registerTransactionServicePlugin(TransactionServicePlugin listener) {
        Configuration.registerTransactionServicePlugin(listener);
    }

    @Override
    public void removeTransactionServicePlugin(TransactionServicePlugin listener) {
        Configuration.unregisterTransactionServicePlugin(listener);
    }

    public void shutdownForce() {
        this.shutdown(true);
    }

    public void shutdownWait() {
        this.shutdown(false);
    }

    public void setInitialRecoverableResources(List<RecoverableResource> resources) {
        this.resources_ = resources;
    }

    public void setInitialLogAdministrators(List<LogAdministrator> administrators) {
        this.logAdministrators_ = administrators;
    }

    public void setInitialTransactionServicePlugins(List<TransactionServicePlugin> listeners) {
        this.tsListeners_ = listeners;
    }

    @Override
    public void init() {
        this.initialize();
    }

    @Override
    public void init(Properties properties) throws SysException {
        this.properties_ = properties;
        this.initialize();
    }

    @Override
    public void shutdown(long maxWaitTime) throws IllegalStateException {
        Configuration.shutdown(maxWaitTime);
    }
}

