/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.admin.imp;

import com.atomikos.icatch.admin.AdminTransaction;
import com.atomikos.icatch.admin.LogControl;
import com.atomikos.icatch.admin.imp.AdminTransactionImp;
import com.atomikos.recovery.AdminLog;
import com.atomikos.recovery.CoordinatorLogEntry;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class LogControlImp
implements LogControl {
    private final AdminLog adminLog;

    public LogControlImp(AdminLog adminLog) {
        this.adminLog = adminLog;
    }

    private AdminTransaction[] getAdminTransactions() {
        CoordinatorLogEntry[] tids = this.adminLog.getCoordinatorLogEntries();
        AdminTransaction[] ret = new AdminTransaction[tids.length];
        for (int i = 0; i < tids.length; ++i) {
            ret[i] = this.convertToAdminTransaction(tids[i]);
        }
        return ret;
    }

    private AdminTransactionImp convertToAdminTransaction(CoordinatorLogEntry coordinatorLogEntry) {
        return new AdminTransactionImp(coordinatorLogEntry, this.adminLog);
    }

    public AdminTransaction[] getAdminTransactions(String ... tids) {
        if (tids.length == 0) {
            return this.getAdminTransactions();
        }
        List<String> tidsToFind = Arrays.asList(tids);
        CoordinatorLogEntry[] pendingCoordinatorEntries = this.adminLog.getCoordinatorLogEntries();
        HashSet<AdminTransactionImp> adminTransactions = new HashSet<AdminTransactionImp>();
        for (CoordinatorLogEntry pendingCoordinatorEntry : pendingCoordinatorEntries) {
            if (!tidsToFind.contains(pendingCoordinatorEntry.id)) continue;
            adminTransactions.add(this.convertToAdminTransaction(pendingCoordinatorEntry));
        }
        return adminTransactions.toArray(new AdminTransaction[adminTransactions.size()]);
    }
}

