/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt.algorithms;

import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.algorithms.CryptoHelper;
import com.auth0.jwt.exceptions.SignatureGenerationException;
import com.auth0.jwt.exceptions.SignatureVerificationException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;

class ECDSAAlgorithm
extends Algorithm {
    private final CryptoHelper crypto;
    private final int ecNumberSize;
    private final ECKey key;

    ECDSAAlgorithm(CryptoHelper crypto, String id, String algorithm, int ecNumberSize, ECKey key) throws IllegalArgumentException {
        super(id, algorithm);
        if (key == null) {
            throw new IllegalArgumentException("The ECKey cannot be null");
        }
        this.ecNumberSize = ecNumberSize;
        this.key = key;
        this.crypto = crypto;
    }

    ECDSAAlgorithm(String id, String algorithm, int ecNumberSize, ECKey key) throws IllegalArgumentException {
        this(new CryptoHelper(), id, algorithm, ecNumberSize, key);
    }

    ECKey getKey() {
        return this.key;
    }

    @Override
    public void verify(byte[] contentBytes, byte[] signatureBytes) throws SignatureVerificationException {
        try {
            boolean valid;
            if (!(this.key instanceof ECPublicKey)) {
                throw new IllegalArgumentException("The given ECKey is not an ECPublicKey.");
            }
            if (!this.isDERSignature(signatureBytes)) {
                signatureBytes = this.JOSEToDER(signatureBytes);
            }
            if (!(valid = this.crypto.verifySignatureFor(this.getDescription(), (ECPublicKey)this.key, contentBytes, signatureBytes))) {
                throw new SignatureVerificationException(this);
            }
        }
        catch (IllegalArgumentException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new SignatureVerificationException(this, (Throwable)e);
        }
    }

    @Override
    public byte[] sign(byte[] contentBytes) throws SignatureGenerationException {
        try {
            if (!(this.key instanceof ECPrivateKey)) {
                throw new IllegalArgumentException("The given ECKey is not a ECPrivateKey.");
            }
            return this.crypto.createSignatureFor(this.getDescription(), (PrivateKey)((Object)this.key), contentBytes);
        }
        catch (IllegalArgumentException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new SignatureGenerationException(this, (Throwable)e);
        }
    }

    private boolean isDERSignature(byte[] signature) {
        return signature[0] == 48 && signature.length != this.ecNumberSize * 2;
    }

    private byte[] JOSEToDER(byte[] joseSignature) throws SignatureException {
        int offset;
        byte[] derSignature;
        int sPadding;
        int sLength;
        if (joseSignature.length != this.ecNumberSize * 2) {
            throw new SignatureException(String.format("The signature length was invalid. Expected %d bytes but received %d", this.ecNumberSize * 2, joseSignature.length));
        }
        int rPadding = this.countPadding(joseSignature, 0, this.ecNumberSize);
        int rLength = this.ecNumberSize - rPadding;
        int length = 2 + rLength + 2 + (sLength = this.ecNumberSize - (sPadding = this.countPadding(joseSignature, this.ecNumberSize, joseSignature.length)));
        if (length > 255) {
            throw new SignatureException("Invalid ECDSA signature format");
        }
        if (length > 127) {
            derSignature = new byte[3 + length];
            derSignature[1] = -127;
            offset = 2;
        } else {
            derSignature = new byte[2 + length];
            offset = 1;
        }
        derSignature[0] = 48;
        derSignature[offset++] = (byte)length;
        derSignature[offset++] = 2;
        derSignature[offset++] = (byte)rLength;
        System.arraycopy(joseSignature, 0, derSignature, offset + (rLength - this.ecNumberSize), this.ecNumberSize);
        offset += rLength;
        derSignature[offset++] = 2;
        derSignature[offset++] = (byte)sLength;
        System.arraycopy(joseSignature, this.ecNumberSize, derSignature, offset + (sLength - this.ecNumberSize), this.ecNumberSize);
        return derSignature;
    }

    private int countPadding(byte[] bytes, int fromIndex, int toIndex) {
        int padding = 0;
        while (fromIndex + padding < toIndex && bytes[fromIndex + padding] == 0) {
            ++padding;
        }
        return bytes[fromIndex + padding] > 127 ? padding : padding - 1;
    }
}

