/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt.algorithms;

import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.algorithms.CryptoHelper;
import com.auth0.jwt.exceptions.SignatureGenerationException;
import com.auth0.jwt.exceptions.SignatureVerificationException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

class RSAAlgorithm
extends Algorithm {
    private final RSAKey key;
    private final CryptoHelper crypto;

    RSAAlgorithm(CryptoHelper crypto, String id, String algorithm, RSAKey key) throws IllegalArgumentException {
        super(id, algorithm);
        if (key == null) {
            throw new IllegalArgumentException("The RSAKey cannot be null");
        }
        this.key = key;
        this.crypto = crypto;
    }

    RSAAlgorithm(String id, String algorithm, RSAKey key) throws IllegalArgumentException {
        this(new CryptoHelper(), id, algorithm, key);
    }

    RSAKey getKey() {
        return this.key;
    }

    @Override
    public void verify(byte[] contentBytes, byte[] signatureBytes) throws SignatureVerificationException {
        try {
            if (!(this.key instanceof PublicKey)) {
                throw new IllegalArgumentException("The given RSAKey is not a RSAPublicKey.");
            }
            boolean valid = this.crypto.verifySignatureFor(this.getDescription(), (RSAPublicKey)this.key, contentBytes, signatureBytes);
            if (!valid) {
                throw new SignatureVerificationException(this);
            }
        }
        catch (IllegalArgumentException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new SignatureVerificationException(this, (Throwable)e);
        }
    }

    @Override
    public byte[] sign(byte[] contentBytes) throws SignatureGenerationException {
        try {
            if (!(this.key instanceof PrivateKey)) {
                throw new IllegalArgumentException("The given RSAKey is not a RSAPrivateKey.");
            }
            return this.crypto.createSignatureFor(this.getDescription(), (RSAPrivateKey)this.key, contentBytes);
        }
        catch (IllegalArgumentException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new SignatureGenerationException(this, (Throwable)e);
        }
    }
}

